<?php

namespace Database\Factories;

use App\Models\VirtualCard;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\VirtualCard>
 */
class VirtualCardFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'card_id' => $this->faker->uuid(),
            'masked_pan' => '**** **** **** ' . $this->faker->numberBetween(1000, 9999),
            'card_type' => $this->faker->randomElement(['virtual', 'physical']),
            'brand' => $this->faker->randomElement(['visa', 'mastercard']),
            'currency' => $this->faker->randomElement(['USD', 'NGN']),
            'balance' => $this->faker->randomFloat(2, 0, 10000),
            'daily_limit' => $this->faker->randomFloat(2, 100, 5000),
            'monthly_limit' => $this->faker->randomFloat(2, 1000, 50000),
            'status' => $this->faker->randomElement(['active', 'frozen', 'terminated']),
            'provider' => $this->faker->randomElement(['bloc', 'wallets_africa']),
            'provider_reference' => $this->faker->unique()->uuid(),
            'metadata' => json_encode([
                'provider_data' => $this->faker->words(3, true)
            ]),
            'expires_at' => $this->faker->dateTimeBetween('now', '+3 years'),
        ];
    }

    /**
     * Indicate that the card is active.
     */
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'active',
        ]);
    }

    /**
     * Indicate that the card is frozen.
     */
    public function frozen(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'frozen',
        ]);
    }

    /**
     * Indicate that the card is terminated.
     */
    public function terminated(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'terminated',
        ]);
    }
}