<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureKycVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!$request->user()) {
            return redirect()->route('login');
        }

        if (!$request->user()->hasCompletedKyc()) {
            if ($request->expectsJson()) {
                return response()->json([
                    'success' => false,
                    'message' => 'KYC verification required to access this resource.',
                    'error_code' => 'KYC_REQUIRED'
                ], 403);
            }

            return redirect()->route('kyc.index')
                ->with('error', 'Please complete your KYC verification to continue.');
        }

        return $next($request);
    }
}