<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            // Payment Services
            [
                'name' => 'Paystack',
                'type' => 'payment',
                'status' => 'active',
                'config' => json_encode([
                    'public_key' => env('PAYSTACK_PUBLIC_KEY'),
                    'secret_key' => env('PAYSTACK_SECRET_KEY'),
                    'base_url' => env('PAYSTACK_PAYMENT_URL', 'https://api.paystack.co'),
                ]),
            ],
            [
                'name' => 'Monnify',
                'type' => 'virtual_account',
                'status' => 'active',
                'config' => json_encode([
                    'api_key' => env('MONNIFY_API_KEY'),
                    'secret_key' => env('MONNIFY_SECRET_KEY'),
                    'contract_code' => env('MONNIFY_CONTRACT_CODE'),
                    'base_url' => env('MONNIFY_BASE_URL', 'https://api.monnify.com'),
                ]),
            ],
            [
                'name' => 'Anchor',
                'type' => 'virtual_account',
                'status' => 'active',
                'config' => json_encode([
                    'secret_key' => env('ANCHOR_SECRET_KEY'),
                    'public_key' => env('ANCHOR_PUBLIC_KEY'),
                    'base_url' => env('ANCHOR_BASE_URL', 'https://api.getanchor.co'),
                ]),
            ],
            
            // Bill Payment Services
            [
                'name' => 'VTPass',
                'type' => 'bill_payment',
                'status' => 'active',
                'config' => json_encode([
                    'username' => env('VTPASS_USERNAME'),
                    'password' => env('VTPASS_PASSWORD'),
                    'base_url' => env('VTPASS_BASE_URL', 'https://vtpass.com/api'),
                ]),
            ],
            
            // KYC Services
            [
                'name' => 'Dojah',
                'type' => 'kyc',
                'status' => 'active',
                'config' => json_encode([
                    'app_id' => env('DOJAH_APP_ID'),
                    'secret_key' => env('DOJAH_SECRET_KEY'),
                    'base_url' => env('DOJAH_BASE_URL', 'https://api.dojah.io'),
                ]),
            ],
            [
                'name' => 'VerifyMe',
                'type' => 'kyc',
                'status' => 'active',
                'config' => json_encode([
                    'username' => env('VERIFYME_USERNAME'),
                    'password' => env('VERIFYME_PASSWORD'),
                    'base_url' => env('VERIFYME_BASE_URL', 'https://api.verifymy.co.uk'),
                ]),
            ],
            
            // Virtual Card Services
            [
                'name' => 'Bloc',
                'type' => 'virtual_card',
                'status' => 'active',
                'config' => json_encode([
                    'secret_key' => env('BLOC_SECRET_KEY'),
                    'public_key' => env('BLOC_PUBLIC_KEY'),
                    'base_url' => env('BLOC_BASE_URL', 'https://api.blochq.io'),
                ]),
            ],
            [
                'name' => 'Wallets Africa',
                'type' => 'virtual_card',
                'status' => 'active',
                'config' => json_encode([
                    'public_key' => env('WALLETS_AFRICA_PUBLIC_KEY'),
                    'secret_key' => env('WALLETS_AFRICA_SECRET_KEY'),
                    'base_url' => env('WALLETS_AFRICA_BASE_URL', 'https://api.wallets.africa'),
                ]),
            ],
        ];

        foreach ($services as $service) {
            Service::create($service);
        }
    }
}