<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\KycController;
use App\Http\Controllers\VirtualAccountController;
use App\Http\Controllers\BillPaymentController;
use App\Http\Controllers\VirtualCardController;
use App\Http\Controllers\AdminAuthController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Authentication Routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/register', [AuthController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [AuthController::class, 'register']);
    Route::get('/verify-phone', [AuthController::class, 'showVerifyPhone'])->name('verify.phone');
    Route::post('/verify-phone', [AuthController::class, 'verifyPhone']);
});

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Admin Authentication Routes
Route::prefix('admin')->group(function () {
    Route::middleware('guest:admin')->group(function () {
        Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('admin.login');
        Route::post('/login', [AdminAuthController::class, 'login']);
    });
    
    Route::middleware('auth:admin')->group(function () {
        Route::get('/dashboard', [AdminAuthController::class, 'dashboard'])->name('admin.dashboard');
        Route::post('/logout', [AdminAuthController::class, 'logout'])->name('admin.logout');
    });
});

// Authenticated User Routes
Route::middleware(['auth', 'kyc.verified'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Wallet Routes
    Route::prefix('wallet')->group(function () {
        Route::get('/', [WalletController::class, 'index'])->name('wallet.index');
        Route::post('/fund', [WalletController::class, 'fund'])->name('wallet.fund');
        Route::get('/transactions', [TransactionController::class, 'index'])->name('transactions.index');
    });
    
    // Virtual Account Routes
    Route::prefix('virtual-account')->group(function () {
        Route::get('/', [VirtualAccountController::class, 'index'])->name('virtual-account.index');
        Route::post('/create', [VirtualAccountController::class, 'create'])->name('virtual-account.create');
    });
    
    // Transfer Routes
    Route::prefix('transfer')->group(function () {
        Route::get('/p2p', [TransactionController::class, 'showP2PForm'])->name('transfer.p2p');
        Route::post('/p2p', [TransactionController::class, 'p2pTransfer']);
        Route::get('/bank', [TransactionController::class, 'showBankTransferForm'])->name('transfer.bank');
        Route::post('/bank', [TransactionController::class, 'bankTransfer']);
    });
    
    // Bill Payment Routes
    Route::prefix('bills')->group(function () {
        Route::get('/', [BillPaymentController::class, 'index'])->name('bills.index');
        Route::get('/airtime', [BillPaymentController::class, 'showAirtimeForm'])->name('bills.airtime');
        Route::post('/airtime', [BillPaymentController::class, 'purchaseAirtime']);
        Route::get('/data', [BillPaymentController::class, 'showDataForm'])->name('bills.data');
        Route::post('/data', [BillPaymentController::class, 'purchaseData']);
        Route::get('/electricity', [BillPaymentController::class, 'showElectricityForm'])->name('bills.electricity');
        Route::post('/electricity', [BillPaymentController::class, 'payElectricity']);
    });
    
    // Virtual Card Routes
    Route::prefix('cards')->group(function () {
        Route::get('/', [VirtualCardController::class, 'index'])->name('cards.index');
        Route::post('/create', [VirtualCardController::class, 'create'])->name('cards.create');
        Route::post('/{card}/freeze', [VirtualCardController::class, 'freeze'])->name('cards.freeze');
        Route::post('/{card}/unfreeze', [VirtualCardController::class, 'unfreeze'])->name('cards.unfreeze');
    });
});

// KYC Routes (accessible to authenticated users without KYC verification)
Route::middleware('auth')->group(function () {
    Route::prefix('kyc')->group(function () {
        Route::get('/', [KycController::class, 'index'])->name('kyc.index');
        Route::get('/bvn', [KycController::class, 'showBvnForm'])->name('kyc.bvn');
        Route::post('/bvn', [KycController::class, 'verifyBvn']);
        Route::get('/nin', [KycController::class, 'showNinForm'])->name('kyc.nin');
        Route::post('/nin', [KycController::class, 'verifyNin']);
        Route::get('/document', [KycController::class, 'showDocumentForm'])->name('kyc.document');
        Route::post('/document', [KycController::class, 'uploadDocument']);
    });
});