@extends('layouts.app')

@section('title', 'Document Upload')

@section('content')
<div class="max-w-md mx-auto">
    <div class="card">
        <div class="text-center mb-6">
            <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                </svg>
            </div>
            <h2 class="text-2xl font-bold">Document Upload</h2>
            <p class="text-gray-600 mt-2">Upload a government-issued ID document for verification</p>
        </div>
        
        <form method="POST" action="{{ route('kyc.document') }}" enctype="multipart/form-data">
            @csrf
            
            <div class="mb-4">
                <label for="document_type" class="block text-gray-700 text-sm font-bold mb-2">
                    Document Type
                </label>
                <select id="document_type" name="document_type" 
                        class="form-input @error('document_type') border-red-500 @enderror" 
                        required>
                    <option value="">Select document type</option>
                    <option value="passport" {{ old('document_type') == 'passport' ? 'selected' : '' }}>
                        International Passport
                    </option>
                    <option value="drivers_license" {{ old('document_type') == 'drivers_license' ? 'selected' : '' }}>
                        Driver's License
                    </option>
                    <option value="voters_card" {{ old('document_type') == 'voters_card' ? 'selected' : '' }}>
                        Voter's Card
                    </option>
                </select>
                @error('document_type')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label for="document" class="block text-gray-700 text-sm font-bold mb-2">
                    Document File
                </label>
                <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md hover:border-gray-400 transition-colors">
                    <div class="space-y-1 text-center">
                        <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                            <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <div class="flex text-sm text-gray-600">
                            <label for="document" class="relative cursor-pointer bg-white rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500">
                                <span>Upload a file</span>
                                <input id="document" name="document" type="file" 
                                       class="sr-only @error('document') border-red-500 @enderror" 
                                       accept=".pdf,.jpg,.jpeg,.png"
                                       required>
                            </label>
                            <p class="pl-1">or drag and drop</p>
                        </div>
                        <p class="text-xs text-gray-500">
                            PDF, PNG, JPG up to 2MB
                        </p>
                    </div>
                </div>
                @error('document')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center justify-between space-x-4">
                <a href="{{ route('kyc.index') }}" class="btn-secondary">
                    Back to KYC
                </a>
                <button type="submit" class="btn-primary flex-1">
                    Upload Document
                </button>
            </div>
        </form>

        <div class="mt-6 space-y-4">
            <div class="p-4 bg-purple-50 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-purple-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-purple-700">
                            <strong>Document Requirements:</strong>
                        </p>
                        <ul class="text-sm text-purple-700 mt-1 list-disc list-inside">
                            <li>Clear, high-quality image or scan</li>
                            <li>All text must be clearly readable</li>
                            <li>Document must be valid and not expired</li>
                            <li>File size should not exceed 2MB</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="p-4 bg-yellow-50 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-700">
                            <strong>Processing Time:</strong> Document verification typically takes 24-48 hours. You'll receive an email notification once the review is complete.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('document').addEventListener('change', function(e) {
    const fileName = e.target.files[0]?.name;
    if (fileName) {
        const label = e.target.parentElement.querySelector('span');
        label.textContent = fileName;
    }
});
</script>
@endsection