<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TransferRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'amount' => 'required|numeric|min:100|max:500000', // Min ₦100, Max ₦500,000
            'recipient_identifier' => 'required|string|max:50', // Email, phone, or account number
            'transaction_pin' => 'required|string|size:4|regex:/^[0-9]{4}$/',
            'narration' => 'nullable|string|max:500',
            'save_recipient' => 'boolean',
        ];
    }

    /**
     * Get custom error messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'amount.min' => 'Minimum transfer amount is ₦100.',
            'amount.max' => 'Maximum transfer amount is ₦500,000.',
            'transaction_pin.regex' => 'Transaction PIN must be a 4-digit number.',
            'transaction_pin.size' => 'Transaction PIN must be exactly 4 digits.',
        ];
    }
}