<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('virtual_cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('card_id')->unique(); // Provider card ID
            $table->string('masked_pan'); // Masked card number
            $table->string('card_type')->default('virtual'); // virtual, physical
            $table->string('brand'); // visa, mastercard
            $table->string('currency', 3)->default('USD');
            $table->decimal('balance', 15, 2)->default(0.00);
            $table->decimal('daily_limit', 15, 2)->default(1000.00);
            $table->decimal('monthly_limit', 15, 2)->default(5000.00);
            $table->enum('status', ['active', 'frozen', 'terminated'])->default('active');
            $table->string('provider'); // bloc, wallets_africa
            $table->string('provider_reference')->unique();
            $table->json('metadata')->nullable(); // Additional provider data
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index('provider_reference');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('virtual_cards');
    }
};