<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('airtime_providers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Provider name (e.g., VTPass, BuyPower)
            $table->string('slug')->unique(); // URL-friendly identifier
            $table->string('module'); // Module type (was ENUM, now VARCHAR for extensibility)
            $table->json('api_credentials'); // API keys, endpoints, etc.
            $table->json('supported_services'); // ['airtime', 'data', 'electricity', etc.]
            $table->json('supported_networks'); // ['mtn', 'glo', 'airtel', '9mobile']
            $table->boolean('is_active')->default(true);
            $table->boolean('is_test_mode')->default(false);
            $table->integer('priority')->default(0); // Higher priority providers tried first
            $table->decimal('success_rate', 5, 2)->default(0.00); // Calculated from transactions
            $table->integer('avg_response_time')->default(0); // In milliseconds
            $table->timestamp('last_used_at')->nullable();
            $table->json('last_test_result')->nullable(); // Result of last connectivity test
            $table->timestamps();
            
            $table->index(['is_active', 'priority']);
            $table->index(['module', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('airtime_providers');
    }
};
