<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Add virtual_card_id column if it doesn't exist
            if (!Schema::hasColumn('transactions', 'virtual_card_id')) {
                $table->foreignId('virtual_card_id')
                      ->nullable()
                      ->after('wallet_id')
                      ->constrained('virtual_cards')
                      ->onDelete('set null');
                
                // Add index for better query performance
                $table->index(['virtual_card_id', 'created_at']);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Drop the foreign key constraint and column
            if (Schema::hasColumn('transactions', 'virtual_card_id')) {
                try {
                    $table->dropIndex(['virtual_card_id', 'created_at']);
                } catch (\Exception $e) {
                    // Index may not exist, ignore the exception
                }
                $table->dropForeign(['virtual_card_id']);
                $table->dropColumn('virtual_card_id');
            }
        });
    }
};
