@extends('layouts.admin-sidebar')

@section('title', 'Virtual Card Details')
@section('page-title', 'Virtual Card Details')
@section('page-description', 'View and manage virtual card information')

@section('content')
<div class="space-y-6">
    <!-- Card Overview -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">Card Information</h3>
                <div class="flex items-center space-x-2">
                    <a href="{{ route('admin.virtual-cards.index') }}" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        ← Back to Cards
                    </a>
                </div>
            </div>
        </div>

        <div class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Card Visual -->
                <div class="space-y-6">
                    <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-xl p-6 text-white relative overflow-hidden">
                        <div class="absolute top-4 right-4">
                            @if($virtualCard->brand === 'visa')
                                <div class="text-2xl font-bold">VISA</div>
                            @else
                                <div class="text-2xl font-bold">MC</div>
                            @endif
                        </div>
                        <div class="mt-8">
                            <div class="text-lg font-mono tracking-wider">{{ $virtualCard->masked_pan }}</div>
                        </div>
                        <div class="mt-6 flex justify-between items-end">
                            <div>
                                <div class="text-xs opacity-75">CARDHOLDER</div>
                                <div class="font-medium">{{ $virtualCard->user->full_name }}</div>
                            </div>
                            <div>
                                <div class="text-xs opacity-75">EXPIRES</div>
                                <div class="font-medium">{{ $virtualCard->expires_at ? $virtualCard->expires_at->format('m/y') : 'N/A' }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Card Stats -->
                    <div class="grid grid-cols-2 gap-4">
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="text-sm text-gray-600">Current Balance</div>
                            <div class="text-xl font-bold text-gray-900">{{ $virtualCard->currency }} {{ number_format($virtualCard->balance, 2) }}</div>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="text-sm text-gray-600">Daily Limit</div>
                            <div class="text-xl font-bold text-gray-900">{{ $virtualCard->currency }} {{ number_format($virtualCard->daily_limit, 2) }}</div>
                        </div>
                    </div>
                </div>

                <!-- Card Details -->
                <div class="space-y-6">
                    <div>
                        <h4 class="text-lg font-medium text-gray-900 mb-4">Card Details</h4>
                        <dl class="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-2">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Card ID</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $virtualCard->card_id }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    @if($virtualCard->status === 'active')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-800">Active</span>
                                    @elseif($virtualCard->status === 'frozen')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-amber-100 text-amber-800">Frozen</span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-red-100 text-red-800">{{ ucfirst($virtualCard->status) }}</span>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Provider</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst(str_replace('-', ' ', $virtualCard->provider)) }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Card Type</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($virtualCard->card_type) }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Brand</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($virtualCard->brand) }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Currency</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->currency }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Monthly Limit</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->currency }} {{ number_format($virtualCard->monthly_limit, 2) }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Created At</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->created_at->format('M d, Y \a\t g:i A') }}</dd>
                            </div>
                        </dl>
                    </div>

                    <!-- User Information -->
                    <div>
                        <h4 class="text-lg font-medium text-gray-900 mb-4">Cardholder Information</h4>
                        <dl class="grid grid-cols-1 gap-x-4 gap-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Name</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->user->full_name }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Email</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->user->email }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Phone</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $virtualCard->user->phone ?? 'Not provided' }}</dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <div class="flex flex-wrap gap-3">
                    @if($virtualCard->status !== 'terminated')
                        <button onclick="showCreditModal({{ $virtualCard->id }}, '{{ $virtualCard->masked_pan }}', {{ $virtualCard->balance }}, '{{ $virtualCard->currency }}')" class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors">
                            Credit Card
                        </button>

                        @if($virtualCard->balance > 0)
                            <button onclick="showDebitModal({{ $virtualCard->id }}, '{{ $virtualCard->masked_pan }}', {{ $virtualCard->balance }}, '{{ $virtualCard->currency }}')" class="px-4 py-2 bg-amber-600 text-white rounded-lg hover:bg-amber-700 transition-colors">
                                Debit Card
                            </button>
                        @endif

                        @if($virtualCard->status === 'active')
                            <form action="{{ route('admin.virtual-cards.freeze', $virtualCard) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit" class="px-4 py-2 bg-amber-600 text-white rounded-lg hover:bg-amber-700 transition-colors" onclick="return confirm('Are you sure you want to freeze this card?')">
                                    Freeze Card
                                </button>
                            </form>
                        @elseif($virtualCard->status === 'frozen')
                            <form action="{{ route('admin.virtual-cards.unfreeze', $virtualCard) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit" class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors">
                                    Unfreeze Card
                                </button>
                            </form>
                        @endif

                        <form action="{{ route('admin.virtual-cards.terminate', $virtualCard) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition-colors" onclick="return confirm('Are you sure you want to terminate this card? This action cannot be undone.')">
                                Terminate Card
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if(isset($virtualCard->metadata) && is_array($virtualCard->metadata))
    <!-- Provider Metadata -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">Provider Information</h3>
        </div>
        <div class="p-6">
            <pre class="bg-gray-50 rounded-lg p-4 text-xs overflow-auto">{{ json_encode($virtualCard->metadata, JSON_PRETTY_PRINT) }}</pre>
        </div>
    </div>
    @endif
</div>

<!-- Include credit/debit modals (reuse from index page) -->
@include('admin.virtual-cards.partials.credit-debit-modals')

@endsection