@extends('layouts.mobile')

@section('title', 'Card Settings')

@section('content')
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="{{ route('cards.index') }}" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Card Settings</h1>
                <p class="text-sm text-gray-400">Manage your card preferences</p>
            </div>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm">Please fix the following errors:</span>
            </div>
            <ul class="mt-2 text-red-400 text-sm">
                @foreach ($errors->all() as $error)
                    <li class="ml-4">• {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(session('success'))
        <div class="bg-green-500/20 border border-green-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-400 mr-2"></i>
                <span class="text-green-400 text-sm">{{ session('success') }}</span>
            </div>
        </div>
    @endif

    <!-- Card Preview -->
    <div class="relative mb-8">
        <div class="card-preview bg-gradient-to-br from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-6 text-white shadow-2xl relative overflow-hidden">
            <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent"></div>
            <div class="relative z-10">
                <div class="flex justify-between items-start mb-8">
                    <div>
                        <h3 class="text-lg font-semibold">{{ $displayCard->card_name ?? 'Virtual Card' }}</h3>
                        <p class="text-sm opacity-80 capitalize">{{ $displayCard->card_type }} Card</p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-80">Status</p>
                        <p class="font-semibold capitalize">{{ $displayCard->status }}</p>
                    </div>
                </div>
                
                <div class="mb-6">
                    <p class="text-2xl font-mono tracking-wider">{{ $displayCard->card_number }}</p>
                </div>
                
                <div class="flex justify-between items-end">
                    <div>
                        <p class="text-xs opacity-80">Spending Limit</p>
                        <p class="font-semibold">{{ $displayCard->currency === 'USD' ? '$' : '₦' }}{{ number_format($displayCard->spending_limit) }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-80">Balance</p>
                        <p class="font-semibold">{{ $displayCard->currency === 'USD' ? '$' : '₦' }}{{ number_format($displayCard->balance, 2) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <form method="POST" action="{{ route('cards.settings.update', $displayCard->id) }}" class="space-y-6">
        @csrf
        @method('PUT')

        <!-- Card Status -->
        <div class="space-y-3">
            <label class="text-white font-medium">Card Status</label>
            <div class="grid grid-cols-2 gap-4">
                <input type="radio" id="status_active" name="status" value="active" class="hidden status-radio" 
                       {{ $displayCard->status === 'active' ? 'checked' : '' }}>
                <label for="status_active" class="status-option card-gradient border border-gray-600 rounded-xl p-4 cursor-pointer transition-all duration-200 hover:border-primary-500">
                    <div class="text-center">
                        <div class="w-12 h-12 mx-auto mb-3 bg-green-500 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-white"></i>
                        </div>
                        <p class="text-white font-medium">Active</p>
                        <p class="text-gray-400 text-xs">Card can be used for transactions</p>
                    </div>
                </label>

                <input type="radio" id="status_frozen" name="status" value="frozen" class="hidden status-radio"
                       {{ $displayCard->status === 'frozen' ? 'checked' : '' }}>
                <label for="status_frozen" class="status-option card-gradient border border-gray-600 rounded-xl p-4 cursor-pointer transition-all duration-200 hover:border-primary-500">
                    <div class="text-center">
                        <div class="w-12 h-12 mx-auto mb-3 bg-yellow-500 rounded-full flex items-center justify-center">
                            <i class="fas fa-snowflake text-white"></i>
                        </div>
                        <p class="text-white font-medium">Frozen</p>
                        <p class="text-gray-400 text-xs">Temporarily disable transactions</p>
                    </div>
                </label>
            </div>
        </div>

        <!-- Spending Limit -->
        <div class="space-y-3">
            <label for="spending_limit" class="text-white font-medium">Spending Limit</label>
            <div class="grid grid-cols-3 gap-3 mb-4">
                @foreach([50000, 100000, 500000] as $limit)
                    <input type="radio" id="limit_{{ $limit }}" name="spending_limit_preset" value="{{ $limit }}" class="hidden limit-radio"
                           {{ $displayCard->spending_limit == $limit ? 'checked' : '' }}>
                    <label for="limit_{{ $limit }}" class="limit-option card-gradient border border-gray-600 rounded-xl p-3 text-center cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <span class="text-white font-medium">₦{{ number_format($limit) }}</span>
                    </label>
                @endforeach
            </div>
            
            <div class="relative">
                <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400">₦</span>
                <input type="number" 
                       id="spending_limit" 
                       name="spending_limit" 
                       value="{{ $displayCard->spending_limit }}"
                       placeholder="100000" 
                       min="1000" 
                       max="1000000"
                       class="w-full pl-8 pr-4 py-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                       required>
            </div>
            <p class="text-xs text-gray-400">Set maximum amount for single transactions (₦1,000 - ₦1,000,000)</p>
        </div>

        <!-- Transaction Notifications -->
        <div class="space-y-4">
            <h3 class="text-white font-medium">Transaction Notifications</h3>
            
            <div class="space-y-3">
                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">SMS Notifications</p>
                        <p class="text-gray-400 text-sm">Receive SMS for all transactions</p>
                    </div>
                    <input type="checkbox" name="sms_notifications" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500" checked>
                </label>

                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">Email Notifications</p>
                        <p class="text-gray-400 text-sm">Receive email for all transactions</p>
                    </div>
                    <input type="checkbox" name="email_notifications" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500" checked>
                </label>

                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">Push Notifications</p>
                        <p class="text-gray-400 text-sm">Receive app notifications for transactions</p>
                    </div>
                    <input type="checkbox" name="push_notifications" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500" checked>
                </label>
            </div>
        </div>

        <!-- Transaction Limits -->
        <div class="space-y-4">
            <h3 class="text-white font-medium">Daily Transaction Limits</h3>
            
            <div class="space-y-3">
                <div>
                    <label for="daily_transaction_limit" class="text-white font-medium">Daily Spending Limit</label>
                    <div class="relative mt-2">
                        <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400">₦</span>
                        <input type="number" 
                               id="daily_transaction_limit" 
                               name="daily_transaction_limit" 
                               value="50000"
                               placeholder="50000" 
                               min="1000" 
                               max="500000"
                               class="w-full pl-8 pr-4 py-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none">
                    </div>
                    <p class="text-xs text-gray-400 mt-1">Maximum amount you can spend per day</p>
                </div>

                <div>
                    <label for="daily_transaction_count" class="text-white font-medium">Daily Transaction Count</label>
                    <input type="number" 
                           id="daily_transaction_count" 
                           name="daily_transaction_count" 
                           value="10"
                           placeholder="10" 
                           min="1" 
                           max="50"
                           class="w-full p-4 mt-2 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none">
                    <p class="text-xs text-gray-400 mt-1">Maximum number of transactions per day</p>
                </div>
            </div>
        </div>

        <!-- Online Shopping Settings -->
        <div class="space-y-4">
            <h3 class="text-white font-medium">Online Shopping Settings</h3>
            
            <div class="space-y-3">
                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">International Transactions</p>
                        <p class="text-gray-400 text-sm">Allow payments to foreign merchants</p>
                    </div>
                    <input type="checkbox" name="international_enabled" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500">
                </label>

                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">Online Subscriptions</p>
                        <p class="text-gray-400 text-sm">Allow recurring payment subscriptions</p>
                    </div>
                    <input type="checkbox" name="subscriptions_enabled" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500" checked>
                </label>

                <label class="flex items-center justify-between p-4 card-gradient rounded-xl">
                    <div>
                        <p class="text-white font-medium">ATM Withdrawals</p>
                        <p class="text-gray-400 text-sm">Allow cash withdrawals from ATMs</p>
                    </div>
                    <input type="checkbox" name="atm_enabled" value="1" class="w-5 h-5 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500">
                </label>
            </div>
        </div>

        <!-- Save Button -->
        <button type="submit" 
                class="w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-semibold py-4 rounded-xl transition-all duration-200">
            <i class="fas fa-save mr-2"></i>
            Save Settings
        </button>
    </form>

    <!-- Danger Zone -->
    <div class="mt-8 p-6 bg-red-500/10 border border-red-500/30 rounded-xl">
        <h3 class="text-red-400 font-medium mb-4">Danger Zone</h3>
        <div class="space-y-3">
            <button onclick="resetPin()" class="w-full bg-orange-600 hover:bg-orange-700 text-white font-semibold py-3 rounded-xl transition-colors duration-200">
                <i class="fas fa-key mr-2"></i>
                Reset Card PIN
            </button>
            
            <button onclick="confirmTerminate()" class="w-full bg-red-600 hover:bg-red-700 text-white font-semibold py-3 rounded-xl transition-colors duration-200">
                <i class="fas fa-trash mr-2"></i>
                Terminate Card
            </button>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusRadios = document.querySelectorAll('.status-radio');
    const limitRadios = document.querySelectorAll('.limit-radio');
    const spendingLimitInput = document.getElementById('spending_limit');
    
    // Style selection handlers
    statusRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.status-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
            }
        });
    });
    
    limitRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.limit-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
                spendingLimitInput.value = this.value;
            }
        });
    });
    
    spendingLimitInput.addEventListener('input', function() {
        if (this.value) {
            limitRadios.forEach(radio => {
                radio.checked = false;
                radio.nextElementSibling.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
        }
    });
    
    // Initialize selected styles
    document.querySelectorAll('.status-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
    
    document.querySelectorAll('.limit-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
});

function resetPin() {
    if (confirm('Are you sure you want to reset your card PIN? You will need to set a new PIN.')) {
        // Implement PIN reset logic
        alert('PIN reset feature coming soon');
    }
}

function confirmTerminate() {
    if (confirm('Are you sure you want to terminate this card? This action cannot be undone and any remaining balance will be refunded to your wallet.')) {
        window.location.href = '{{ route("cards.index") }}#terminate';
    }
}
</script>
@endsection