@extends('layouts.mobile')

@section('title', 'Terminate Card')

@section('content')
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="{{ route('cards.index') }}" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Terminate Card</h1>
                <p class="text-sm text-gray-400">Permanently close your virtual card</p>
            </div>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm">Please fix the following errors:</span>
            </div>
            <ul class="mt-2 text-red-400 text-sm">
                @foreach ($errors->all() as $error)
                    <li class="ml-4">• {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Warning Banner -->
    <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
        <div class="flex items-start">
            <i class="fas fa-exclamation-triangle text-red-400 mr-3 mt-1"></i>
            <div>
                <h3 class="text-red-400 font-medium mb-2">Important Warning</h3>
                <p class="text-red-400 text-sm leading-relaxed">
                    Terminating your virtual card is a permanent action that cannot be undone. Once terminated, the card will be completely deactivated and you will not be able to use it for any transactions.
                </p>
            </div>
        </div>
    </div>

    <!-- Card Preview -->
    <div class="relative mb-8">
        <div class="card-preview bg-gradient-to-br from-gray-600 via-gray-700 to-gray-800 rounded-2xl p-6 text-white shadow-2xl relative overflow-hidden opacity-75">
            <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent"></div>
            <div class="relative z-10">
                <div class="flex justify-between items-start mb-8">
                    <div>
                        <h3 class="text-lg font-semibold">{{ $displayCard->card_name ?? 'Virtual Card' }}</h3>
                        <p class="text-sm opacity-80 capitalize">{{ $displayCard->card_type }} Card</p>
                        <div class="mt-2">
                            <span class="inline-flex items-center px-2 py-1 bg-red-500/20 text-red-400 text-xs font-medium rounded-full">
                                <i class="fas fa-times-circle w-3 h-3 mr-1"></i>
                                To be terminated
                            </span>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-80">Currency</p>
                        <p class="font-semibold">{{ $displayCard->currency }}</p>
                    </div>
                </div>
                
                <div class="mb-6">
                    <p class="text-2xl font-mono tracking-wider">{{ $displayCard->card_number }}</p>
                </div>
                
                <div class="flex justify-between items-end">
                    <div>
                        <p class="text-xs opacity-80">Current Balance</p>
                        <p class="font-semibold">{{ $displayCard->currency === 'USD' ? '$' : '₦' }}{{ number_format($displayCard->balance, 2) }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-80">Status</p>
                        <p class="font-semibold capitalize">{{ $displayCard->status }}</p>
                    </div>
                </div>
            </div>
            <!-- Overlay to show card being terminated -->
            <div class="absolute inset-0 bg-red-500/20 flex items-center justify-center">
                <div class="text-center">
                    <i class="fas fa-trash text-red-400 text-4xl mb-2"></i>
                    <p class="text-red-400 font-medium">TERMINATING</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Termination Details -->
    <div class="space-y-6">
        <!-- What happens when you terminate -->
        <div class="card-gradient rounded-xl p-6">
            <h3 class="text-white font-semibold mb-4 flex items-center">
                <i class="fas fa-info-circle text-blue-400 mr-2"></i>
                What happens when you terminate this card?
            </h3>
            <ul class="space-y-3 text-gray-300">
                <li class="flex items-start">
                    <i class="fas fa-check text-green-400 mr-3 mt-1"></i>
                    <span>Your card will be permanently deactivated</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-check text-green-400 mr-3 mt-1"></i>
                    <span>Any remaining balance will be refunded to your main wallet</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-check text-green-400 mr-3 mt-1"></i>
                    <span>All card details will be securely destroyed</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-times text-red-400 mr-3 mt-1"></i>
                    <span>You will not be able to recover this card</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-times text-red-400 mr-3 mt-1"></i>
                    <span>Any subscriptions using this card will fail</span>
                </li>
            </ul>
        </div>

        <!-- Balance Refund Information -->
        @if($displayCard->balance > 0)
        <div class="bg-green-500/20 border border-green-500 rounded-lg p-4">
            <div class="flex items-start">
                <i class="fas fa-money-bill-wave text-green-400 mr-3 mt-1"></i>
                <div>
                    <h3 class="text-green-400 font-medium mb-2">Balance Refund</h3>
                    <p class="text-green-400 text-sm">
                        Your remaining balance of <strong>{{ $displayCard->currency === 'USD' ? '$' : '₦' }}{{ number_format($displayCard->balance, 2) }}</strong> 
                        will be automatically refunded to your main wallet within 24 hours of termination.
                    </p>
                </div>
            </div>
        </div>
        @else
        <div class="bg-blue-500/20 border border-blue-500 rounded-lg p-4">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-400 mr-3 mt-1"></i>
                <div>
                    <h3 class="text-blue-400 font-medium mb-2">No Balance to Refund</h3>
                    <p class="text-blue-400 text-sm">
                        Your card has no remaining balance, so no refund will be processed.
                    </p>
                </div>
            </div>
        </div>
        @endif

        <!-- Active Subscriptions Warning -->
        <div class="bg-yellow-500/20 border border-yellow-500 rounded-lg p-4">
            <div class="flex items-start">
                <i class="fas fa-exclamation-triangle text-yellow-400 mr-3 mt-1"></i>
                <div>
                    <h3 class="text-yellow-400 font-medium mb-2">Active Subscriptions</h3>
                    <p class="text-yellow-400 text-sm mb-3">
                        If you have active subscriptions using this card, they will fail after termination. Please update your payment methods for:
                    </p>
                    <ul class="text-yellow-400 text-sm space-y-1">
                        <li>• Netflix, Spotify, or other streaming services</li>
                        <li>• Software subscriptions and SaaS platforms</li>
                        <li>• Online shopping auto-payments</li>
                        <li>• Any recurring bill payments</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Confirmation Form -->
        <form method="POST" action="{{ route('cards.terminate.confirm', $displayCard->id) }}" class="space-y-6">
            @csrf

            <!-- Confirmation Checkboxes -->
            <div class="space-y-4">
                <h3 class="text-white font-semibold">Please confirm the following:</h3>
                
                <label class="flex items-start space-x-3">
                    <input type="checkbox" name="confirm_understand" value="1" class="mt-1 w-4 h-4 text-red-600 bg-dark-800 border-gray-600 rounded focus:ring-red-500" required>
                    <span class="text-sm text-gray-300">
                        I understand that terminating my card is permanent and cannot be undone.
                    </span>
                </label>
                
                <label class="flex items-start space-x-3">
                    <input type="checkbox" name="confirm_subscriptions" value="1" class="mt-1 w-4 h-4 text-red-600 bg-dark-800 border-gray-600 rounded focus:ring-red-500" required>
                    <span class="text-sm text-gray-300">
                        I have updated or canceled all subscriptions and recurring payments using this card.
                    </span>
                </label>
                
                <label class="flex items-start space-x-3">
                    <input type="checkbox" name="confirm_balance" value="1" class="mt-1 w-4 h-4 text-red-600 bg-dark-800 border-gray-600 rounded focus:ring-red-500" required>
                    <span class="text-sm text-gray-300">
                        I understand that any remaining balance will be refunded to my main wallet.
                    </span>
                </label>
            </div>

            <!-- Reason for Termination -->
            <div class="space-y-2">
                <label for="termination_reason" class="text-white font-medium">Reason for Termination (Optional)</label>
                <select name="termination_reason" id="termination_reason" class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white focus:border-primary-500 focus:outline-none">
                    <option value="">Select a reason</option>
                    <option value="no_longer_needed">No longer needed</option>
                    <option value="security_concerns">Security concerns</option>
                    <option value="too_many_cards">Too many cards</option>
                    <option value="switching_providers">Switching to another provider</option>
                    <option value="technical_issues">Technical issues</option>
                    <option value="other">Other</option>
                </select>
            </div>

            <!-- Additional Comments -->
            <div class="space-y-2">
                <label for="comments" class="text-white font-medium">Additional Comments (Optional)</label>
                <textarea name="comments" id="comments" rows="3" 
                          class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                          placeholder="Let us know how we can improve our virtual card service..."></textarea>
            </div>

            <!-- Final Confirmation -->
            <div class="bg-red-500/10 border border-red-500 rounded-lg p-4">
                <label class="flex items-start space-x-3">
                    <input type="checkbox" name="final_confirm" value="1" class="mt-1 w-4 h-4 text-red-600 bg-dark-800 border-gray-600 rounded focus:ring-red-500" required>
                    <span class="text-sm text-red-300">
                        <strong>I confirm that I want to permanently terminate this virtual card.</strong> 
                        I understand this action cannot be reversed.
                    </span>
                </label>
            </div>

            <!-- Action Buttons -->
            <div class="flex space-x-4">
                <a href="{{ route('cards.index') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-semibold py-4 rounded-xl text-center transition-colors duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Cancel
                </a>
                
                <button type="submit" 
                        class="flex-1 bg-red-600 hover:bg-red-700 text-white font-semibold py-4 rounded-xl transition-colors duration-200"
                        onclick="return confirmTermination()">
                    <i class="fas fa-trash mr-2"></i>
                    Terminate Card
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function confirmTermination() {
    return confirm('This is your final warning. Are you absolutely sure you want to terminate this card? This action cannot be undone.');
}

// Enable submit button only when all required checkboxes are checked
document.addEventListener('DOMContentLoaded', function() {
    const checkboxes = document.querySelectorAll('input[type="checkbox"][required]');
    const submitBtn = document.querySelector('button[type="submit"]');
    
    function updateSubmitButton() {
        const allChecked = Array.from(checkboxes).every(checkbox => checkbox.checked);
        submitBtn.disabled = !allChecked;
        if (allChecked) {
            submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        } else {
            submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
        }
    }
    
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateSubmitButton);
    });
    
    // Initial check
    updateSubmitButton();
});
</script>
@endsection