import './bootstrap';
import Alpine from 'alpinejs';

// TODO: Add Alpine.js initialization
window.Alpine = Alpine;
Alpine.start();

// TODO: Add custom JavaScript functionality
class FintechApp {
    constructor() {
        this.init();
    }

    init() {
        this.setupEventListeners();
        this.initializeComponents();
        // TODO: Add CSRF token to axios headers
        this.setupAxios();
    }

    setupEventListeners() {
        // TODO: Add global event listeners
        document.addEventListener('DOMContentLoaded', () => {
            this.hideLoader();
            this.initializeForms();
        });
    }

    setupAxios() {
        // TODO: Configure axios defaults
        if (typeof axios !== 'undefined') {
            axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
            
            // Add CSRF token to requests
            const token = document.head.querySelector('meta[name="csrf-token"]');
            if (token) {
                axios.defaults.headers.common['X-CSRF-TOKEN'] = token.content;
            }
        }
    }

    initializeComponents() {
        // TODO: Initialize custom components
        this.initializeWalletBalance();
        this.initializeTransactionList();
        this.initializeCardManagement();
    }

    initializeForms() {
        // TODO: Add form validation and submission handling
        const forms = document.querySelectorAll('form[data-async]');
        forms.forEach(form => {
            form.addEventListener('submit', this.handleAsyncForm.bind(this));
        });
    }

    async handleAsyncForm(event) {
        event.preventDefault();
        const form = event.target;
        const submitButton = form.querySelector('button[type="submit"]');
        
        try {
            this.showButtonLoading(submitButton);
            
            const formData = new FormData(form);
            const response = await fetch(form.action, {
                method: form.method,
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            });

            const result = await response.json();
            
            if (result.success) {
                this.showSuccess(result.message);
                form.reset();
            } else {
                this.showError(result.message || 'An error occurred');
            }
        } catch (error) {
            this.showError('Network error occurred');
        } finally {
            this.hideButtonLoading(submitButton);
        }
    }

    initializeWalletBalance() {
        // TODO: Add real-time wallet balance updates
        const balanceElement = document.getElementById('wallet-balance');
        if (balanceElement) {
            // Implement wallet balance refresh
        }
    }

    initializeTransactionList() {
        // TODO: Add transaction list functionality
        const transactionList = document.getElementById('transaction-list');
        if (transactionList) {
            // Implement transaction list updates
        }
    }

    initializeCardManagement() {
        // TODO: Add card management functionality
        const cardElements = document.querySelectorAll('.virtual-card');
        cardElements.forEach(card => {
            // Add card interaction handlers
        });
    }

    showLoader() {
        const loader = document.getElementById('page-loader');
        if (loader) {
            loader.classList.remove('hidden');
        }
    }

    hideLoader() {
        const loader = document.getElementById('page-loader');
        if (loader) {
            loader.classList.add('hidden');
        }
    }

    showButtonLoading(button) {
        if (button) {
            button.disabled = true;
            button.innerHTML = '<span class="spinner mr-2"></span>Loading...';
        }
    }

    hideButtonLoading(button, originalText = 'Submit') {
        if (button) {
            button.disabled = false;
            button.innerHTML = originalText;
        }
    }

    showSuccess(message) {
        this.showNotification(message, 'success');
    }

    showError(message) {
        this.showNotification(message, 'error');
    }

    showWarning(message) {
        this.showNotification(message, 'warning');
    }

    showNotification(message, type = 'info') {
        // TODO: Implement toast notification system
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} fixed top-4 right-4 z-50 min-w-[300px]`;
        notification.innerHTML = `
            <div class="flex justify-between items-center">
                <span>${message}</span>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-lg font-bold">&times;</button>
            </div>
        `;
        
        document.body.appendChild(notification);
        
        // Auto remove after 5 seconds
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // TODO: Add utility functions
    formatCurrency(amount, currency = 'NGN') {
        return new Intl.NumberFormat('en-NG', {
            style: 'currency',
            currency: currency
        }).format(amount);
    }

    formatDate(date) {
        return new Intl.DateTimeFormat('en-NG', {
            year: 'numeric',
            month: 'long',
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        }).format(new Date(date));
    }

    copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            this.showSuccess('Copied to clipboard');
        }).catch(() => {
            this.showError('Failed to copy to clipboard');
        });
    }
}

// TODO: Initialize the application
document.addEventListener('DOMContentLoaded', () => {
    window.fintechApp = new FintechApp();
});

// TODO: Add global helper functions
window.formatCurrency = (amount, currency = 'NGN') => {
    return new Intl.NumberFormat('en-NG', {
        style: 'currency',
        currency: currency
    }).format(amount);
};

window.copyToClipboard = (text) => {
    window.fintechApp.copyToClipboard(text);
};