@extends('layouts.app')

@section('title', 'Register')

@section('content')
<div class="max-w-lg mx-auto">
    <div class="card">
        <h2 class="text-2xl font-bold text-center mb-6">Create Account</h2>
        
        <form method="POST" action="{{ route('register') }}">
            @csrf
            
            <div class="grid md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="first_name" class="block text-gray-700 text-sm font-bold mb-2">
                        First Name *
                    </label>
                    <input id="first_name" type="text" name="first_name" value="{{ old('first_name') }}" 
                           class="form-input @error('first_name') border-red-500 @enderror" 
                           required autofocus>
                    @error('first_name')
                        <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="last_name" class="block text-gray-700 text-sm font-bold mb-2">
                        Last Name *
                    </label>
                    <input id="last_name" type="text" name="last_name" value="{{ old('last_name') }}" 
                           class="form-input @error('last_name') border-red-500 @enderror" 
                           required>
                    @error('last_name')
                        <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mb-4">
                <label for="email" class="block text-gray-700 text-sm font-bold mb-2">
                    Email Address *
                </label>
                <input id="email" type="email" name="email" value="{{ old('email') }}" 
                       class="form-input @error('email') border-red-500 @enderror" 
                       required>
                @error('email')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="phone" class="block text-gray-700 text-sm font-bold mb-2">
                    Phone Number *
                </label>
                <input id="phone" type="tel" name="phone" value="{{ old('phone') }}" 
                       class="form-input @error('phone') border-red-500 @enderror" 
                       placeholder="08012345678" required>
                @error('phone')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="date_of_birth" class="block text-gray-700 text-sm font-bold mb-2">
                        Date of Birth *
                    </label>
                    <input id="date_of_birth" type="date" name="date_of_birth" value="{{ old('date_of_birth') }}" 
                           class="form-input @error('date_of_birth') border-red-500 @enderror" 
                           required>
                    @error('date_of_birth')
                        <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="gender" class="block text-gray-700 text-sm font-bold mb-2">
                        Gender *
                    </label>
                    <select id="gender" name="gender" 
                            class="form-input @error('gender') border-red-500 @enderror" 
                            required>
                        <option value="">Select Gender</option>
                        <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Male</option>
                        <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Female</option>
                        <option value="other" {{ old('gender') == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                    @error('gender')
                        <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mb-4">
                <label for="password" class="block text-gray-700 text-sm font-bold mb-2">
                    Password *
                </label>
                <input id="password" type="password" name="password" 
                       class="form-input @error('password') border-red-500 @enderror" 
                       required>
                @error('password')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label for="password_confirmation" class="block text-gray-700 text-sm font-bold mb-2">
                    Confirm Password *
                </label>
                <input id="password_confirmation" type="password" name="password_confirmation" 
                       class="form-input" required>
            </div>

            <div class="mb-6">
                <label class="flex items-start">
                    <input type="checkbox" name="terms" class="mr-2 mt-1" required>
                    <span class="text-sm text-gray-700">
                        I agree to the <a href="#" class="text-blue-600 hover:text-blue-800">Terms of Service</a> 
                        and <a href="#" class="text-blue-600 hover:text-blue-800">Privacy Policy</a>
                    </span>
                </label>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="btn-primary w-full">
                    Create Account
                </button>
            </div>
        </form>

        <div class="text-center mt-6">
            <p class="text-gray-600">
                Already have an account? 
                <a href="{{ route('login') }}" class="text-blue-600 hover:text-blue-800">Sign in</a>
            </p>
        </div>
    </div>
</div>
@endsection