@extends('layouts.app')

@section('title', 'BVN Verification')

@section('content')
<div class="max-w-md mx-auto">
    <div class="card">
        <div class="text-center mb-6">
            <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <h2 class="text-2xl font-bold">BVN Verification</h2>
            <p class="text-gray-600 mt-2">Enter your Bank Verification Number to verify your identity</p>
        </div>
        
        <form method="POST" action="{{ route('kyc.bvn') }}">
            @csrf
            
            <div class="mb-4">
                <label for="bvn" class="block text-gray-700 text-sm font-bold mb-2">
                    BVN (Bank Verification Number)
                </label>
                <input id="bvn" type="text" name="bvn" value="{{ old('bvn') }}" 
                       class="form-input @error('bvn') border-red-500 @enderror" 
                       placeholder="Enter your 11-digit BVN"
                       maxlength="11"
                       required>
                @error('bvn')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="first_name" class="block text-gray-700 text-sm font-bold mb-2">
                    First Name
                </label>
                <input id="first_name" type="text" name="first_name" value="{{ old('first_name') }}" 
                       class="form-input @error('first_name') border-red-500 @enderror" 
                       placeholder="Enter your first name"
                       required>
                @error('first_name')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="last_name" class="block text-gray-700 text-sm font-bold mb-2">
                    Last Name
                </label>
                <input id="last_name" type="text" name="last_name" value="{{ old('last_name') }}" 
                       class="form-input @error('last_name') border-red-500 @enderror" 
                       placeholder="Enter your last name"
                       required>
                @error('last_name')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label for="date_of_birth" class="block text-gray-700 text-sm font-bold mb-2">
                    Date of Birth
                </label>
                <input id="date_of_birth" type="date" name="date_of_birth" value="{{ old('date_of_birth') }}" 
                       class="form-input @error('date_of_birth') border-red-500 @enderror" 
                       required>
                @error('date_of_birth')
                    <p class="text-red-500 text-xs italic mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center justify-between space-x-4">
                <a href="{{ route('kyc.index') }}" class="btn-secondary">
                    Back to KYC
                </a>
                <button type="submit" class="btn-primary flex-1">
                    Verify BVN
                </button>
            </div>
        </form>

        <div class="mt-6 p-4 bg-blue-50 rounded-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="w-5 h-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-blue-700">
                        <strong>Note:</strong> Your BVN information is encrypted and stored securely. We use this information only for identity verification purposes as required by Nigerian financial regulations.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection