<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\TransactionController;
use App\Http\Controllers\Api\KycController;
use App\Http\Controllers\Api\VirtualAccountController; // TODO: Create this controller
use App\Http\Controllers\Api\BillPaymentController; // TODO: Create this controller
use App\Http\Controllers\Api\VirtualCardController; // TODO: Create this controller
use App\Http\Controllers\WebhookController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
| TODO: Add API versioning (v1, v2, etc.)
| TODO: Add comprehensive rate limiting
| TODO: Add request/response logging
| TODO: Add API authentication documentation
*/

// Public API Routes
// TODO: Add rate limiting middleware for authentication endpoints
// TODO: Add CAPTCHA for registration to prevent spam
// TODO: Add password strength validation
Route::post('/auth/register', [AuthController::class, 'register']);
Route::post('/auth/login', [AuthController::class, 'login']);
Route::post('/auth/verify-phone', [AuthController::class, 'verifyPhone']);
Route::post('/auth/resend-otp', [AuthController::class, 'resendOtp']);
// TODO: Add forgot password endpoints
// TODO: Add reset password endpoints
// TODO: Add account verification endpoints

// Webhook Routes (no authentication required)
// TODO: Add webhook signature verification middleware
// TODO: Add webhook rate limiting
// TODO: Add webhook retry mechanisms
// TODO: Add webhook event logging
Route::prefix('webhooks')->group(function () {
    Route::post('/paystack', [WebhookController::class, 'paystack']);
    Route::post('/monnify', [WebhookController::class, 'monnify']);
    Route::post('/anchor', [WebhookController::class, 'anchor']);
    Route::post('/vtpass', [WebhookController::class, 'vtpass']);
    // TODO: Add webhooks for other service providers
    // TODO: Add webhook status/health check endpoint
});

// Authenticated API Routes
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/auth/logout', [AuthController::class, 'logout']);
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    
    // KYC Routes (accessible to authenticated users without KYC verification)
    Route::prefix('kyc')->group(function () {
        Route::get('/status', [KycController::class, 'getStatus']);
        Route::post('/bvn', [KycController::class, 'verifyBvn']);
        Route::post('/nin', [KycController::class, 'verifyNin']);
        Route::post('/upload-document', [KycController::class, 'uploadDocument']);
    });
    
    // KYC Verified Routes
    Route::middleware(['kyc.verified'])->group(function () {
        // Wallet Routes
        Route::prefix('wallet')->group(function () {
            Route::get('/', [WalletController::class, 'getBalance']);
            Route::post('/fund', [WalletController::class, 'fund']);
            Route::get('/transactions', [TransactionController::class, 'getUserTransactions']);
        });
        
        // Virtual Account Routes
        Route::prefix('virtual-account')->group(function () {
            Route::get('/', [VirtualAccountController::class, 'getUserAccounts']);
            Route::post('/create', [VirtualAccountController::class, 'create']);
        });
        
        // Transaction Routes
        Route::prefix('transactions')->group(function () {
            Route::get('/', [TransactionController::class, 'getUserTransactions']);
            Route::post('/p2p', [TransactionController::class, 'p2pTransfer']);
            Route::post('/bank-transfer', [TransactionController::class, 'bankTransfer']);
            Route::get('/{transaction}', [TransactionController::class, 'show']);
        });
        
        // Bill Payment Routes
        Route::prefix('bills')->group(function () {
            Route::get('/providers', [BillPaymentController::class, 'getProviders']);
            Route::post('/airtime', [BillPaymentController::class, 'purchaseAirtime']);
            Route::post('/data', [BillPaymentController::class, 'purchaseData']);
            Route::post('/electricity', [BillPaymentController::class, 'payElectricity']);
            Route::post('/cable-tv', [BillPaymentController::class, 'payCableTV']);
        });
        
        // Virtual Card Routes
        Route::prefix('cards')->group(function () {
            Route::get('/', [VirtualCardController::class, 'getUserCards']);
            Route::post('/create', [VirtualCardController::class, 'create']);
            Route::get('/{card}', [VirtualCardController::class, 'show']);
            Route::post('/{card}/freeze', [VirtualCardController::class, 'freeze']);
            Route::post('/{card}/unfreeze', [VirtualCardController::class, 'unfreeze']);
            Route::post('/{card}/terminate', [VirtualCardController::class, 'terminate']);
            Route::get('/{card}/transactions', [VirtualCardController::class, 'getTransactions']);
        });
    });
});