<?php

namespace Database\Seeders;

use App\Models\AirtimeMargin;
use Illuminate\Database\Seeder;

class AirtimeMarginsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $networks = ['mtn', 'glo', 'airtel', '9mobile'];
        $serviceTypes = ['airtime', 'data'];

        foreach ($networks as $network) {
            foreach ($serviceTypes as $serviceType) {
                // Set default margins - airtime typically has lower margins than data
                $marginPercentage = $serviceType === 'airtime' ? 2.5 : 3.5;
                $fixedFee = $serviceType === 'airtime' ? 0.00 : 5.00;
                $minMarginAmount = $serviceType === 'airtime' ? 1.00 : 2.00;

                AirtimeMargin::updateOrCreate(
                    [
                        'network' => $network,
                        'service_type' => $serviceType,
                    ],
                    [
                        'margin_percentage' => $marginPercentage,
                        'fixed_fee' => $fixedFee,
                        'min_margin_amount' => $minMarginAmount,
                        'max_margin_amount' => null, // No maximum limit by default
                        'is_active' => true,
                    ]
                );
            }
        }
    }
}
