<?php

namespace Tests\Unit\Services;

use App\Services\FundingSourceService;
use Tests\TestCase;

class FundingSourceServiceTest extends TestCase
{
    public function test_can_get_available_sources()
    {
        $sources = FundingSourceService::getAvailableSources();
        
        $this->assertIsArray($sources);
        $this->assertArrayHasKey('manual', $sources);
        $this->assertArrayHasKey('monnify', $sources);
        $this->assertArrayHasKey('anchor', $sources);
    }

    public function test_can_validate_source()
    {
        $this->assertTrue(FundingSourceService::isValidSource('manual'));
        $this->assertTrue(FundingSourceService::isValidSource('monnify'));
        $this->assertTrue(FundingSourceService::isValidSource('anchor'));
        $this->assertFalse(FundingSourceService::isValidSource('invalid'));
    }

    public function test_can_get_source_name()
    {
        $this->assertEquals('Manual Adjustment', FundingSourceService::getSourceName('manual'));
        $this->assertEquals('Monnify API', FundingSourceService::getSourceName('monnify'));
        $this->assertEquals('Anchor API', FundingSourceService::getSourceName('anchor'));
        $this->assertEquals('Invalid', FundingSourceService::getSourceName('invalid'));
    }

    public function test_can_get_enabled_sources()
    {
        $sources = FundingSourceService::getEnabledSources();
        
        $this->assertIsArray($sources);
        
        // All sources should be enabled by default in config
        foreach ($sources as $source) {
            $this->assertTrue($source['enabled']);
        }
    }

    public function test_can_get_select_options()
    {
        $options = FundingSourceService::getSelectOptions();
        
        $this->assertIsArray($options);
        $this->assertArrayHasKey('manual', $options);
        $this->assertEquals('Manual Adjustment', $options['manual']);
    }

    public function test_constants_are_defined()
    {
        $this->assertEquals('manual', FundingSourceService::MANUAL);
        $this->assertEquals('monnify', FundingSourceService::MONNIFY);
        $this->assertEquals('anchor', FundingSourceService::ANCHOR);
    }
}