<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kyc_verifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['bvn', 'nin', 'passport', 'drivers_license', 'voters_card']);
            $table->string('verification_id')->nullable(); // BVN, NIN, etc.
            $table->enum('status', ['pending', 'verified', 'failed', 'expired'])->default('pending');
            $table->string('provider')->nullable(); // dojah, verifyme, etc.
            $table->string('provider_reference')->nullable();
            $table->json('verification_data')->nullable(); // Data returned from provider
            $table->string('document_path')->nullable(); // For uploaded documents
            $table->text('failure_reason')->nullable();
            $table->timestamp('verified_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
            
            $table->unique(['user_id', 'type']);
            $table->index(['user_id', 'status']);
            $table->index('provider_reference');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kyc_verifications');
    }
};