@extends('layouts.admin-sidebar')

@section('title', 'Notification Settings')
@section('page-title', 'Notification Management')
@section('page-description', 'Configure notification settings and send broadcast messages')

@section('content')
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Notification Management</h2>
            <p class="text-gray-600 mt-1">Configure notification settings and manage user communications</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="testNotifications()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Test Notifications
            </button>
            <button class="btn-primary" onclick="openBroadcastModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                </svg>
                Send Broadcast
            </button>
        </div>
    </div>

    <!-- Email Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Email Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($settings['email_notifications'] as $notification => $enabled)
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900">{{ ucwords(str_replace('_', ' ', $notification)) }}</h4>
                    <p class="text-xs text-gray-500">
                        @switch($notification)
                            @case('user_registration')
                                Welcome email when users register
                            @break
                            @case('kyc_approval')
                                Email when KYC is approved
                            @break
                            @case('kyc_rejection')
                                Email when KYC is rejected
                            @break
                            @case('transaction_success')
                                Email for successful transactions
                            @break
                            @case('transaction_failure')
                                Email for failed transactions
                            @break
                            @case('card_issuance')
                                Email when virtual card is issued
                            @break
                            @case('suspicious_activity')
                                Email for security alerts
                            @break
                            @case('password_reset')
                                Email for password reset requests
                            @break
                            @case('low_balance_warning')
                                Email when wallet balance is low
                            @break
                            @default
                                Email notification setting
                        @endswitch
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="email_notifications[{{ $notification }}]" 
                           value="1" 
                           {{ $enabled ? 'checked' : '' }}
                           class="sr-only peer"
                           onchange="updateNotificationSetting('email', '{{ $notification }}', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                </label>
            </div>
            @endforeach
        </div>
    </div>

    <!-- SMS Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">SMS Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($settings['sms_notifications'] as $notification => $enabled)
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900">{{ ucwords(str_replace('_', ' ', $notification)) }}</h4>
                    <p class="text-xs text-gray-500">
                        @switch($notification)
                            @case('transaction_alerts')
                                SMS for transaction notifications
                            @break
                            @case('otp_verification')
                                SMS for OTP codes
                            @break
                            @case('security_alerts')
                                SMS for security notifications
                            @break
                            @case('balance_alerts')
                                SMS for balance updates
                            @break
                            @case('promotional_messages')
                                SMS for promotions and offers
                            @break
                            @default
                                SMS notification setting
                        @endswitch
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="sms_notifications[{{ $notification }}]" 
                           value="1" 
                           {{ $enabled ? 'checked' : '' }}
                           class="sr-only peer"
                           onchange="updateNotificationSetting('sms', '{{ $notification }}', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-green-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-600"></div>
                </label>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Push Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Push Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($settings['push_notifications'] as $notification => $enabled)
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900">{{ ucwords(str_replace('_', ' ', $notification)) }}</h4>
                    <p class="text-xs text-gray-500">
                        @switch($notification)
                            @case('transaction_updates')
                                Push notifications for transactions
                            @break
                            @case('system_maintenance')
                                Push notifications for maintenance
                            @break
                            @case('new_features')
                                Push notifications for new features
                            @break
                            @case('promotional_offers')
                                Push notifications for promotions
                            @break
                            @default
                                Push notification setting
                        @endswitch
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="push_notifications[{{ $notification }}]" 
                           value="1" 
                           {{ $enabled ? 'checked' : '' }}
                           class="sr-only peer"
                           onchange="updateNotificationSetting('push', '{{ $notification }}', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                </label>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Admin Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Admin Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($settings['admin_notifications'] as $notification => $enabled)
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900">{{ ucwords(str_replace('_', ' ', $notification)) }}</h4>
                    <p class="text-xs text-gray-500">
                        @switch($notification)
                            @case('new_user_registration')
                                Notify when new users register
                            @break
                            @case('kyc_submissions')
                                Notify when KYC is submitted
                            @break
                            @case('high_value_transactions')
                                Notify for large transactions
                            @break
                            @case('failed_transactions')
                                Notify when transactions fail
                            @break
                            @case('system_errors')
                                Notify for system errors
                            @break
                            @case('security_incidents')
                                Notify for security events
                            @break
                            @default
                                Admin notification setting
                        @endswitch
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="admin_notifications[{{ $notification }}]" 
                           value="1" 
                           {{ $enabled ? 'checked' : '' }}
                           class="sr-only peer"
                           onchange="updateNotificationSetting('admin', '{{ $notification }}', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-red-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-red-600"></div>
                </label>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Broadcast Messages -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-lg font-semibold text-gray-900">Recent Broadcast Messages</h3>
            <button class="btn-primary" onclick="openBroadcastModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                New Broadcast
            </button>
        </div>

        @if(count($broadcasts) > 0)
        <div class="space-y-4">
            @foreach($broadcasts as $broadcast)
            <div class="border border-gray-200 rounded-lg p-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-center space-x-3">
                            <h4 class="text-lg font-medium text-gray-900">{{ $broadcast['title'] }}</h4>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                {{ $broadcast['type'] === 'maintenance' ? 'bg-yellow-100 text-yellow-800' : 
                                   ($broadcast['type'] === 'feature' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                                {{ ucfirst($broadcast['type']) }}
                            </span>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                {{ $broadcast['status'] === 'sent' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                {{ ucfirst($broadcast['status']) }}
                            </span>
                        </div>
                        <p class="text-gray-600 mt-2">{{ $broadcast['message'] }}</p>
                        <div class="flex items-center space-x-4 mt-3 text-sm text-gray-500">
                            <span>Recipients: {{ ucwords(str_replace('_', ' ', $broadcast['recipients'])) }}</span>
                            <span>Sent: {{ $broadcast['sent_at'] }}</span>
                        </div>
                    </div>
                    <div class="flex space-x-2 ml-4">
                        <button class="text-blue-600 hover:text-blue-900" onclick="viewBroadcastDetails({{ $broadcast['id'] }})">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                        </button>
                        <button class="text-green-600 hover:text-green-900" onclick="duplicateBroadcast({{ $broadcast['id'] }})">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @else
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No broadcast messages</h3>
            <p class="mt-1 text-sm text-gray-500">Get started by sending your first broadcast message to users.</p>
        </div>
        @endif
    </div>
</div>

<!-- Broadcast Modal -->
<div id="broadcastModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity" aria-hidden="true">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
            <form id="broadcastForm" method="POST" action="{{ route('admin.settings.notifications.broadcast') }}">
                @csrf
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:mt-0 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Send Broadcast Message</h3>
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                                    <input type="text" name="title" required class="input-primary" placeholder="Broadcast title">
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Message</label>
                                    <textarea name="message" required rows="4" class="input-primary" placeholder="Your broadcast message..."></textarea>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Type</label>
                                    <select name="type" required class="input-primary">
                                        <option value="info">Information</option>
                                        <option value="warning">Warning</option>
                                        <option value="success">Success</option>
                                        <option value="error">Error</option>
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Recipients</label>
                                    <select name="recipients" required class="input-primary">
                                        <option value="all_users">All Users</option>
                                        <option value="verified_users">Verified Users Only</option>
                                        <option value="unverified_users">Unverified Users Only</option>
                                        <option value="active_users">Active Users Only</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="submit" class="btn-primary ml-3">
                        Send Broadcast
                    </button>
                    <button type="button" class="btn-secondary" onclick="closeBroadcastModal()">
                        Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function updateNotificationSetting(type, notification, enabled) {
    // In a real implementation, this would make an AJAX call to update the setting
    console.log(`Updated ${type} notification ${notification}: ${enabled}`);
}

function testNotifications() {
    alert('Testing notification systems...');
}

function openBroadcastModal() {
    document.getElementById('broadcastModal').classList.remove('hidden');
}

function closeBroadcastModal() {
    document.getElementById('broadcastModal').classList.add('hidden');
    document.getElementById('broadcastForm').reset();
}

function viewBroadcastDetails(broadcastId) {
    alert('View broadcast details: ' + broadcastId);
}

function duplicateBroadcast(broadcastId) {
    alert('Duplicate broadcast: ' + broadcastId);
}

// Handle form submission
document.getElementById('broadcastForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    // In a real implementation, this would submit via AJAX
    console.log('Sending broadcast:', Object.fromEntries(formData));
    
    alert('Broadcast message sent successfully!');
    closeBroadcastModal();
});
</script>
@endsection