<?php $__env->startSection('title', 'KYC Verification'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <div class="card">
        <h2 class="text-2xl font-bold text-center mb-6">KYC Verification</h2>
        
        <div class="mb-6">
            <p class="text-gray-600 text-center">
                Complete your KYC verification to access all platform features including transfers, bill payments, and virtual cards.
            </p>
        </div>

        <?php if($kycVerifications->isNotEmpty()): ?>
        <div class="mb-6">
            <h3 class="text-lg font-semibold mb-4">Verification Status</h3>
            <div class="space-y-3">
                <?php $__currentLoopData = $kycVerifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $verification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-3 border rounded-lg">
                    <div>
                        <span class="font-medium"><?php echo e(strtoupper($verification->type)); ?></span>
                        <span class="text-sm text-gray-500 ml-2"><?php echo e($verification->created_at->format('M d, Y')); ?></span>
                    </div>
                    <div>
                        <?php if($verification->status === 'verified'): ?>
                            <span class="bg-green-100 text-green-800 px-2 py-1 rounded-full text-sm">Verified</span>
                        <?php elseif($verification->status === 'pending'): ?>
                            <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded-full text-sm">Pending</span>
                        <?php else: ?>
                            <span class="bg-red-100 text-red-800 px-2 py-1 rounded-full text-sm">Failed</span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="grid md:grid-cols-3 gap-4">
            <!-- BVN Verification -->
            <div class="card border-2 border-gray-200 hover:border-blue-300 transition-colors">
                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">BVN Verification</h3>
                    <p class="text-gray-600 text-sm mb-4">Verify your identity using your Bank Verification Number</p>
                    <a href="<?php echo e(route('kyc.bvn')); ?>" class="btn-primary block text-center">
                        <?php echo e($kycVerifications->where('type', 'bvn')->first()?->isVerified() ? 'Verified' : 'Verify BVN'); ?>

                    </a>
                </div>
            </div>

            <!-- NIN Verification -->
            <div class="card border-2 border-gray-200 hover:border-blue-300 transition-colors">
                <div class="text-center">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-4 0v1m4-1v1"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">NIN Verification</h3>
                    <p class="text-gray-600 text-sm mb-4">Verify using your National Identification Number</p>
                    <a href="<?php echo e(route('kyc.nin')); ?>" class="btn-primary block text-center">
                        <?php echo e($kycVerifications->where('type', 'nin')->first()?->isVerified() ? 'Verified' : 'Verify NIN'); ?>

                    </a>
                </div>
            </div>

            <!-- Document Upload -->
            <div class="card border-2 border-gray-200 hover:border-blue-300 transition-colors">
                <div class="text-center">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Document Upload</h3>
                    <p class="text-gray-600 text-sm mb-4">Upload your government-issued ID document</p>
                    <a href="<?php echo e(route('kyc.document')); ?>" class="btn-primary block text-center">
                        Upload Document
                    </a>
                </div>
            </div>
        </div>

        <?php if(auth()->user()->hasCompletedKyc()): ?>
        <div class="mt-6 text-center">
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                <strong>Congratulations!</strong> Your KYC verification is complete. You can now access all platform features.
            </div>
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-success mt-4 inline-block">Go to Dashboard</a>
        </div>
        <?php else: ?>
        <div class="mt-6 text-center">
            <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded">
                Please complete at least one verification method to access all features.
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/kyc/index.blade.php ENDPATH**/ ?>