<?php $__env->startSection('title', 'Wallet'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">My Wallet</h1>
    <p class="text-gray-600">Manage your wallet balance and transactions</p>
</div>

<!-- Wallet Balance Card -->
<div class="card mb-6">
    <div class="bg-gradient-to-r from-blue-600 to-blue-800 text-white rounded-lg p-6 mb-6">
        <div class="flex justify-between items-start mb-4">
            <div>
                <h2 class="text-lg font-medium opacity-90">Available Balance</h2>
                <p class="text-4xl font-bold">₦<?php echo e(number_format($wallet?->available_balance ?? 0, 2)); ?></p>
            </div>
            <div class="text-right">
                <?php if($wallet && $wallet->is_frozen): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                        🔒 Frozen
                    </span>
                <?php else: ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                        ✅ Active
                    </span>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="grid grid-cols-2 gap-4">
            <div>
                <p class="text-sm opacity-75">Total Balance</p>
                <p class="text-xl font-semibold">₦<?php echo e(number_format($wallet?->balance ?? 0, 2)); ?></p>
            </div>
            <div>
                <p class="text-sm opacity-75">Locked Balance</p>
                <p class="text-xl font-semibold">₦<?php echo e(number_format($wallet?->locked_balance ?? 0, 2)); ?></p>
            </div>
        </div>
    </div>
    
    <!-- Quick Actions -->
    <div class="grid md:grid-cols-4 gap-4">
        <button onclick="openFundModal()" class="flex flex-col items-center p-4 bg-green-50 hover:bg-green-100 rounded-lg transition-colors cursor-pointer">
            <div class="w-12 h-12 bg-green-200 rounded-full flex items-center justify-center mb-2">
                <span class="text-2xl">💰</span>
            </div>
            <span class="text-sm font-medium text-green-800">Fund Wallet</span>
        </button>
        
        <a href="<?php echo e(route('transfer.p2p')); ?>" class="flex flex-col items-center p-4 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
            <div class="w-12 h-12 bg-blue-200 rounded-full flex items-center justify-center mb-2">
                <span class="text-2xl">👥</span>
            </div>
            <span class="text-sm font-medium text-blue-800">Send Money</span>
        </a>
        
        <a href="<?php echo e(route('transfer.bank')); ?>" class="flex flex-col items-center p-4 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors">
            <div class="w-12 h-12 bg-purple-200 rounded-full flex items-center justify-center mb-2">
                <span class="text-2xl">🏦</span>
            </div>
            <span class="text-sm font-medium text-purple-800">Withdraw</span>
        </a>
        
        <a href="<?php echo e(route('transactions.index')); ?>" class="flex flex-col items-center p-4 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
            <div class="w-12 h-12 bg-gray-200 rounded-full flex items-center justify-center mb-2">
                <span class="text-2xl">📊</span>
            </div>
            <span class="text-sm font-medium text-gray-800">View History</span>
        </a>
    </div>
</div>

<!-- Transaction Limits -->
<div class="grid md:grid-cols-2 gap-6 mb-6">
    <div class="card">
        <h3 class="text-lg font-bold mb-4">Daily Limits</h3>
        <div class="space-y-4">
            <div>
                <div class="flex justify-between text-sm mb-1">
                    <span>Daily Transfer Limit</span>
                    <span>₦<?php echo e(number_format($wallet?->daily_limit ?? 100000, 0)); ?></span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div class="bg-blue-600 h-2 rounded-full" style="width: <?php echo e($wallet ? (($wallet->daily_limit - $wallet->remaining_daily_limit) / $wallet->daily_limit) * 100 : 0); ?>%"></div>
                </div>
                <p class="text-xs text-gray-500 mt-1">₦<?php echo e(number_format($wallet?->remaining_daily_limit ?? 0, 0)); ?> remaining</p>
            </div>
            
            <?php if(!auth()->user()->hasCompletedKyc()): ?>
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                <p class="text-sm text-yellow-800">
                    <span class="font-medium">Complete KYC</span> to increase your limits up to ₦5,000,000 daily
                </p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="card">
        <h3 class="text-lg font-bold mb-4">Virtual Account</h3>
        <?php if($virtualAccount): ?>
        <div class="bg-gray-50 rounded-lg p-4">
            <div class="flex justify-between items-center mb-2">
                <span class="text-sm font-medium">Account Number</span>
                <button onclick="copyToClipboard('<?php echo e($virtualAccount->account_number); ?>')" class="text-blue-600 hover:text-blue-800 text-sm">
                    Copy
                </button>
            </div>
            <p class="text-xl font-mono font-bold mb-1"><?php echo e($virtualAccount->account_number); ?></p>
            <p class="text-sm text-gray-600"><?php echo e($virtualAccount->bank_name); ?></p>
            <p class="text-xs text-gray-500 mt-2">Use this account to fund your wallet via bank transfer</p>
        </div>
        <?php else: ?>
        <div class="text-center py-6">
            <p class="text-gray-500 mb-3">No virtual account yet</p>
            <button onclick="createVirtualAccount()" class="btn-primary btn-sm">Create Virtual Account</button>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-bold">Recent Transactions</h3>
        <a href="<?php echo e(route('transactions.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">View All →</a>
    </div>
    
    <?php if($recentTransactions && $recentTransactions->count() > 0): ?>
        <div class="space-y-3">
            <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between items-center p-4 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center mr-3 <?php echo e($transaction->type === 'credit' ? 'bg-green-100' : 'bg-red-100'); ?>">
                        <span class="text-lg">
                            <?php if($transaction->category === 'wallet_funding'): ?> 💰
                            <?php elseif($transaction->category === 'p2p_transfer'): ?> 👥
                            <?php elseif($transaction->category === 'bank_transfer'): ?> 🏦
                            <?php elseif($transaction->category === 'airtime_purchase'): ?> 📱
                            <?php elseif($transaction->category === 'data_purchase'): ?> 📶
                            <?php else: ?> 💳
                            <?php endif; ?>
                        </span>
                    </div>
                    <div>
                        <p class="font-medium"><?php echo e($transaction->description); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-semibold <?php echo e($transaction->type === 'credit' ? 'text-green-600' : 'text-red-600'); ?>">
                        <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 2)); ?>

                    </p>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        <?php if($transaction->status === 'completed'): ?> bg-green-100 text-green-800
                        <?php elseif($transaction->status === 'pending' || $transaction->status === 'processing'): ?> bg-yellow-100 text-yellow-800
                        <?php else: ?> bg-red-100 text-red-800
                        <?php endif; ?>">
                        <?php echo e(ucfirst($transaction->status)); ?>

                    </span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <span class="text-6xl mb-4 block">💳</span>
            <p class="text-lg font-medium mb-2">No transactions yet</p>
            <p class="text-sm">Your transaction history will appear here</p>
        </div>
    <?php endif; ?>
</div>

<!-- Fund Wallet Modal -->
<div id="fundModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3 text-center">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Fund Your Wallet</h3>
            <form id="fundForm" method="POST" action="<?php echo e(route('wallet.fund')); ?>">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Amount (₦)</label>
                    <input type="number" id="amount" name="amount" min="100" max="500000" step="0.01" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                           placeholder="Enter amount" required>
                    <p class="text-xs text-gray-500 mt-1">Minimum: ₦100, Maximum: ₦500,000</p>
                </div>
                <div class="flex justify-center space-x-4">
                    <button type="button" onclick="closeFundModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                        Proceed to Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openFundModal() {
    document.getElementById('fundModal').classList.remove('hidden');
}

function closeFundModal() {
    document.getElementById('fundModal').classList.add('hidden');
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Account number copied to clipboard!');
    });
}

function createVirtualAccount() {
    // Implementation for creating virtual account
    alert('Creating virtual account...');
}

// Close modal when clicking outside
document.getElementById('fundModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeFundModal();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/wallet/index.blade.php ENDPATH**/ ?>