<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CronLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'task_name',
        'status',
        'message',
        'executed_at',
        'execution_time',
        'memory_usage',
        'error_details'
    ];

    protected $casts = [
        'executed_at' => 'datetime',
        'execution_time' => 'float',
        'memory_usage' => 'integer',
        'error_details' => 'array'
    ];

    /**
     * Get recent logs for a specific task
     */
    public static function getRecentLogs($taskName, $limit = 10)
    {
        return static::where('task_name', $taskName)
            ->orderBy('executed_at', 'desc')
            ->limit($limit)
            ->get();
    }

    /**
     * Get failed executions
     */
    public static function getFailedExecutions($hours = 24)
    {
        return static::where('status', 'failed')
            ->where('executed_at', '>=', now()->subHours($hours))
            ->orderBy('executed_at', 'desc')
            ->get();
    }

    /**
     * Clean up old logs (keep last 30 days)
     */
    public static function cleanup()
    {
        return static::where('executed_at', '<', now()->subDays(30))->delete();
    }
}