<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Fintech Business Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration for fintech business logic,
    | including wallet limits, funding sources, margins, and other
    | business-specific settings.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Wallet Configuration
    |--------------------------------------------------------------------------
    */
    'wallet' => [
        // Maximum adjustment amount for admin operations
        'max_adjustment_amount' => env('WALLET_MAX_ADJUSTMENT', 1000000.00),
        
        // Minimum adjustment amount
        'min_adjustment_amount' => env('WALLET_MIN_ADJUSTMENT', 0.01),
        
        // Default wallet balance for new users
        'default_balance' => env('WALLET_DEFAULT_BALANCE', 0.00),
        
        // Wallet freeze settings
        'allow_freeze' => env('WALLET_ALLOW_FREEZE', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Funding Sources Configuration
    |--------------------------------------------------------------------------
    */
    'funding_sources' => [
        'manual' => [
            'name' => 'Manual Adjustment',
            'description' => 'Admin manual wallet adjustment',
            'enabled' => true,
            'requires_approval' => false,
        ],
        'monnify' => [
            'name' => 'Monnify API',
            'description' => 'Monnify payment gateway integration',
            'enabled' => env('MONNIFY_ENABLED', true),
            'requires_approval' => false,
            'api_url' => env('MONNIFY_API_URL', 'https://sandbox.monnify.com/api/v1'),
            'timeout' => env('MONNIFY_TIMEOUT', 30),
        ],
        'anchor' => [
            'name' => 'Anchor API',
            'description' => 'Anchor payment gateway integration',
            'enabled' => env('ANCHOR_ENABLED', true),
            'requires_approval' => false,
            'api_url' => env('ANCHOR_API_URL', 'https://api.anchor.com/v1'),
            'timeout' => env('ANCHOR_TIMEOUT', 30),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Airtime & Data Configuration
    |--------------------------------------------------------------------------
    */
    'airtime' => [
        // Default margins for airtime services
        'default_margins' => [
            'airtime' => env('AIRTIME_DEFAULT_MARGIN', 2.5),
            'data' => env('DATA_DEFAULT_MARGIN', 3.0),
            'minimum' => env('AIRTIME_MIN_MARGIN', 0.5),
            'maximum' => env('AIRTIME_MAX_MARGIN', 10.0),
        ],
        
        // Network configurations
        'networks' => [
            'mtn' => [
                'name' => 'MTN Nigeria',
                'code' => 'mtn',
                'enabled' => env('MTN_ENABLED', true),
                'airtime_margin' => env('MTN_AIRTIME_MARGIN', 2.5),
                'data_margin' => env('MTN_DATA_MARGIN', 3.0),
                'priority' => 1,
            ],
            'glo' => [
                'name' => 'Globacom',
                'code' => 'glo',
                'enabled' => env('GLO_ENABLED', true),
                'airtime_margin' => env('GLO_AIRTIME_MARGIN', 2.5),
                'data_margin' => env('GLO_DATA_MARGIN', 3.0),
                'priority' => 2,
            ],
            'airtel' => [
                'name' => 'Airtel Nigeria',
                'code' => 'airtel',
                'enabled' => env('AIRTEL_ENABLED', true),
                'airtime_margin' => env('AIRTEL_AIRTIME_MARGIN', 2.5),
                'data_margin' => env('AIRTEL_DATA_MARGIN', 3.0),
                'priority' => 3,
            ],
            '9mobile' => [
                'name' => '9mobile',
                'code' => '9mobile',
                'enabled' => env('NINE_MOBILE_ENABLED', true),
                'airtime_margin' => env('NINE_MOBILE_AIRTIME_MARGIN', 2.5),
                'data_margin' => env('NINE_MOBILE_DATA_MARGIN', 3.0),
                'priority' => 4,
            ],
        ],
        
        // Transaction limits
        'limits' => [
            'min_amount' => env('AIRTIME_MIN_AMOUNT', 50.00),
            'max_amount' => env('AIRTIME_MAX_AMOUNT', 50000.00),
            'daily_limit' => env('AIRTIME_DAILY_LIMIT', 200000.00),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Export/Report Configuration
    |--------------------------------------------------------------------------
    */
    'export' => [
        // Allowed export formats
        'formats' => ['csv', 'xlsx', 'pdf'],
        
        // Maximum records per export
        'max_records' => env('EXPORT_MAX_RECORDS', 10000),
        
        // Allowed date range for exports (in days)
        'max_date_range' => env('EXPORT_MAX_DATE_RANGE', 365),
        
        // Rate limiting for exports (per user per hour)
        'rate_limit' => env('EXPORT_RATE_LIMIT', 10),
        
        // Allowed sort fields
        'allowed_sort_fields' => [
            'created_at', 'updated_at', 'amount', 'status', 'type', 'reference'
        ],
        
        // Allowed filter fields
        'allowed_filter_fields' => [
            'status', 'type', 'category', 'network', 'user_id', 'date_from', 'date_to'
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Configuration
    |--------------------------------------------------------------------------
    */
    'security' => [
        // Admin session timeout (in minutes)
        'admin_session_timeout' => env('ADMIN_SESSION_TIMEOUT', 120),
        
        // Maximum failed login attempts before lockout
        'max_login_attempts' => env('MAX_LOGIN_ATTEMPTS', 5),
        
        // Account lockout duration (in minutes)
        'lockout_duration' => env('LOCKOUT_DURATION', 30),
        
        // Enable audit logging
        'audit_logging' => env('AUDIT_LOGGING', true),
        
        // IP whitelist for admin access (comma-separated)
        'admin_ip_whitelist' => env('ADMIN_IP_WHITELIST', ''),
    ],

    /*
    |--------------------------------------------------------------------------
    | UI Configuration
    |--------------------------------------------------------------------------
    */
    'ui' => [
        // Default pagination size
        'pagination_size' => env('UI_PAGINATION_SIZE', 20),
        
        // Enable real-time updates instead of page refresh
        'enable_realtime_updates' => env('UI_REALTIME_UPDATES', true),
        
        // Update intervals (in seconds)
        'update_intervals' => [
            'dashboard' => env('UI_DASHBOARD_UPDATE', 30),
            'transactions' => env('UI_TRANSACTIONS_UPDATE', 15),
            'orders' => env('UI_ORDERS_UPDATE', 10),
        ],
        
        // Alert auto-dismiss timeout (in milliseconds)
        'alert_timeout' => env('UI_ALERT_TIMEOUT', 5000),
    ],

    /*
    |--------------------------------------------------------------------------
    | API Configuration
    |--------------------------------------------------------------------------
    */
    'api' => [
        // Default timeout for external API calls (in seconds)
        'timeout' => env('API_TIMEOUT', 30),
        
        // Maximum retry attempts for failed API calls
        'max_retries' => env('API_MAX_RETRIES', 3),
        
        // Retry delay (in seconds)
        'retry_delay' => env('API_RETRY_DELAY', 2),
        
        // Enable API response caching
        'enable_caching' => env('API_ENABLE_CACHING', true),
        
        // Cache TTL (in seconds)
        'cache_ttl' => env('API_CACHE_TTL', 300),
    ],
];