<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // This migration adds support for simplified airtime/data categories
        // alongside the existing airtime_purchase/data_purchase categories
        // for backward compatibility in admin views
        
        // We'll add this via a manual update since ENUM modifications are complex
        // The controller already handles both naming conventions
        
        // Add indexes for better performance on admin queries
        if (Schema::hasTable('transactions')) {
            Schema::table('transactions', function (Blueprint $table) {
                // Add composite indexes for admin filtering
                $table->index(['category', 'status', 'created_at'], 'idx_transactions_admin_filter');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('transactions')) {
            Schema::table('transactions', function (Blueprint $table) {
                $table->dropIndex('idx_transactions_admin_filter');
            });
        }
    }
};