<?php $__env->startSection('title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Settings</h1>
    <p class="text-gray-600">Manage your account settings and preferences</p>
</div>

<div class="grid lg:grid-cols-4 gap-6">
    <!-- Settings Navigation -->
    <div class="lg:col-span-1">
        <div class="card p-0">
            <nav class="space-y-1">
                <a href="<?php echo e(route('settings.profile')); ?>" class="flex items-center px-4 py-3 text-sm font-medium <?php echo e(request()->routeIs('settings.profile') ? 'bg-blue-50 text-blue-700 border-r-2 border-blue-700' : 'text-gray-600 hover:bg-gray-50'); ?>">
                    <span class="mr-3">👤</span>
                    Profile
                </a>
                <a href="<?php echo e(route('settings.security')); ?>" class="flex items-center px-4 py-3 text-sm font-medium <?php echo e(request()->routeIs('settings.security') ? 'bg-blue-50 text-blue-700 border-r-2 border-blue-700' : 'text-gray-600 hover:bg-gray-50'); ?>">
                    <span class="mr-3">🔒</span>
                    Security
                </a>
                <a href="<?php echo e(route('settings.notifications')); ?>" class="flex items-center px-4 py-3 text-sm font-medium <?php echo e(request()->routeIs('settings.notifications') ? 'bg-blue-50 text-blue-700 border-r-2 border-blue-700' : 'text-gray-600 hover:bg-gray-50'); ?>">
                    <span class="mr-3">🔔</span>
                    Notifications
                </a>
                <a href="<?php echo e(route('settings.api')); ?>" class="flex items-center px-4 py-3 text-sm font-medium <?php echo e(request()->routeIs('settings.api') ? 'bg-blue-50 text-blue-700 border-r-2 border-blue-700' : 'text-gray-600 hover:bg-gray-50'); ?>">
                    <span class="mr-3">🔧</span>
                    API Keys
                </a>
                <a href="<?php echo e(route('kyc.index')); ?>" class="flex items-center px-4 py-3 text-sm font-medium text-gray-600 hover:bg-gray-50">
                    <span class="mr-3">🆔</span>
                    KYC Status
                </a>
            </nav>
        </div>
    </div>

    <!-- Settings Content -->
    <div class="lg:col-span-3">
        <div class="card">
            <h2 class="text-xl font-bold mb-6">Account Overview</h2>
            
            <!-- Account Summary -->
            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg p-4">
                    <h3 class="text-sm font-medium text-blue-600 mb-1">Account Status</h3>
                    <p class="text-lg font-bold text-blue-900">
                        <?php if($user->hasCompletedKyc()): ?>
                            ✅ Verified
                        <?php else: ?>
                            ⚠️ Pending Verification
                        <?php endif; ?>
                    </p>
                    <p class="text-xs text-blue-600">
                        <?php if($user->hasCompletedKyc()): ?>
                            All features unlocked
                        <?php else: ?>
                            Complete KYC to unlock all features
                        <?php endif; ?>
                    </p>
                </div>
                
                <div class="bg-gradient-to-r from-green-50 to-green-100 rounded-lg p-4">
                    <h3 class="text-sm font-medium text-green-600 mb-1">Security Score</h3>
                    <p class="text-lg font-bold text-green-900"><?php echo e($user->getSecurityScore()); ?>/100</p>
                    <p class="text-xs text-green-600">
                        <?php if($user->getSecurityScore() >= 80): ?>
                            Excellent security
                        <?php elseif($user->getSecurityScore() >= 60): ?>
                            Good security
                        <?php else: ?>
                            Consider improving security
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            
            <!-- Account Information -->
            <div class="space-y-4">
                <div class="flex justify-between items-center p-4 bg-gray-50 rounded-lg">
                    <div>
                        <p class="font-medium"><?php echo e($user->full_name); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($user->email); ?></p>
                    </div>
                    <a href="<?php echo e(route('settings.profile')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        Edit Profile →
                    </a>
                </div>
                
                <div class="flex justify-between items-center p-4 bg-gray-50 rounded-lg">
                    <div>
                        <p class="font-medium">Phone Number</p>
                        <p class="text-sm text-gray-600"><?php echo e($user->phone); ?></p>
                    </div>
                    <span class="text-sm <?php echo e($user->phone_verified_at ? 'text-green-600' : 'text-orange-600'); ?>">
                        <?php echo e($user->phone_verified_at ? '✅ Verified' : '⚠️ Unverified'); ?>

                    </span>
                </div>
                
                <div class="flex justify-between items-center p-4 bg-gray-50 rounded-lg">
                    <div>
                        <p class="font-medium">Transaction PIN</p>
                        <p class="text-sm text-gray-600"><?php echo e($user->transaction_pin ? 'Configured' : 'Not set'); ?></p>
                    </div>
                    <a href="<?php echo e(route('settings.security')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        <?php echo e($user->transaction_pin ? 'Change PIN' : 'Set PIN'); ?> →
                    </a>
                </div>
                
                <div class="flex justify-between items-center p-4 bg-gray-50 rounded-lg">
                    <div>
                        <p class="font-medium">Two-Factor Authentication</p>
                        <p class="text-sm text-gray-600"><?php echo e($user->two_factor_secret ? 'Enabled' : 'Disabled'); ?></p>
                    </div>
                    <a href="<?php echo e(route('settings.security')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        <?php echo e($user->two_factor_secret ? 'Manage 2FA' : 'Enable 2FA'); ?> →
                    </a>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="mt-6 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-medium mb-4">Quick Actions</h3>
                <div class="grid md:grid-cols-3 gap-4">
                    <a href="<?php echo e(route('settings.profile')); ?>" class="flex flex-col items-center p-4 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
                        <span class="text-2xl mb-2">👤</span>
                        <span class="text-sm font-medium text-blue-800">Edit Profile</span>
                    </a>
                    
                    <a href="<?php echo e(route('settings.security')); ?>" class="flex flex-col items-center p-4 bg-green-50 hover:bg-green-100 rounded-lg transition-colors">
                        <span class="text-2xl mb-2">🔒</span>
                        <span class="text-sm font-medium text-green-800">Security Settings</span>
                    </a>
                    
                    <a href="<?php echo e(route('settings.notifications')); ?>" class="flex flex-col items-center p-4 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors">
                        <span class="text-2xl mb-2">🔔</span>
                        <span class="text-sm font-medium text-purple-800">Notifications</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/settings/index.blade.php ENDPATH**/ ?>