<?php $__env->startSection('title', 'Buy Data'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="<?php echo e(route('bills.index')); ?>" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Buy Data</h1>
                <p class="text-sm text-gray-400">Purchase data bundles for any network</p>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm">Please fix the following errors:</span>
            </div>
            <ul class="mt-2 text-red-400 text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="ml-4">• <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('bills.data')); ?>" class="space-y-6">
        <?php echo csrf_field(); ?>

        <!-- Network Selection -->
        <div class="space-y-3">
            <label class="text-white font-medium">Select Network</label>
            <div class="grid grid-cols-2 gap-3">
                <?php $__currentLoopData = $networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $network): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="network_<?php echo e($network); ?>" name="network" value="<?php echo e($network); ?>" class="hidden network-radio" 
                           <?php echo e(old('network', request('network')) == $network ? 'checked' : ''); ?>>
                    <label for="network_<?php echo e($network); ?>" class="network-option card-gradient border border-gray-600 rounded-xl p-4 text-center cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <div class="flex flex-col items-center">
                            <?php switch($network):
                                case ('MTN'): ?>
                                    <div class="w-12 h-12 bg-yellow-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-black font-bold text-lg">MTN</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('Glo'): ?>
                                    <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">Glo</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('Airtel'): ?>
                                    <div class="w-12 h-12 bg-red-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">A</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('9mobile'): ?>
                                    <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">9M</span>
                                    </div>
                                    <?php break; ?>
                            <?php endswitch; ?>
                            <span class="text-white font-medium"><?php echo e($network); ?></span>
                        </div>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Phone Number -->
        <div class="space-y-2">
            <label for="phone" class="text-white font-medium">Phone Number</label>
            <input type="tel" 
                   id="phone" 
                   name="phone" 
                   value="<?php echo e(old('phone', request('phone'))); ?>"
                   placeholder="08012345678" 
                   class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                   maxlength="11" 
                   pattern="[0-9]{11}"
                   required>
            <p class="text-xs text-gray-400">Enter 11-digit phone number</p>
        </div>

        <!-- Data Plans -->
        <div class="space-y-3" id="data-plans-container" style="display: none;">
            <label class="text-white font-medium">Select Data Plan</label>
            <div class="space-y-3" id="data-plans">
                <!-- Plans will be loaded via JavaScript -->
            </div>
            <div id="loading-plans" class="text-center py-4">
                <i class="fas fa-spinner fa-spin text-primary-500"></i>
                <p class="text-gray-400 text-sm mt-2">Loading data plans...</p>
            </div>
        </div>

        <!-- Transaction PIN -->
        <div class="space-y-2">
            <label for="transaction_pin" class="text-white font-medium">Transaction PIN</label>
            <input type="password" 
                   id="transaction_pin" 
                   name="transaction_pin" 
                   placeholder="Enter 4-digit PIN" 
                   maxlength="4"
                   pattern="[0-9]{4}"
                   class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                   required>
        </div>

        <!-- Hidden inputs for selected plan -->
        <input type="hidden" name="plan_code" id="plan_code">
        <input type="hidden" name="amount" id="amount">

        <!-- Summary -->
        <div class="card-gradient rounded-xl p-4 space-y-2" id="transaction-summary" style="display: none;">
            <h3 class="text-white font-medium mb-3">Transaction Summary</h3>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Network:</span>
                <span class="text-white" id="summary-network">-</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Phone:</span>
                <span class="text-white" id="summary-phone">-</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Data Plan:</span>
                <span class="text-white" id="summary-plan">-</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Amount:</span>
                <span class="text-white" id="summary-amount">₦0</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Fee:</span>
                <span class="text-white">₦0</span>
            </div>
            <hr class="border-gray-600 my-2">
            <div class="flex justify-between font-medium">
                <span class="text-white">Total:</span>
                <span class="text-primary-400" id="summary-total">₦0</span>
            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" 
                class="w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-semibold py-4 rounded-xl transition-all duration-200 disabled:opacity-50"
                id="submit-btn" 
                disabled>
            <i class="fas fa-wifi mr-2"></i>
            Buy Data
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const networkRadios = document.querySelectorAll('.network-radio');
    const phoneInput = document.getElementById('phone');
    const submitBtn = document.getElementById('submit-btn');
    const summary = document.getElementById('transaction-summary');
    const plansContainer = document.getElementById('data-plans-container');
    const plansDiv = document.getElementById('data-plans');
    const loadingPlans = document.getElementById('loading-plans');
    
    // Sample data plans - in real implementation, fetch from API
    const dataPlans = {
        'MTN': [
            { code: 'mtn_500mb_7days', name: '500MB - 7 Days', amount: 200 },
            { code: 'mtn_1gb_30days', name: '1GB - 30 Days', amount: 350 },
            { code: 'mtn_2gb_30days', name: '2GB - 30 Days', amount: 700 },
            { code: 'mtn_3gb_30days', name: '3GB - 30 Days', amount: 1000 },
            { code: 'mtn_5gb_30days', name: '5GB - 30 Days', amount: 1500 },
            { code: 'mtn_10gb_30days', name: '10GB - 30 Days', amount: 2500 }
        ],
        'Glo': [
            { code: 'glo_500mb_14days', name: '500MB - 14 Days', amount: 200 },
            { code: 'glo_1gb_30days', name: '1GB - 30 Days', amount: 350 },
            { code: 'glo_2gb_30days', name: '2GB - 30 Days', amount: 700 },
            { code: 'glo_3gb_30days', name: '3GB - 30 Days', amount: 1000 },
            { code: 'glo_5gb_30days', name: '5GB - 30 Days', amount: 1500 }
        ],
        'Airtel': [
            { code: 'airtel_500mb_30days', name: '500MB - 30 Days', amount: 200 },
            { code: 'airtel_1gb_30days', name: '1GB - 30 Days', amount: 350 },
            { code: 'airtel_2gb_30days', name: '2GB - 30 Days', amount: 700 },
            { code: 'airtel_5gb_30days', name: '5GB - 30 Days', amount: 1500 },
            { code: 'airtel_10gb_30days', name: '10GB - 30 Days', amount: 2500 }
        ],
        '9mobile': [
            { code: '9mobile_500mb_30days', name: '500MB - 30 Days', amount: 200 },
            { code: '9mobile_1gb_30days', name: '1GB - 30 Days', amount: 300 },
            { code: '9mobile_2gb_30days', name: '2GB - 30 Days', amount: 600 },
            { code: '9mobile_3gb_30days', name: '3GB - 30 Days', amount: 900 },
            { code: '9mobile_5gb_30days', name: '5GB - 30 Days', amount: 1400 }
        ]
    };
    
    function loadDataPlans(network) {
        loadingPlans.style.display = 'block';
        plansDiv.innerHTML = '';
        
        setTimeout(() => {
            const plans = dataPlans[network] || [];
            plansDiv.innerHTML = '';
            
            plans.forEach(plan => {
                const planDiv = document.createElement('div');
                planDiv.innerHTML = `
                    <input type="radio" id="plan_${plan.code}" name="data_plan" value="${plan.code}" class="hidden plan-radio" data-amount="${plan.amount}" data-name="${plan.name}">
                    <label for="plan_${plan.code}" class="plan-option card-gradient border border-gray-600 rounded-xl p-4 cursor-pointer transition-all duration-200 hover:border-primary-500 block">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-white font-medium">${plan.name}</p>
                                <p class="text-gray-400 text-sm">Valid for specified period</p>
                            </div>
                            <div class="text-right">
                                <p class="text-primary-400 font-bold">₦${plan.amount.toLocaleString()}</p>
                            </div>
                        </div>
                    </label>
                `;
                plansDiv.appendChild(planDiv);
            });
            
            // Add event listeners to new plan options
            document.querySelectorAll('.plan-radio').forEach(radio => {
                radio.addEventListener('change', function() {
                    document.querySelectorAll('.plan-option').forEach(option => {
                        option.classList.remove('border-primary-500', 'bg-primary-500/20');
                    });
                    if (this.checked) {
                        this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
                        document.getElementById('plan_code').value = this.value;
                        document.getElementById('amount').value = this.dataset.amount;
                    }
                    updateSummary();
                });
            });
            
            loadingPlans.style.display = 'none';
            plansContainer.style.display = 'block';
        }, 1000);
    }
    
    function updateSummary() {
        const selectedNetwork = document.querySelector('.network-radio:checked')?.value;
        const selectedPlan = document.querySelector('.plan-radio:checked');
        const phone = phoneInput.value;
        
        if (selectedNetwork && selectedPlan && phone) {
            const amount = parseFloat(selectedPlan.dataset.amount);
            const planName = selectedPlan.dataset.name;
            
            document.getElementById('summary-network').textContent = selectedNetwork;
            document.getElementById('summary-phone').textContent = phone;
            document.getElementById('summary-plan').textContent = planName;
            document.getElementById('summary-amount').textContent = '₦' + amount.toLocaleString();
            document.getElementById('summary-total').textContent = '₦' + amount.toLocaleString();
            
            summary.style.display = 'block';
            submitBtn.disabled = false;
        } else {
            summary.style.display = 'none';
            submitBtn.disabled = true;
        }
    }
    
    // Style selection handlers
    networkRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.network-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
                loadDataPlans(this.value);
            }
            updateSummary();
        });
    });
    
    phoneInput.addEventListener('input', updateSummary);
    
    // Initialize selected styles
    const selectedNetwork = document.querySelector('.network-radio:checked');
    if (selectedNetwork) {
        selectedNetwork.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
        loadDataPlans(selectedNetwork.value);
    }
    
    updateSummary();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/bills/data.blade.php ENDPATH**/ ?>