<?php $__env->startSection('title', $page->title); ?>
<?php $__env->startSection('page-title', 'View Page'); ?>
<?php $__env->startSection('page-description', 'Viewing: ' . $page->title); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900"><?php echo e($page->title); ?></h2>
            <p class="text-gray-600 mt-1">
                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                    <?php echo e($page->status === 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                    <?php echo e(ucfirst($page->status)); ?>

                </span>
                • Created <?php echo e($page->created_at->format('M j, Y')); ?>

                • Last updated <?php echo e($page->updated_at->format('M j, Y g:i A')); ?>

            </p>
        </div>
        <div class="flex space-x-3">
            <a href="<?php echo e(url($page->slug)); ?>" target="_blank" class="btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2M9 5h6m0 0v6m0-6L9 11"></path>
                </svg>
                View Live
            </a>
            <button onclick="editPage(<?php echo e($page->id); ?>)" class="btn-primary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                </svg>
                Edit Page
            </button>
            <a href="<?php echo e(route('admin.settings.pages')); ?>" class="btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Pages
            </a>
        </div>
    </div>

    <!-- Page Details -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Page Content</h3>
                </div>
                <div class="px-6 py-6">
                    <div class="prose max-w-none">
                        <?php echo $page->content; ?>

                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Page Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">Page Information</h4>
                
                <div class="space-y-3">
                    <div>
                        <span class="text-sm font-medium text-gray-500">Slug:</span>
                        <p class="text-sm text-gray-900 font-mono bg-gray-50 px-2 py-1 rounded"><?php echo e($page->slug); ?></p>
                    </div>
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Status:</span>
                        <p class="text-sm text-gray-900"><?php echo e(ucfirst($page->status)); ?></p>
                    </div>
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Published:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->published ? 'Yes' : 'No'); ?></p>
                    </div>
                    
                    <?php if($page->published_at): ?>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Published Date:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->published_at->format('M j, Y g:i A')); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Featured:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->is_featured ? 'Yes' : 'No'); ?></p>
                    </div>
                </div>
            </div>

            <!-- SEO Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">SEO Information</h4>
                
                <div class="space-y-3">
                    <div>
                        <span class="text-sm font-medium text-gray-500">Meta Title:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->meta_title ?: $page->title); ?></p>
                    </div>
                    
                    <?php if($page->meta_description): ?>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Meta Description:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->meta_description); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($page->excerpt): ?>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Excerpt:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->excerpt); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Author Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">Author Information</h4>
                
                <div class="space-y-3">
                    <?php if($page->creator): ?>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Created by:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->creator->name); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($page->updater): ?>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Last updated by:</span>
                        <p class="text-sm text-gray-900"><?php echo e($page->updater->name); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function editPage(pageId) {
    // Redirect to pages list with edit modal
    window.location.href = '<?php echo e(route("admin.settings.pages")); ?>?edit=' + pageId;
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/pages-view.blade.php ENDPATH**/ ?>