<?php $__env->startSection('title', 'Create Virtual Card'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="<?php echo e(route('cards.index')); ?>" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Create Virtual Card</h1>
                <p class="text-sm text-gray-400">Create a new virtual card for online payments</p>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm">Please fix the following errors:</span>
            </div>
            <ul class="mt-2 text-red-400 text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="ml-4">• <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('cards.store')); ?>" class="space-y-6">
        <?php echo csrf_field(); ?>

        <!-- Card Preview -->
        <div class="relative">
            <div class="card-preview bg-gradient-to-br from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-6 text-white shadow-2xl relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent"></div>
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-8">
                        <div>
                            <h3 class="text-lg font-semibold" id="preview-name"><?php echo e(auth()->user()->first_name); ?> <?php echo e(auth()->user()->last_name); ?></h3>
                            <p class="text-sm opacity-80" id="preview-type">Virtual Debit Card</p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs opacity-80">Currency</p>
                            <p class="font-semibold" id="preview-currency">NGN</p>
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <p class="text-2xl font-mono tracking-wider">•••• •••• •••• ••••</p>
                    </div>
                    
                    <div class="flex justify-between items-end">
                        <div>
                            <p class="text-xs opacity-80">Spending Limit</p>
                            <p class="font-semibold" id="preview-limit">₦100,000</p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs opacity-80">Expires</p>
                            <p class="font-semibold"><?php echo e(date('m/y', strtotime('+2 years'))); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card Type -->
        <div class="space-y-3">
            <label class="text-white font-medium">Card Type</label>
            <div class="grid grid-cols-2 gap-4">
                <?php $__currentLoopData = $cardTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="card_type_<?php echo e($key); ?>" name="card_type" value="<?php echo e($key); ?>" class="hidden card-type-radio" 
                           <?php echo e(old('card_type', 'debit') == $key ? 'checked' : ''); ?>>
                    <label for="card_type_<?php echo e($key); ?>" class="card-type-option card-gradient border border-gray-600 rounded-xl p-4 cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <div class="text-center">
                            <div class="w-12 h-12 mx-auto mb-3 <?php echo e($key == 'debit' ? 'bg-blue-500' : 'bg-purple-500'); ?> rounded-full flex items-center justify-center">
                                <i class="fas <?php echo e($key == 'debit' ? 'fa-credit-card' : 'fa-gift-card'); ?> text-white"></i>
                            </div>
                            <p class="text-white font-medium"><?php echo e($type); ?></p>
                            <p class="text-gray-400 text-xs mt-1">
                                <?php echo e($key == 'debit' ? 'Linked to your wallet' : 'Prepaid with fixed amount'); ?>

                            </p>
                        </div>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Currency -->
        <div class="space-y-3">
            <label class="text-white font-medium">Currency</label>
            <div class="grid grid-cols-2 gap-4">
                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="currency_<?php echo e($key); ?>" name="currency" value="<?php echo e($key); ?>" class="hidden currency-radio" 
                           <?php echo e(old('currency', 'NGN') == $key ? 'checked' : ''); ?>>
                    <label for="currency_<?php echo e($key); ?>" class="currency-option card-gradient border border-gray-600 rounded-xl p-4 cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <div class="text-center">
                            <div class="w-12 h-12 mx-auto mb-3 <?php echo e($key == 'NGN' ? 'bg-green-600' : 'bg-blue-600'); ?> rounded-full flex items-center justify-center">
                                <span class="text-white font-bold text-sm"><?php echo e($key); ?></span>
                            </div>
                            <p class="text-white font-medium"><?php echo e($currency); ?></p>
                            <p class="text-gray-400 text-xs"><?php echo e($key == 'NGN' ? '₦' : '$'); ?></p>
                        </div>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Spending Limit -->
        <div class="space-y-3">
            <label for="spending_limit" class="text-white font-medium">Spending Limit</label>
            <div class="grid grid-cols-3 gap-3 mb-4">
                <?php $__currentLoopData = [50000, 100000, 500000]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $limit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="limit_<?php echo e($limit); ?>" name="spending_limit_preset" value="<?php echo e($limit); ?>" class="hidden limit-radio"
                           <?php echo e(old('spending_limit') == $limit ? 'checked' : ''); ?>>
                    <label for="limit_<?php echo e($limit); ?>" class="limit-option card-gradient border border-gray-600 rounded-xl p-3 text-center cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <span class="text-white font-medium">₦<?php echo e(number_format($limit)); ?></span>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="relative">
                <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400">₦</span>
                <input type="number" 
                       id="spending_limit" 
                       name="spending_limit" 
                       value="<?php echo e(old('spending_limit', 100000)); ?>"
                       placeholder="100000" 
                       min="1000" 
                       max="1000000"
                       class="w-full pl-8 pr-4 py-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none">
            </div>
            <p class="text-xs text-gray-400">Set a spending limit for your card (₦1,000 - ₦1,000,000)</p>
        </div>

        <!-- Card PIN -->
        <div class="space-y-3">
            <label for="pin" class="text-white font-medium">Set Card PIN</label>
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <input type="password" 
                           id="pin" 
                           name="pin" 
                           placeholder="Enter 4-digit PIN" 
                           maxlength="4"
                           pattern="[0-9]{4}"
                           class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                           required>
                    <p class="text-xs text-gray-400 mt-1">Card PIN</p>
                </div>
                <div>
                    <input type="password" 
                           id="confirm_pin" 
                           name="confirm_pin" 
                           placeholder="Confirm PIN" 
                           maxlength="4"
                           pattern="[0-9]{4}"
                           class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                           required>
                    <p class="text-xs text-gray-400 mt-1">Confirm PIN</p>
                </div>
            </div>
        </div>

        <!-- Terms and Conditions -->
        <div class="space-y-3">
            <label class="flex items-start space-x-3">
                <input type="checkbox" name="terms" value="1" class="mt-1 w-4 h-4 text-primary-600 bg-dark-800 border-gray-600 rounded focus:ring-primary-500" required>
                <span class="text-sm text-gray-300">
                    I agree to the <a href="#" class="text-primary-400 hover:text-primary-300">terms and conditions</a> for virtual card usage and understand the fees associated with card transactions.
                </span>
            </label>
        </div>

        <!-- Creation Fee Info -->
        <div class="bg-blue-500/20 border border-blue-500 rounded-lg p-4">
            <div class="flex items-center">
                <i class="fas fa-info-circle text-blue-400 mr-2"></i>
                <span class="text-blue-400 text-sm font-medium">Card Creation Fee</span>
            </div>
            <p class="text-blue-400 text-sm mt-1">A one-time fee of ₦500 will be deducted from your wallet for card creation.</p>
        </div>

        <!-- Submit Button -->
        <button type="submit" 
                class="w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-semibold py-4 rounded-xl transition-all duration-200">
            <i class="fas fa-credit-card mr-2"></i>
            Create Virtual Card
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const cardTypeRadios = document.querySelectorAll('.card-type-radio');
    const currencyRadios = document.querySelectorAll('.currency-radio');
    const limitRadios = document.querySelectorAll('.limit-radio');
    const spendingLimitInput = document.getElementById('spending_limit');
    
    function updatePreview() {
        const selectedType = document.querySelector('.card-type-radio:checked')?.value;
        const selectedCurrency = document.querySelector('.currency-radio:checked')?.value;
        const spendingLimit = spendingLimitInput.value;
        
        if (selectedType) {
            const typeText = selectedType === 'debit' ? 'Virtual Debit Card' : 'Virtual Prepaid Card';
            document.getElementById('preview-type').textContent = typeText;
        }
        
        if (selectedCurrency) {
            document.getElementById('preview-currency').textContent = selectedCurrency;
        }
        
        if (spendingLimit) {
            const symbol = selectedCurrency === 'USD' ? '$' : '₦';
            document.getElementById('preview-limit').textContent = symbol + parseInt(spendingLimit).toLocaleString();
        }
    }
    
    // Style selection handlers
    cardTypeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.card-type-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
            }
            updatePreview();
        });
    });
    
    currencyRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.currency-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
            }
            updatePreview();
        });
    });
    
    limitRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.limit-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
                spendingLimitInput.value = this.value;
            }
            updatePreview();
        });
    });
    
    spendingLimitInput.addEventListener('input', function() {
        if (this.value) {
            limitRadios.forEach(radio => {
                radio.checked = false;
                radio.nextElementSibling.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
        }
        updatePreview();
    });
    
    // Initialize selected styles
    document.querySelectorAll('.card-type-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
    
    document.querySelectorAll('.currency-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
    
    updatePreview();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/virtual-cards/create.blade.php ENDPATH**/ ?>