<?php $__env->startSection('title', 'User Wallet - ' . $user->full_name); ?>
<?php $__env->startSection('page-title', 'User Wallet Management'); ?>
<?php $__env->startSection('page-description', 'Manage user wallet balance, transactions, and settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Breadcrumb -->
    <nav class="flex mb-6" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="text-blue-600 hover:text-blue-800">Users</a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="text-blue-600 hover:text-blue-800"><?php echo e($user->full_name); ?></a>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-1 text-gray-500 md:ml-2">Wallet</span>
                </div>
            </li>
        </ol>
    </nav>

    <!-- User Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="h-12 w-12 rounded-full bg-gray-300 flex items-center justify-center">
                    <span class="text-lg font-medium text-gray-700">
                        <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

                    </span>
                </div>
                <div class="ml-4">
                    <h1 class="text-xl font-bold text-gray-900"><?php echo e($user->full_name); ?></h1>
                    <p class="text-gray-600">Wallet Management</p>
                </div>
            </div>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="btn-secondary">
                    Back to User
                </a>
            </div>
        </div>
    </div>

    <!-- Wallet Overview -->
    <?php if($wallet): ?>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Current Balance</p>
                    <p class="text-2xl font-bold text-gray-900">₦<?php echo e(number_format($wallet->balance, 2)); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Status</p>
                    <p class="text-lg font-bold">
                        <?php if($wallet->is_frozen): ?>
                            <span class="text-red-600">Frozen</span>
                        <?php else: ?>
                            <span class="text-green-600">Active</span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Created</p>
                    <p class="text-lg font-semibold text-gray-900"><?php echo e($wallet->created_at->format('M d, Y')); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Last Updated</p>
                    <p class="text-lg font-semibold text-gray-900"><?php echo e($wallet->updated_at->format('M d, Y')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Wallet Actions -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Wallet Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Add Balance -->
            <button onclick="openBalanceModal('credit')" class="p-4 border-2 border-dashed border-green-300 rounded-lg hover:border-green-400 hover:bg-green-50 transition-colors">
                <div class="text-center">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm font-medium text-gray-900">Add Balance</h3>
                    <p class="text-xs text-gray-500">Credit user wallet</p>
                </div>
            </button>

            <!-- Remove Balance -->
            <button onclick="openBalanceModal('debit')" class="p-4 border-2 border-dashed border-red-300 rounded-lg hover:border-red-400 hover:bg-red-50 transition-colors">
                <div class="text-center">
                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <svg class="w-4 h-4 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm font-medium text-gray-900">Remove Balance</h3>
                    <p class="text-xs text-gray-500">Debit user wallet</p>
                </div>
            </button>

            <!-- Freeze/Unfreeze -->
            <form action="<?php echo e(route('admin.users.toggle-wallet-freeze', $user)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full p-4 border-2 border-dashed border-blue-300 rounded-lg hover:border-blue-400 hover:bg-blue-50 transition-colors" 
                        onclick="return confirm('Are you sure you want to <?php echo e($wallet->is_frozen ? 'unfreeze' : 'freeze'); ?> this wallet?')">
                    <div class="text-center">
                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <?php if($wallet->is_frozen): ?>
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 11V7a4 4 0 118 0m-4 8v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2z"></path>
                                </svg>
                            <?php else: ?>
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                </svg>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-sm font-medium text-gray-900"><?php echo e($wallet->is_frozen ? 'Unfreeze' : 'Freeze'); ?> Wallet</h3>
                        <p class="text-xs text-gray-500"><?php echo e($wallet->is_frozen ? 'Activate' : 'Suspend'); ?> transactions</p>
                    </div>
                </button>
            </form>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="px-6 py-4 bg-gray-50 border-b">
            <h2 class="text-lg font-semibold text-gray-900">Transaction History</h2>
        </div>

        <?php if($transactions->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                            <?php echo e($transaction->reference); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full 
                                <?php echo e($transaction->type === 'credit' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                <?php echo e(ucfirst($transaction->type)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            ₦<?php echo e(number_format($transaction->amount, 2)); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($transaction->status === 'completed'): ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Completed</span>
                            <?php elseif($transaction->status === 'pending'): ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending</span>
                            <?php else: ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Failed</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-900">
                            <?php echo e($transaction->description ?? $transaction->narration); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?php echo e($transaction->created_at->format('M d, Y H:i')); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 bg-gray-50 border-t">
            <?php echo e($transactions->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No transactions found</h3>
            <p class="mt-1 text-sm text-gray-500">This wallet has no transaction history yet.</p>
        </div>
        <?php endif; ?>
    </div>
    <?php else: ?>
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No wallet found</h3>
            <p class="mt-1 text-sm text-gray-500">This user does not have a wallet yet.</p>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Balance Adjustment Modal -->
<div id="balanceModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 id="modalTitle" class="text-lg font-medium text-gray-900 mb-4">Adjust Wallet Balance</h3>
            <form action="<?php echo e(route('admin.users.adjust-balance', $user)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" id="balanceType">
                
                <div class="mb-4">
                    <label for="amount" class="block text-sm font-medium text-gray-700 mb-1">Amount (₦)</label>
                    <input type="number" name="amount" id="amount" step="0.01" 
                           min="<?php echo e(config('fintech.wallet.min_adjustment_amount', 0.01)); ?>" 
                           max="<?php echo e(config('fintech.wallet.max_adjustment_amount', 1000000)); ?>" 
                           required 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <p class="text-xs text-gray-500 mt-1">
                        Min: ₦<?php echo e(number_format(config('fintech.wallet.min_adjustment_amount', 0.01), 2)); ?>, 
                        Max: ₦<?php echo e(number_format(config('fintech.wallet.max_adjustment_amount', 1000000), 0)); ?>

                    </p>
                </div>
                
                <div class="mb-4">
                    <label for="funding_source" class="block text-sm font-medium text-gray-700 mb-1">Funding Source</label>
                    <select name="funding_source" id="funding_source" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        <?php
                            $fundingSources = \App\Services\FundingSourceService::getEnabledSources();
                        ?>
                        <?php $__currentLoopData = $fundingSources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($source['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Choose how this transaction should be processed</p>
                </div>
                
                <div class="mb-4">
                    <label for="narration" class="block text-sm font-medium text-gray-700 mb-1">Reason/Narration</label>
                    <textarea name="narration" id="narration" rows="3" required maxlength="255"
                              placeholder="Enter reason for this adjustment..."
                              class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                </div>
                
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="closeBalanceModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" id="submitBtn" class="btn-primary">Adjust Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openBalanceModal(type) {
    const modal = document.getElementById('balanceModal');
    const title = document.getElementById('modalTitle');
    const balanceType = document.getElementById('balanceType');
    const submitBtn = document.getElementById('submitBtn');
    
    balanceType.value = type;
    
    if (type === 'credit') {
        title.textContent = 'Add Balance to Wallet';
        submitBtn.textContent = 'Add Balance';
        submitBtn.className = 'btn-primary bg-green-600 hover:bg-green-700';
    } else {
        title.textContent = 'Remove Balance from Wallet';
        submitBtn.textContent = 'Remove Balance';
        submitBtn.className = 'btn-primary bg-red-600 hover:bg-red-700';
    }
    
    modal.classList.remove('hidden');
}

function closeBalanceModal() {
    const modal = document.getElementById('balanceModal');
    modal.classList.add('hidden');
    
    // Reset form
    document.getElementById('amount').value = '';
    document.getElementById('narration').value = '';
    document.getElementById('funding_source').value = 'manual';
}

// Close modal when clicking outside
document.getElementById('balanceModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeBalanceModal();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/users/wallet.blade.php ENDPATH**/ ?>