<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="theme-color" content="#0f172a">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(config('app.name', 'SwiftPay')); ?></title>

    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Custom Mobile Styles -->
    <style>
        /* PWA Styles */
        @media (display-mode: standalone) {
            body {
                -webkit-user-select: none;
                -webkit-touch-callout: none;
            }
        }
        
        /* Disable zoom on inputs */
        input[type="text"], input[type="email"], input[type="password"], input[type="tel"], select, textarea {
            font-size: 16px;
        }
        
        /* Hide scrollbar but allow scrolling */
        .hide-scrollbar {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .hide-scrollbar::-webkit-scrollbar {
            display: none;
        }
        
        /* Custom animations */
        .slide-up {
            animation: slideUp 0.3s ease-out;
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>
</head>
<body class="bg-slate-950 text-white font-sans antialiased">
    <div id="app" class="min-h-screen">
        <!-- Mobile Layout (default) -->
        <div class="lg:hidden">
            <!-- Mobile Container -->
            <div class="mobile-container">
                <?php if(auth()->guard()->check()): ?>
                <!-- Mobile Header -->
                <header class="mobile-header">
                    <div class="flex justify-between items-center">
                        <!-- Greeting & User Info -->
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-full flex items-center justify-center mr-3">
                                <span class="text-white font-semibold text-sm"><?php echo e(strtoupper(substr(auth()->user()->first_name, 0, 1))); ?></span>
                            </div>
                            <div>
                                <p class="text-sm text-gray-400">Good <?php echo e(date('H') < 12 ? 'morning' : (date('H') < 17 ? 'afternoon' : 'evening')); ?></p>
                                <p class="text-white font-medium"><?php echo e(auth()->user()->first_name); ?></p>
                            </div>
                        </div>

                        <!-- Notification & Settings -->
                        <div class="flex items-center space-x-3">
                            <!-- Notification Bell -->
                            <button class="relative p-2 text-gray-400 hover:text-white transition-colors">
                                <i class="fas fa-bell text-lg"></i>
                                <span class="absolute -top-1 -right-1 w-4 h-4 bg-red-500 text-white text-xs rounded-full flex items-center justify-center">3</span>
                            </button>
                            
                            <!-- Settings -->
                            <button onclick="toggleMobileMenu()" class="p-2 text-gray-400 hover:text-white transition-colors">
                                <i class="fas fa-ellipsis-vertical text-lg"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Mobile Menu Dropdown -->
                    <div id="mobile-menu" class="hidden absolute top-full left-0 right-0 bg-dark-900/95 backdrop-blur-lg border-t border-dark-700 p-4 z-50">
                        <div class="space-y-3">
                            <a href="<?php echo e(route('settings.profile')); ?>" class="flex items-center p-3 bg-dark-800/50 rounded-lg hover:bg-dark-700/50 transition-colors">
                                <i class="fas fa-user text-primary-400 w-5 mr-3"></i>
                                <span class="text-white">Profile Settings</span>
                            </a>
                            <a href="<?php echo e(route('settings.security')); ?>" class="flex items-center p-3 bg-dark-800/50 rounded-lg hover:bg-dark-700/50 transition-colors">
                                <i class="fas fa-shield-alt text-primary-400 w-5 mr-3"></i>
                                <span class="text-white">Security</span>
                            </a>
                            <hr class="border-dark-700">
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="flex items-center w-full p-3 bg-dark-800/50 rounded-lg hover:bg-red-600/20 transition-colors">
                                    <i class="fas fa-sign-out-alt text-red-400 w-5 mr-3"></i>
                                    <span class="text-white">Sign Out</span>
                                </button>
                            </form>
                        </div>
                    </div>
                </header>
                <?php endif; ?>

                <!-- Main Content -->
                <main class="mobile-content">
                    <?php if(auth()->guard()->check()): ?>
                    <!-- Flash Messages -->
                    <?php if(session('success')): ?>
                        <div class="bg-success-600/20 border border-success-600/30 text-success-400 px-4 py-3 rounded-lg mb-4 flex items-center">
                            <i class="fas fa-check-circle mr-3"></i>
                            <span><?php echo e(session('success')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="bg-red-600/20 border border-red-600/30 text-red-400 px-4 py-3 rounded-lg mb-4 flex items-center">
                            <i class="fas fa-exclamation-circle mr-3"></i>
                            <span><?php echo e(session('error')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="bg-red-600/20 border border-red-600/30 text-red-400 px-4 py-3 rounded-lg mb-4">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                <span class="font-medium">Please fix the following errors:</span>
                            </div>
                            <ul class="list-disc list-inside text-sm space-y-1">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>
                    <?php echo $__env->yieldContent('content'); ?>
                    <?php endif; ?>
                </main>

                <?php if(auth()->guard()->check()): ?>
                <!-- Bottom Navigation -->
                <nav class="bottom-nav">
                    <div class="flex justify-around items-center max-w-sm mx-auto">
                        <a href="<?php echo e(route('dashboard')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                            <i class="fas fa-home text-xl mb-1"></i>
                            <span>Home</span>
                        </a>
                        
                        <a href="<?php echo e(route('transactions.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('transactions.*') ? 'active' : ''); ?>">
                            <i class="fas fa-exchange-alt text-xl mb-1"></i>
                            <span>History</span>
                        </a>
                        
                        <a href="<?php echo e(route('wallet.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('wallet.*') ? 'active' : ''); ?>">
                            <div class="relative">
                                <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center -mt-2 shadow-lg">
                                    <i class="fas fa-plus text-white text-xl"></i>
                                </div>
                            </div>
                            <span class="mt-1">Pay</span>
                        </a>
                        
                        <a href="<?php echo e(route('bills.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('bills.*') ? 'active' : ''); ?>">
                            <i class="fas fa-mobile-alt text-xl mb-1"></i>
                            <span>Bills</span>
                        </a>
                        
                        <a href="<?php echo e(route('cards.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('cards.*') ? 'active' : ''); ?>">
                            <i class="fas fa-credit-card text-xl mb-1"></i>
                            <span>Cards</span>
                        <?php if(Route::has('bills.index')): ?>
                            <a href="<?php echo e(route('bills.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('bills.*') ? 'active' : ''); ?>">
                                <i class="fas fa-mobile-alt text-xl mb-1"></i>
                                <span>Bills</span>
                            </a>
                        <?php else: ?>
                            <span class="bottom-nav-item text-gray-500 cursor-not-allowed">
                                <i class="fas fa-mobile-alt text-xl mb-1"></i>
                                <span>Bills</span>
                            </span>
                        <?php endif; ?>
                        
                        <?php if(Route::has('cards.index')): ?>
                            <a href="<?php echo e(route('cards.index')); ?>" class="bottom-nav-item <?php echo e(request()->routeIs('cards.*') ? 'active' : ''); ?>">
                                <i class="fas fa-credit-card text-xl mb-1"></i>
                                <span>Cards</span>
                            </a>
                        <?php else: ?>
                            <span class="bottom-nav-item text-gray-500 cursor-not-allowed">
                                <i class="fas fa-credit-card text-xl mb-1"></i>
                                <span>Cards</span>
                            </span>
                        <?php endif; ?>
                    </div>
                </nav>
                <?php endif; ?>
            </div>
        </div>

        <!-- Desktop Layout -->
        <div class="hidden lg:flex desktop-layout">
            <?php if(auth()->guard()->check()): ?>
            <!-- Desktop Sidebar -->
            <aside class="desktop-sidebar">
                <!-- Logo -->
                <div class="p-6 border-b border-dark-700/50">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-wallet text-white"></i>
                        </div>
                        <span class="text-xl font-bold text-white"><?php echo e(config('app.name', 'SwiftPay')); ?></span>
                    </div>
                </div>

                <!-- Navigation -->
                <nav class="flex-1 p-6">
                    <div class="space-y-2">
                        <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('dashboard') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-home w-5 mr-3"></i>
                            Dashboard
                        </a>
                        <a href="<?php echo e(route('wallet.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('wallet.*') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-wallet w-5 mr-3"></i>
                            Wallet
                        </a>
                        <a href="<?php echo e(route('transactions.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('transactions.*') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-exchange-alt w-5 mr-3"></i>
                            Transactions
                        </a>
                        <a href="<?php echo e(route('bills.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('bills.*') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-mobile-alt w-5 mr-3"></i>
                            Bills & VTU
                        </a>
                        <a href="<?php echo e(route('cards.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('cards.*') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-credit-card w-5 mr-3"></i>
                            Virtual Cards
                        </a>
                        <a href="<?php echo e(route('virtual-account.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl <?php echo e(request()->routeIs('virtual-account.*') ? 'bg-primary-600' : 'hover:bg-dark-800/50'); ?> transition-colors">
                            <i class="fas fa-university w-5 mr-3"></i>
                            Virtual Account
                        </a>
                        <?php if(!auth()->user()->hasCompletedKyc()): ?>
                        <a href="<?php echo e(route('kyc.index')); ?>" class="flex items-center px-4 py-3 text-white rounded-xl bg-orange-600 hover:bg-orange-700 transition-colors">
                            <i class="fas fa-shield-check w-5 mr-3"></i>
                            Complete KYC
                        </a>
                        <?php endif; ?>
                    </div>
                </nav>

                <!-- User Profile -->
                <div class="p-6 border-t border-dark-700/50">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-full flex items-center justify-center mr-3">
                            <span class="text-white font-semibold text-sm"><?php echo e(strtoupper(substr(auth()->user()->first_name, 0, 1))); ?></span>
                        </div>
                        <div class="flex-1">
                            <p class="text-white font-medium"><?php echo e(auth()->user()->first_name); ?></p>
                            <p class="text-gray-400 text-sm">₦<?php echo e(number_format(auth()->user()->wallet?->balance ?? 0, 2)); ?></p>
                        </div>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="p-2 text-gray-400 hover:text-white transition-colors">
                                <i class="fas fa-sign-out-alt"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </aside>

            <!-- Main Content Area -->
            <div class="desktop-main">
                <div class="desktop-content">
                    <!-- Flash Messages -->
                    <?php if(session('success')): ?>
                        <div class="bg-success-600/20 border border-success-600/30 text-success-400 px-4 py-3 rounded-lg mb-6 flex items-center">
                            <i class="fas fa-check-circle mr-3"></i>
                            <span><?php echo e(session('success')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="bg-red-600/20 border border-red-600/30 text-red-400 px-4 py-3 rounded-lg mb-6 flex items-center">
                            <i class="fas fa-exclamation-circle mr-3"></i>
                            <span><?php echo e(session('error')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </div>

                <!-- Transaction Feed (for desktop) -->
                <?php if(request()->routeIs('dashboard')): ?>
                <div class="desktop-transaction-feed">
                    <h3 class="text-lg font-bold text-white mb-6">Recent Activity</h3>
                    <?php if(isset($recentTransactions) && $recentTransactions->count() > 0): ?>
                        <div class="space-y-4">
                            <?php $__currentLoopData = $recentTransactions->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center p-3 bg-dark-800/30 rounded-lg">
                                <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 <?php echo e($transaction->type === 'credit' ? 'bg-green-500/20 text-green-400' : 'bg-red-500/20 text-red-400'); ?>">
                                    <i class="fas fa-<?php echo e($transaction->type === 'credit' ? 'arrow-down' : 'arrow-up'); ?> text-xs"></i>
                                </div>
                                <div class="flex-1">
                                    <p class="text-white text-sm font-medium"><?php echo e(Str::limit($transaction->description, 20)); ?></p>
                                    <p class="text-gray-400 text-xs"><?php echo e($transaction->created_at->format('M d')); ?></p>
                                </div>
                                <p class="text-sm font-bold <?php echo e($transaction->type === 'credit' ? 'text-green-400' : 'text-red-400'); ?>">
                                    <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 0)); ?>

                                </p>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-gray-400 text-sm">No recent activity</p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if(auth()->guard()->guest()): ?>
            <div class="w-full">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }

        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const menu = document.getElementById('mobile-menu');
            const button = event.target.closest('[onclick="toggleMobileMenu()"]');
            
            if (!button && menu && !menu.contains(event.target)) {
                menu.classList.add('hidden');
            }
        });

        // Add touch feedback for buttons
        document.addEventListener('touchstart', function(event) {
            if (event.target.closest('.btn, .quick-action, .bottom-nav-item')) {
                event.target.style.transform = 'scale(0.95)';
            }
        });

        document.addEventListener('touchend', function(event) {
            if (event.target.closest('.btn, .quick-action, .bottom-nav-item')) {
                setTimeout(() => {
                    event.target.style.transform = '';
                }, 100);
            }
        });

        // PWA Install prompt
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            deferredPrompt = e;
        });

        // Haptic feedback for supported devices
        function hapticFeedback() {
            if (navigator.vibrate) {
                navigator.vibrate(50);
            }
        }

        // Add haptic feedback to buttons
        document.addEventListener('click', function(event) {
            if (event.target.closest('.btn, .quick-action, .bottom-nav-item')) {
                hapticFeedback();
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/layouts/responsive.blade.php ENDPATH**/ ?>