<?php $__env->startSection('title', 'Pages Management'); ?>
<?php $__env->startSection('page-title', 'Pages Management'); ?>
<?php $__env->startSection('page-description', 'Manage static pages and content'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Pages Management</h2>
            <p class="text-gray-600 mt-1">Manage static pages, legal documents, and content</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="exportPages()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Export Pages
            </button>
            <button class="btn-primary" onclick="openPageModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Add New Page
            </button>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Pages</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pages->total()); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Published</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pages->where('status', 'published')->count()); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-5 h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Drafts</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pages->where('status', 'draft')->count()); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Recently Updated</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pages->where('updated_at', '>=', now()->subDays(7))->count()); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Pages List -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900">All Pages</h3>
                <div class="flex space-x-3">
                    <div class="relative">
                        <input type="text" placeholder="Search pages..." 
                               class="input-primary pl-10 pr-4 py-2 w-64"
                               id="searchPages">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <select class="input-primary" id="filterStatus">
                        <option value="">All Status</option>
                        <option value="published">Published</option>
                        <option value="draft">Draft</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Page
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Slug
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Last Updated
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200" id="pagesTableBody">
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 page-row" data-title="<?php echo e(strtolower($page->title)); ?>" data-status="<?php echo e($page->status); ?>">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div>
                                <div class="text-sm font-medium text-gray-900"><?php echo e($page->title); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e(Str::limit(strip_tags($page->content), 60)); ?></div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <code class="text-sm text-blue-600 bg-blue-50 px-2 py-1 rounded">/<?php echo e($page->slug); ?></code>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                <?php echo e($page->status === 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                                <?php echo e(ucfirst($page->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?php echo e($page->updated_at->format('M j, Y g:i A')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex space-x-2">
                                <button class="text-blue-600 hover:text-blue-900" onclick="viewPage(<?php echo e($page->id); ?>)">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </button>
                                <button class="text-green-600 hover:text-green-900" onclick="editPage(<?php echo e($page->id); ?>)">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                </button>
                                <button class="text-gray-600 hover:text-gray-900" onclick="duplicatePage(<?php echo e($page->id); ?>)">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                    </svg>
                                </button>
                                <?php if($page->status === 'published'): ?>
                                <button class="text-yellow-600 hover:text-yellow-900" onclick="togglePageStatus(<?php echo e($page->id); ?>, 'draft')">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21"></path>
                                    </svg>
                                </button>
                                <?php else: ?>
                                <button class="text-green-600 hover:text-green-900" onclick="togglePageStatus(<?php echo e($page->id); ?>, 'published')">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </button>
                                <?php endif; ?>
                                <button class="text-red-600 hover:text-red-900" onclick="deletePage(<?php echo e($page->id); ?>)">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Page Templates -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Page Templates</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-left" onclick="createFromTemplate('privacy-policy')">
                <div class="flex items-center mb-2">
                    <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                    </div>
                    <h4 class="text-sm font-medium text-gray-900">Privacy Policy</h4>
                </div>
                <p class="text-xs text-gray-500">Create a privacy policy page with standard template</p>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-left" onclick="createFromTemplate('terms-conditions')">
                <div class="flex items-center mb-2">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <h4 class="text-sm font-medium text-gray-900">Terms & Conditions</h4>
                </div>
                <p class="text-xs text-gray-500">Create terms and conditions with legal template</p>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-left" onclick="createFromTemplate('help-faq')">
                <div class="flex items-center mb-2">
                    <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-4 h-4 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h4 class="text-sm font-medium text-gray-900">Help & FAQ</h4>
                </div>
                <p class="text-xs text-gray-500">Create a help page with frequently asked questions</p>
            </button>
        </div>
    </div>
</div>

<!-- Page Creation/Edit Modal -->
<div id="pageModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
    <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-4xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900" id="modalTitle">Create New Page</h3>
                <button onclick="closePageModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            
            <form id="pageForm" action="<?php echo e(route('admin.settings.pages.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" value="POST" id="formMethod">
                <input type="hidden" name="page_id" id="pageId">
                
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Main Content -->
                    <div class="lg:col-span-2 space-y-6">
                        <!-- Title -->
                        <div>
                            <label for="title" class="block text-sm font-medium text-gray-700">Page Title</label>
                            <input type="text" name="title" id="title" required
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        
                        <!-- Slug -->
                        <div>
                            <label for="slug" class="block text-sm font-medium text-gray-700">Slug (URL)</label>
                            <div class="mt-1 flex rounded-md shadow-sm">
                                <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                    <?php echo e(url('/')); ?>/
                                </span>
                                <input type="text" name="slug" id="slug"
                                       class="flex-1 min-w-0 block w-full px-3 py-2 rounded-none rounded-r-md border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <p class="mt-1 text-sm text-gray-500">Leave empty to auto-generate from title</p>
                        </div>
                        
                        <!-- Content -->
                        <div>
                            <label for="content" class="block text-sm font-medium text-gray-700">Content</label>
                            <textarea name="content" id="content" rows="12" required
                                      class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"></textarea>
                        </div>
                        
                        <!-- Excerpt -->
                        <div>
                            <label for="excerpt" class="block text-sm font-medium text-gray-700">Excerpt</label>
                            <textarea name="excerpt" id="excerpt" rows="3"
                                      class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"></textarea>
                            <p class="mt-1 text-sm text-gray-500">Brief description for search results and previews</p>
                        </div>
                    </div>
                    
                    <!-- Sidebar -->
                    <div class="space-y-6">
                        <!-- Publish Status -->
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h4 class="text-sm font-medium text-gray-900 mb-3">Publish</h4>
                            
                            <div class="space-y-3">
                                <div>
                                    <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                                    <select name="status" id="status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                        <option value="draft">Draft</option>
                                        <option value="published">Published</option>
                                        <option value="archived">Archived</option>
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="is_featured" id="is_featured" value="1"
                                               class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                        <span class="ml-2 text-sm text-gray-700">Featured Page</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- SEO Settings -->
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h4 class="text-sm font-medium text-gray-900 mb-3">SEO Settings</h4>
                            
                            <div class="space-y-3">
                                <div>
                                    <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta Title</label>
                                    <input type="text" name="meta_title" id="meta_title"
                                           class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                    <p class="mt-1 text-xs text-gray-500">Leave empty to use page title</p>
                                </div>
                                
                                <div>
                                    <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" rows="3"
                                              class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"></textarea>
                                    <p class="mt-1 text-xs text-gray-500">Recommended: 150-160 characters</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Actions -->
                        <div class="flex space-x-3">
                            <button type="submit" class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <span id="submitText">Create Page</span>
                            </button>
                            <button type="button" onclick="closePageModal()" class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                Cancel
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Search functionality
document.getElementById('searchPages').addEventListener('input', function(e) {
    const searchTerm = e.target.value.toLowerCase();
    filterPages();
});

// Status filter functionality  
document.getElementById('filterStatus').addEventListener('change', function(e) {
    filterPages();
});

function filterPages() {
    const searchTerm = document.getElementById('searchPages').value.toLowerCase();
    const statusFilter = document.getElementById('filterStatus').value;
    const rows = document.querySelectorAll('.page-row');
    
    rows.forEach(row => {
        const title = row.dataset.title;
        const status = row.dataset.status;
        
        const matchesSearch = title.includes(searchTerm);
        const matchesStatus = !statusFilter || status === statusFilter;
        
        if (matchesSearch && matchesStatus) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

function openPageModal() {
    resetForm();
    document.getElementById('modalTitle').textContent = 'Create New Page';
    document.getElementById('submitText').textContent = 'Create Page';
    document.getElementById('formMethod').value = 'POST';
    document.getElementById('pageForm').action = '<?php echo e(route("admin.settings.pages.store")); ?>';
    document.getElementById('pageModal').classList.remove('hidden');
    
    // Initialize editor after modal is shown
    setTimeout(initializeEditor, 100);
}

function closePageModal() {
    // Destroy TinyMCE instance before closing
    if (typeof tinymce !== 'undefined') {
        tinymce.remove('#content');
    }
    document.getElementById('pageModal').classList.add('hidden');
    resetForm();
}

function resetForm() {
    document.getElementById('pageForm').reset();
    document.getElementById('pageId').value = '';
}

function viewPage(pageId) {
    // In a real implementation, this would open the page in a new tab or modal
    window.open('/admin/settings/pages/' + pageId, '_blank');
}

function editPage(pageId) {
    // Fetch page data and populate modal
    fetch(`/admin/settings/pages/${pageId}/edit`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const page = data.page;
                document.getElementById('modalTitle').textContent = 'Edit Page';
                document.getElementById('submitText').textContent = 'Update Page';
                document.getElementById('formMethod').value = 'PUT';
                document.getElementById('pageForm').action = `/admin/settings/pages/${pageId}`;
                document.getElementById('pageId').value = pageId;
                
                // Populate form fields
                document.getElementById('title').value = page.title;
                document.getElementById('slug').value = page.slug;
                document.getElementById('content').value = page.content;
                document.getElementById('excerpt').value = page.excerpt || '';
                document.getElementById('meta_title').value = page.meta_title || '';
                document.getElementById('meta_description').value = page.meta_description || '';
                document.getElementById('status').value = page.status;
                document.getElementById('is_featured').checked = page.is_featured;
                
                document.getElementById('pageModal').classList.remove('hidden');
                
                // Initialize editor after modal is shown and content is set
                setTimeout(() => {
                    initializeEditor();
                    // Set content again after editor is initialized
                    setTimeout(() => {
                        if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
                            tinymce.get('content').setContent(page.content);
                        }
                    }, 200);
                }, 100);
            }
        })
        .catch(error => {
            console.error('Error fetching page data:', error);
            alert('Error loading page data');
        });
}

function duplicatePage(pageId) {
    if(confirm('Are you sure you want to duplicate this page?')) {
        fetch(`/admin/settings/pages/${pageId}/duplicate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Error duplicating page');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error duplicating page');
        });
    }
}

function togglePageStatus(pageId, newStatus) {
    const action = newStatus === 'published' ? 'publish' : 'unpublish';
    if(confirm(`Are you sure you want to ${action} this page?`)) {
        fetch(`/admin/settings/pages/${pageId}/status`, {
            method: 'PATCH',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ status: newStatus })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || `Error ${action}ing page`);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert(`Error ${action}ing page`);
        });
    }
}

function deletePage(pageId) {
    if(confirm('Are you sure you want to delete this page? This action cannot be undone.')) {
        fetch(`/admin/settings/pages/${pageId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Error deleting page');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error deleting page');
        });
    }
}

function createFromTemplate(template) {
    resetForm();
    
    const templates = {
        'privacy-policy': {
            title: 'Privacy Policy',
            slug: 'privacy-policy',
            content: `<h1>Privacy Policy</h1>
<p>Last updated: [Date]</p>

<h2>Information We Collect</h2>
<p>We collect information you provide directly to us, such as when you create an account, make a transaction, or contact us.</p>

<h2>How We Use Your Information</h2>
<p>We use the information we collect to provide, maintain, and improve our services.</p>

<h2>Information Sharing</h2>
<p>We do not sell, trade, or rent your personal information to third parties.</p>

<h2>Data Security</h2>
<p>We implement appropriate security measures to protect your personal information.</p>

<h2>Contact Us</h2>
<p>If you have any questions about this Privacy Policy, please contact us.</p>`,
            status: 'draft'
        },
        'terms-conditions': {
            title: 'Terms & Conditions',
            slug: 'terms-conditions',
            content: `<h1>Terms & Conditions</h1>
<p>Last updated: [Date]</p>

<h2>Acceptance of Terms</h2>
<p>By accessing and using this service, you accept and agree to be bound by the terms and provision of this agreement.</p>

<h2>Use of the Service</h2>
<p>You agree to use our service only for lawful purposes and in accordance with these Terms.</p>

<h2>Account Responsibilities</h2>
<p>You are responsible for maintaining the confidentiality of your account and password.</p>

<h2>Prohibited Activities</h2>
<p>You may not use our service for any unlawful or prohibited activities.</p>

<h2>Limitation of Liability</h2>
<p>Our liability is limited to the maximum extent permitted by law.</p>

<h2>Contact Information</h2>
<p>For questions about these Terms, please contact us.</p>`,
            status: 'draft'
        },
        'help-faq': {
            title: 'Help & FAQ',
            slug: 'help-faq',
            content: `<h1>Frequently Asked Questions</h1>

<h2>Getting Started</h2>
<h3>How do I create an account?</h3>
<p>You can create an account by clicking the "Sign Up" button and following the registration process.</p>

<h3>Is my information secure?</h3>
<p>Yes, we use industry-standard security measures to protect your information.</p>

<h2>Account Management</h2>
<h3>How do I reset my password?</h3>
<p>Click "Forgot Password" on the login page and follow the instructions sent to your email.</p>

<h3>How do I update my profile?</h3>
<p>Go to Settings > Profile to update your personal information.</p>

<h2>Support</h2>
<h3>How do I contact support?</h3>
<p>You can contact our support team through the contact form or email us directly.</p>`,
            status: 'draft'
        }
    };
    
    const templateData = templates[template];
    if (templateData) {
        document.getElementById('modalTitle').textContent = 'Create New Page';
        document.getElementById('submitText').textContent = 'Create Page';
        document.getElementById('formMethod').value = 'POST';
        document.getElementById('pageForm').action = '<?php echo e(route("admin.settings.pages.store")); ?>';
        
        document.getElementById('title').value = templateData.title;
        document.getElementById('slug').value = templateData.slug;
        document.getElementById('content').value = templateData.content;
        document.getElementById('status').value = templateData.status;
        
        document.getElementById('pageModal').classList.remove('hidden');
        
        // Initialize editor after modal is shown and content is set
        setTimeout(() => {
            initializeEditor();
            // Set content again after editor is initialized
            setTimeout(() => {
                if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
                    tinymce.get('content').setContent(templateData.content);
                }
            }, 200);
        }, 100);
    }
}

function exportPages() {
    window.location.href = '<?php echo e(route("admin.settings.pages.export")); ?>';
}

// Auto-generate slug from title
document.getElementById('title').addEventListener('input', function(e) {
    const title = e.target.value;
    const slug = title.toLowerCase()
        .replace(/[^a-z0-9 -]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    
    // Only auto-fill if slug field is empty
    if (!document.getElementById('slug').value) {
        document.getElementById('slug').value = slug;
    }
});

// Close modal when clicking outside
document.getElementById('pageModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closePageModal();
    }
});

// Initialize TinyMCE rich text editor
function initializeEditor() {
    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: '#content',
            height: 400,
            menubar: false,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table paste code help wordcount'
            ],
            toolbar: 'undo redo | formatselect | bold italic backcolor | \
                alignleft aligncenter alignright alignjustify | \
                bullist numlist outdent indent | removeformat | help',
            content_style: 'body { font-family: -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif; font-size: 14px; }'
        });
    }
}

// Load TinyMCE when modal opens
function openPageModal() {
    resetForm();
    document.getElementById('modalTitle').textContent = 'Create New Page';
    document.getElementById('submitText').textContent = 'Create Page';
    document.getElementById('formMethod').value = 'POST';
    document.getElementById('pageForm').action = '<?php echo e(route("admin.settings.pages.store")); ?>';
    document.getElementById('pageModal').classList.remove('hidden');
    
    // Initialize editor after modal is shown
    setTimeout(initializeEditor, 100);
}

function closePageModal() {
    // Destroy TinyMCE instance before closing
    if (typeof tinymce !== 'undefined') {
        tinymce.remove('#content');
    }
    document.getElementById('pageModal').classList.add('hidden');
    resetForm();
}
// Load TinyMCE script if not already loaded
if (typeof tinymce === 'undefined') {
    const script = document.createElement('script');
    script.src = 'https://cdn.tiny.cloud/1/<?php echo e(env("TINYMCE_API_KEY")); ?>/tinymce/6/tinymce.min.js';
    script.referrerPolicy = 'origin';
    document.head.appendChild(script);
}

// Form submission handler
document.getElementById('pageForm').addEventListener('submit', function(e) {
    // Sync TinyMCE content before submission
    if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
        tinymce.get('content').save();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/pages.blade.php ENDPATH**/ ?>