<?php $__env->startSection('title', 'Fees & Limits Settings'); ?>
<?php $__env->startSection('page-title', 'Fees & Limits Settings'); ?>
<?php $__env->startSection('page-description', 'Configure transaction fees, limits, and requirements'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Actions -->
    <div class="flex justify-end">
        <button onclick="backupSettings()" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white text-sm font-medium rounded-lg hover:bg-gray-700 transition-colors mr-3">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
            </svg>
            Backup Settings
        </button>
    </div>

    <form method="POST" action="<?php echo e(route('admin.settings.fees.update')); ?>" class="space-y-6">
        <?php echo csrf_field(); ?>

        <!-- Transaction Fees -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">Transaction Fees</h3>
                    <p class="text-sm text-gray-600">Configure fees for different transaction types</p>
                </div>
                <div class="flex items-center">
                    <span class="text-sm text-gray-500 mr-2">Last updated:</span>
                    <span class="text-sm font-medium text-gray-900">2 hours ago</span>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Transfer Fees -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Transfer Fees</h4>
                    
                    <div>
                        <label for="transfer_fee_type" class="block text-sm font-medium text-gray-700 mb-1">Fee Type</label>
                        <select name="transfer_fee_type" id="transfer_fee_type" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                onchange="toggleTransferFeeInput()">
                            <option value="percentage" <?php echo e($settings['fees']['transfer_fee_type'] === 'percentage' ? 'selected' : ''); ?>>Percentage</option>
                            <option value="flat" <?php echo e($settings['fees']['transfer_fee_type'] === 'flat' ? 'selected' : ''); ?>>Flat Amount</option>
                        </select>
                    </div>

                    <div id="percentage_fee" class="<?php echo e($settings['fees']['transfer_fee_type'] === 'percentage' ? '' : 'hidden'); ?>">
                        <label for="transfer_fee_value" class="block text-sm font-medium text-gray-700 mb-1">Percentage (%)</label>
                        <input type="number" name="transfer_fee_value" id="transfer_fee_value" 
                               value="<?php echo e($settings['fees']['transfer_fee_value']); ?>" 
                               step="0.1" min="0" max="100"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div id="flat_fee" class="<?php echo e($settings['fees']['transfer_fee_type'] === 'flat' ? '' : 'hidden'); ?>">
                        <label for="transfer_flat_fee" class="block text-sm font-medium text-gray-700 mb-1">Flat Amount (₦)</label>
                        <input type="number" name="transfer_flat_fee" id="transfer_flat_fee" 
                               value="<?php echo e($settings['fees']['transfer_flat_fee']); ?>" 
                               step="0.01" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Other Fees -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Other Fees</h4>
                    
                    <div>
                        <label for="withdrawal_fee_type" class="block text-sm font-medium text-gray-700 mb-1">Withdrawal Fee Type</label>
                        <select name="withdrawal_fee_type" id="withdrawal_fee_type" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="percentage" <?php echo e(($settings['fees']['withdrawal_fee_type'] ?? 'flat') === 'percentage' ? 'selected' : ''); ?>>Percentage</option>
                            <option value="flat" <?php echo e(($settings['fees']['withdrawal_fee_type'] ?? 'flat') === 'flat' ? 'selected' : ''); ?>>Flat Amount</option>
                        </select>
                    </div>

                    <div>
                        <label for="withdrawal_fee_value" class="block text-sm font-medium text-gray-700 mb-1">Withdrawal Fee (₦)</label>
                        <input type="number" name="withdrawal_fee_value" id="withdrawal_fee_value" 
                               value="<?php echo e($settings['fees']['withdrawal_fee_value']); ?>" 
                               step="0.01" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_issuance_fee" class="block text-sm font-medium text-gray-700 mb-1">Card Issuance Fee (₦)</label>
                        <input type="number" name="card_issuance_fee" id="card_issuance_fee" 
                               value="<?php echo e($settings['fees']['card_issuance_fee']); ?>" 
                               step="0.01" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_maintenance_fee" class="block text-sm font-medium text-gray-700 mb-1">Card Maintenance Fee (₦/month)</label>
                        <input type="number" name="card_maintenance_fee" id="card_maintenance_fee" 
                               value="<?php echo e($settings['fees']['card_maintenance_fee']); ?>" 
                               step="0.01" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="virtual_account_fee" class="block text-sm font-medium text-gray-700 mb-1">Virtual Account Fee (₦)</label>
                        <input type="number" name="virtual_account_fee" id="virtual_account_fee" 
                               value="<?php echo e($settings['fees']['virtual_account_fee'] ?? 0); ?>" 
                               step="0.01" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction Limits -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Transaction Limits</h3>
                <p class="text-sm text-gray-600">Set daily and per-transaction limits</p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Transfer Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Transfer Limits</h4>
                    
                    <div>
                        <label for="daily_transfer_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Transfer Limit (₦)</label>
                        <input type="number" name="daily_transfer_limit" id="daily_transfer_limit" 
                               value="<?php echo e($settings['limits']['daily_transfer_limit']); ?>" 
                               step="1000" min="1000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="single_transfer_limit" class="block text-sm font-medium text-gray-700 mb-1">Single Transfer Limit (₦)</label>
                        <input type="number" name="single_transfer_limit" id="single_transfer_limit" 
                               value="<?php echo e($settings['limits']['single_transfer_limit']); ?>" 
                               step="1000" min="1000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Withdrawal Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Withdrawal Limits</h4>
                    
                    <div>
                        <label for="daily_withdrawal_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Withdrawal Limit (₦)</label>
                        <input type="number" name="daily_withdrawal_limit" id="daily_withdrawal_limit" 
                               value="<?php echo e($settings['limits']['daily_withdrawal_limit']); ?>" 
                               step="1000" min="1000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="single_withdrawal_limit" class="block text-sm font-medium text-gray-700 mb-1">Single Withdrawal Limit (₦)</label>
                        <input type="number" name="single_withdrawal_limit" id="single_withdrawal_limit" 
                               value="<?php echo e($settings['limits']['single_withdrawal_limit']); ?>" 
                               step="1000" min="1000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Airtime & Data Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Airtime & Data Limits</h4>
                    
                    <div>
                        <label for="daily_airtime_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Airtime Limit (₦)</label>
                        <input type="number" name="daily_airtime_limit" id="daily_airtime_limit" 
                               value="<?php echo e($settings['limits']['daily_airtime_limit'] ?? 10000); ?>" 
                               step="100" min="100" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="single_airtime_limit" class="block text-sm font-medium text-gray-700 mb-1">Single Airtime Limit (₦)</label>
                        <input type="number" name="single_airtime_limit" id="single_airtime_limit" 
                               value="<?php echo e($settings['limits']['single_airtime_limit'] ?? 5000); ?>" 
                               step="100" min="10" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6 mt-6">
                <!-- Card Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Card Limits</h4>
                    
                    <div>
                        <label for="card_daily_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Card Limit (₦)</label>
                        <input type="number" name="card_daily_limit" id="card_daily_limit" 
                               value="<?php echo e($settings['limits']['card_daily_limit']); ?>" 
                               step="1000" min="1000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_monthly_limit" class="block text-sm font-medium text-gray-700 mb-1">Monthly Card Limit (₦)</label>
                        <input type="number" name="card_monthly_limit" id="card_monthly_limit" 
                               value="<?php echo e($settings['limits']['card_monthly_limit']); ?>" 
                               step="10000" min="10000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Wallet Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Wallet Limits</h4>
                    
                    <div>
                        <label for="minimum_wallet_balance" class="block text-sm font-medium text-gray-700 mb-1">Minimum Wallet Balance (₦)</label>
                        <input type="number" name="minimum_wallet_balance" id="minimum_wallet_balance" 
                               value="<?php echo e($settings['limits']['minimum_wallet_balance']); ?>" 
                               step="10" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>
        </div>

        <!-- Security Requirements -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Security Requirements</h3>
                <p class="text-sm text-gray-600">Configure KYC and security requirements</p>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- KYC Requirements -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">KYC Requirements</h4>
                    
                    <div class="flex items-center">
                        <input type="hidden" name="kyc_required_for_transfers" value="0">
                        <input type="checkbox" name="kyc_required_for_transfers" id="kyc_required_for_transfers" value="1"
                               <?php echo e($settings['requirements']['kyc_required_for_transfers'] ? 'checked' : ''); ?>

                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="kyc_required_for_transfers" class="ml-2 text-sm text-gray-700">Require KYC for transfers</label>
                    </div>

                    <div class="flex items-center">
                        <input type="hidden" name="kyc_required_for_cards" value="0">
                        <input type="checkbox" name="kyc_required_for_cards" id="kyc_required_for_cards" value="1"
                               <?php echo e($settings['requirements']['kyc_required_for_cards'] ? 'checked' : ''); ?>

                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="kyc_required_for_cards" class="ml-2 text-sm text-gray-700">Require KYC for virtual cards</label>
                    </div>

                    <div>
                        <label for="kyc_required_amount_threshold" class="block text-sm font-medium text-gray-700 mb-1">KYC Required Above (₦)</label>
                        <input type="number" name="kyc_required_amount_threshold" id="kyc_required_amount_threshold" 
                               value="<?php echo e($settings['requirements']['kyc_required_amount_threshold']); ?>" 
                               step="1000" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Amount above which KYC is mandatory</p>
                    </div>
                </div>

                <!-- Security Requirements -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">2FA Requirements</h4>
                    
                    <div class="flex items-center">
                        <input type="hidden" name="require_2fa_for_large_transfers" value="0">
                        <input type="checkbox" name="require_2fa_for_large_transfers" id="require_2fa_for_large_transfers" value="1"
                               <?php echo e($settings['requirements']['require_2fa_for_large_transfers'] ? 'checked' : ''); ?>

                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="require_2fa_for_large_transfers" class="ml-2 text-sm text-gray-700">Require 2FA for large transfers</label>
                    </div>

                    <div>
                        <label for="large_transfer_threshold" class="block text-sm font-medium text-gray-700 mb-1">Large Transfer Threshold (₦)</label>
                        <input type="number" name="large_transfer_threshold" id="large_transfer_threshold" 
                               value="<?php echo e($settings['requirements']['large_transfer_threshold']); ?>" 
                               step="10000" min="10000" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Amount above which 2FA is required</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Actions -->
        <div class="flex justify-between items-center">
            <div class="text-sm text-gray-600">
                <span class="inline-flex items-center">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Changes will take effect immediately
                </span>
            </div>
            <div class="flex space-x-3">
                <button type="button" onclick="resetToDefaults()" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                    Reset to Defaults
                </button>
                <button type="submit" id="saveButton" class="px-6 py-2 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                    <span id="saveButtonText">Save Settings</span>
                    <svg id="saveSpinner" class="animate-spin ml-2 h-4 w-4 text-white hidden" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </button>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    const saveButton = document.getElementById('saveButton');
    const saveButtonText = document.getElementById('saveButtonText');
    const saveSpinner = document.getElementById('saveSpinner');

    // Form validation
    function validateForm() {
        const errors = [];
        const requiredFields = form.querySelectorAll('input[required], select[required]');
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                errors.push(`${field.labels?.[0]?.textContent || field.name} is required`);
                field.classList.add('border-red-300');
            } else {
                field.classList.remove('border-red-300');
            }
        });

        // Validate numeric fields
        const numericFields = form.querySelectorAll('input[type="number"]');
        numericFields.forEach(field => {
            if (field.value && isNaN(field.value)) {
                errors.push(`${field.labels[0]?.textContent || field.name} must be a valid number`);
                field.classList.add('border-red-300');
            }
        });

        // Custom business logic validation
        const dailyTransferLimit = parseInt(document.getElementById('daily_transfer_limit').value);
        const singleTransferLimit = parseInt(document.getElementById('single_transfer_limit').value);
        
        if (dailyTransferLimit && singleTransferLimit && singleTransferLimit > dailyTransferLimit) {
            errors.push('Single transfer limit cannot exceed daily transfer limit');
        }

        const dailyWithdrawalLimit = parseInt(document.getElementById('daily_withdrawal_limit').value);
        const singleWithdrawalLimit = parseInt(document.getElementById('single_withdrawal_limit').value);
        
        if (dailyWithdrawalLimit && singleWithdrawalLimit && singleWithdrawalLimit > dailyWithdrawalLimit) {
            errors.push('Single withdrawal limit cannot exceed daily withdrawal limit');
        }

        const dailyAirtimeLimit = parseInt(document.getElementById('daily_airtime_limit').value);
        const singleAirtimeLimit = parseInt(document.getElementById('single_airtime_limit').value);
        
        if (dailyAirtimeLimit && singleAirtimeLimit && singleAirtimeLimit > dailyAirtimeLimit) {
            errors.push('Single airtime limit cannot exceed daily airtime limit');
        }

        return errors;
    }

    // Show validation errors
    function showErrors(errors) {
        // Remove existing error messages
        document.querySelectorAll('.validation-error').forEach(el => el.remove());
        
        if (errors.length > 0) {
            const errorContainer = document.createElement('div');
            errorContainer.className = 'validation-error bg-red-50 border border-red-200 rounded-lg p-4 mb-4';
            errorContainer.innerHTML = `
                <div class="flex">
                    <svg class="w-5 h-5 text-red-400 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <h3 class="text-sm font-medium text-red-800">Please fix the following errors:</h3>
                        <ul class="mt-1 text-sm text-red-700 list-disc list-inside">
                            ${errors.map(error => `<li>${error}</li>`).join('')}
                        </ul>
                    </div>
                </div>
            `;
            form.insertBefore(errorContainer, form.firstChild);
            errorContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    }

    // Form submission
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const errors = validateForm();
        if (errors.length > 0) {
            showErrors(errors);
            return;
        }

        // Show loading state
        saveButton.disabled = true;
        saveButtonText.textContent = 'Saving...';
        saveSpinner.classList.remove('hidden');

        // Submit form
        const formData = new FormData(form);
        
        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
            }
        })
        .then(async response => {
            let data;
            const contentType = response.headers.get('content-type') || '';
            if (!response.ok) {
                // Try to parse error message from JSON, otherwise use status text
                if (contentType.includes('application/json')) {
                    try {
                        data = await response.json();
                        throw new Error(data.message || 'Failed to save settings');
                    } catch (e) {
                        throw new Error(response.statusText || 'Failed to save settings');
                    }
                } else {
                    throw new Error(response.statusText || 'Failed to save settings');
                }
            }
            // Response is OK, try to parse JSON
            if (contentType.includes('application/json')) {
                try {
                    data = await response.json();
                } catch (e) {
                    throw new Error('Failed to parse server response.');
                }
            } else {
                throw new Error('Unexpected response format from server.');
            }
            return data;
        })
        .then(data => {
            if (data.success !== false) {
                // Show success message
                const successContainer = document.createElement('div');
                successContainer.className = 'bg-green-50 border border-green-200 rounded-lg p-4 mb-4';
                successContainer.innerHTML = `
                    <div class="flex">
                        <svg class="w-5 h-5 text-green-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-sm font-medium text-green-800">Settings saved successfully! Changes are now active across the platform.</p>
                    </div>
                `;
                form.insertBefore(successContainer, form.firstChild);
                successContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
                
                // Remove success message after 5 seconds
                setTimeout(() => successContainer.remove(), 5000);
            } else {
                throw new Error(data.message || 'Failed to save settings');
            }
        })
        .catch(error => {
            showErrors([error.message || 'An error occurred while saving settings']);
        })
        .finally(() => {
            // Reset button state
            saveButton.disabled = false;
            saveButtonText.textContent = 'Save Settings';
            saveSpinner.classList.add('hidden');
        });
    });

    // Real-time validation on input change
    const formInputs = form.querySelectorAll('input, select');
    formInputs.forEach(input => {
        input.addEventListener('blur', function() {
            if (this.hasAttribute('required') && !this.value.trim()) {
                this.classList.add('border-red-300');
            } else {
                this.classList.remove('border-red-300');
            }
        });
    });
});

function toggleTransferFeeInput() {
    const feeType = document.getElementById('transfer_fee_type').value;
    const percentageDiv = document.getElementById('percentage_fee');
    const flatDiv = document.getElementById('flat_fee');
    
    if (feeType === 'percentage') {
        percentageDiv.classList.remove('hidden');
        flatDiv.classList.add('hidden');
        // Make percentage field required and flat field optional
        document.getElementById('transfer_fee_value').setAttribute('required', '');
        document.getElementById('transfer_flat_fee').removeAttribute('required');
    } else {
        percentageDiv.classList.add('hidden');
        flatDiv.classList.remove('hidden');
        // Make flat field required and percentage field optional
        document.getElementById('transfer_flat_fee').setAttribute('required', '');
        document.getElementById('transfer_fee_value').removeAttribute('required');
    }
}

function resetToDefaults() {
    if (confirm('Are you sure you want to reset all settings to defaults? This cannot be undone.')) {
        // Reset form to default values
        document.getElementById('transfer_fee_type').value = 'percentage';
        document.getElementById('transfer_fee_value').value = '1.5';
        document.getElementById('transfer_flat_fee').value = '10.00';
        document.getElementById('withdrawal_fee_type').value = 'flat';
        document.getElementById('withdrawal_fee_value').value = '25';
        document.getElementById('card_issuance_fee').value = '500';
        document.getElementById('card_maintenance_fee').value = '50';
        document.getElementById('virtual_account_fee').value = '0';
        document.getElementById('daily_transfer_limit').value = '500000';
        document.getElementById('single_transfer_limit').value = '100000';
        document.getElementById('daily_withdrawal_limit').value = '200000';
        document.getElementById('single_withdrawal_limit').value = '50000';
        document.getElementById('daily_airtime_limit').value = '10000';
        document.getElementById('single_airtime_limit').value = '5000';
        document.getElementById('card_daily_limit').value = '100000';
        document.getElementById('card_monthly_limit').value = '1000000';
        document.getElementById('minimum_wallet_balance').value = '100';
        document.getElementById('kyc_required_for_transfers').checked = true;
        document.getElementById('kyc_required_for_cards').checked = true;
        document.getElementById('kyc_required_amount_threshold').value = '50000';
        document.getElementById('require_2fa_for_large_transfers').checked = true;
        document.getElementById('large_transfer_threshold').value = '100000';
        
        toggleTransferFeeInput();
        alert('Settings reset to defaults. Remember to save your changes.');
    }
}

function backupSettings() {
    // In a real implementation, this would create a backup
    alert('Settings backup created successfully!');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/fees.blade.php ENDPATH**/ ?>