<?php $__env->startSection('title', 'Notification Settings'); ?>
<?php $__env->startSection('page-title', 'Notification Management'); ?>
<?php $__env->startSection('page-description', 'Configure notification settings and send broadcast messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Notification Management</h2>
            <p class="text-gray-600 mt-1">Configure notification settings and manage user communications</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="testNotifications()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Test Notifications
            </button>
            <button class="btn-primary" onclick="openBroadcastModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                </svg>
                Send Broadcast
            </button>
        </div>
    </div>

    <!-- Email Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Email Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__currentLoopData = $settings['email_notifications']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900"><?php echo e(ucwords(str_replace('_', ' ', $notification))); ?></h4>
                    <p class="text-xs text-gray-500">
                        <?php switch($notification):
                            case ('user_registration'): ?>
                                Welcome email when users register
                            <?php break; ?>
                            <?php case ('kyc_approval'): ?>
                                Email when KYC is approved
                            <?php break; ?>
                            <?php case ('kyc_rejection'): ?>
                                Email when KYC is rejected
                            <?php break; ?>
                            <?php case ('transaction_success'): ?>
                                Email for successful transactions
                            <?php break; ?>
                            <?php case ('transaction_failure'): ?>
                                Email for failed transactions
                            <?php break; ?>
                            <?php case ('card_issuance'): ?>
                                Email when virtual card is issued
                            <?php break; ?>
                            <?php case ('suspicious_activity'): ?>
                                Email for security alerts
                            <?php break; ?>
                            <?php case ('password_reset'): ?>
                                Email for password reset requests
                            <?php break; ?>
                            <?php case ('low_balance_warning'): ?>
                                Email when wallet balance is low
                            <?php break; ?>
                            <?php default: ?>
                                Email notification setting
                        <?php endswitch; ?>
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="email_notifications[<?php echo e($notification); ?>]" 
                           value="1" 
                           <?php echo e($enabled ? 'checked' : ''); ?>

                           class="sr-only peer"
                           onchange="updateNotificationSetting('email', '<?php echo e($notification); ?>', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                </label>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- SMS Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">SMS Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__currentLoopData = $settings['sms_notifications']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900"><?php echo e(ucwords(str_replace('_', ' ', $notification))); ?></h4>
                    <p class="text-xs text-gray-500">
                        <?php switch($notification):
                            case ('transaction_alerts'): ?>
                                SMS for transaction notifications
                            <?php break; ?>
                            <?php case ('otp_verification'): ?>
                                SMS for OTP codes
                            <?php break; ?>
                            <?php case ('security_alerts'): ?>
                                SMS for security notifications
                            <?php break; ?>
                            <?php case ('balance_alerts'): ?>
                                SMS for balance updates
                            <?php break; ?>
                            <?php case ('promotional_messages'): ?>
                                SMS for promotions and offers
                            <?php break; ?>
                            <?php default: ?>
                                SMS notification setting
                        <?php endswitch; ?>
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="sms_notifications[<?php echo e($notification); ?>]" 
                           value="1" 
                           <?php echo e($enabled ? 'checked' : ''); ?>

                           class="sr-only peer"
                           onchange="updateNotificationSetting('sms', '<?php echo e($notification); ?>', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-green-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-600"></div>
                </label>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Push Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Push Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__currentLoopData = $settings['push_notifications']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900"><?php echo e(ucwords(str_replace('_', ' ', $notification))); ?></h4>
                    <p class="text-xs text-gray-500">
                        <?php switch($notification):
                            case ('transaction_updates'): ?>
                                Push notifications for transactions
                            <?php break; ?>
                            <?php case ('system_maintenance'): ?>
                                Push notifications for maintenance
                            <?php break; ?>
                            <?php case ('new_features'): ?>
                                Push notifications for new features
                            <?php break; ?>
                            <?php case ('promotional_offers'): ?>
                                Push notifications for promotions
                            <?php break; ?>
                            <?php default: ?>
                                Push notification setting
                        <?php endswitch; ?>
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="push_notifications[<?php echo e($notification); ?>]" 
                           value="1" 
                           <?php echo e($enabled ? 'checked' : ''); ?>

                           class="sr-only peer"
                           onchange="updateNotificationSetting('push', '<?php echo e($notification); ?>', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                </label>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Admin Notifications -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Admin Notifications</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__currentLoopData = $settings['admin_notifications']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <div>
                    <h4 class="text-sm font-medium text-gray-900"><?php echo e(ucwords(str_replace('_', ' ', $notification))); ?></h4>
                    <p class="text-xs text-gray-500">
                        <?php switch($notification):
                            case ('new_user_registration'): ?>
                                Notify when new users register
                            <?php break; ?>
                            <?php case ('kyc_submissions'): ?>
                                Notify when KYC is submitted
                            <?php break; ?>
                            <?php case ('high_value_transactions'): ?>
                                Notify for large transactions
                            <?php break; ?>
                            <?php case ('failed_transactions'): ?>
                                Notify when transactions fail
                            <?php break; ?>
                            <?php case ('system_errors'): ?>
                                Notify for system errors
                            <?php break; ?>
                            <?php case ('security_incidents'): ?>
                                Notify for security events
                            <?php break; ?>
                            <?php default: ?>
                                Admin notification setting
                        <?php endswitch; ?>
                    </p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           name="admin_notifications[<?php echo e($notification); ?>]" 
                           value="1" 
                           <?php echo e($enabled ? 'checked' : ''); ?>

                           class="sr-only peer"
                           onchange="updateNotificationSetting('admin', '<?php echo e($notification); ?>', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-red-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-red-600"></div>
                </label>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Broadcast Messages -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-lg font-semibold text-gray-900">Recent Broadcast Messages</h3>
            <button class="btn-primary" onclick="openBroadcastModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                New Broadcast
            </button>
        </div>

        <?php if(count($broadcasts) > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $broadcasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $broadcast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 rounded-lg p-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-center space-x-3">
                            <h4 class="text-lg font-medium text-gray-900"><?php echo e($broadcast['title']); ?></h4>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                <?php echo e($broadcast['type'] === 'maintenance' ? 'bg-yellow-100 text-yellow-800' : 
                                   ($broadcast['type'] === 'feature' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800')); ?>">
                                <?php echo e(ucfirst($broadcast['type'])); ?>

                            </span>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                <?php echo e($broadcast['status'] === 'sent' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                <?php echo e(ucfirst($broadcast['status'])); ?>

                            </span>
                        </div>
                        <p class="text-gray-600 mt-2"><?php echo e($broadcast['message']); ?></p>
                        <div class="flex items-center space-x-4 mt-3 text-sm text-gray-500">
                            <span>Recipients: <?php echo e(ucwords(str_replace('_', ' ', $broadcast['recipients']))); ?></span>
                            <span>Sent: <?php echo e($broadcast['sent_at']); ?></span>
                        </div>
                    </div>
                    <div class="flex space-x-2 ml-4">
                        <button class="text-blue-600 hover:text-blue-900" onclick="viewBroadcastDetails(<?php echo e($broadcast['id']); ?>)">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                        </button>
                        <button class="text-green-600 hover:text-green-900" onclick="duplicateBroadcast(<?php echo e($broadcast['id']); ?>)">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No broadcast messages</h3>
            <p class="mt-1 text-sm text-gray-500">Get started by sending your first broadcast message to users.</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- SMTP Configuration Section -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mt-6">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h3 class="text-lg font-semibold text-gray-900">Email Configuration (SMTP)</h3>
                <p class="text-sm text-gray-600">Configure SMTP settings for outgoing emails</p>
            </div>
            <button id="saveSmtpConfig" class="btn-primary flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors duration-200">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                Save Configuration
            </button>
        </div>
        
        <form id="smtpConfigForm" class="space-y-4">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        SMTP Host <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           name="smtp_host" 
                           value="<?php echo e(setting('mail.smtp.host', '')); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="smtp.gmail.com"
                           required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        SMTP Port <span class="text-red-500">*</span>
                    </label>
                    <input type="number" 
                           name="smtp_port" 
                           value="<?php echo e(setting('mail.smtp.port', 587)); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="587"
                           min="1" 
                           max="65535"
                           required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        SMTP Username <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           name="smtp_username" 
                           value="<?php echo e(setting('mail.smtp.username', '')); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="your-email@gmail.com"
                           required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        SMTP Password <span class="text-red-500">*</span>
                    </label>
                    <input type="password" 
                           name="smtp_password" 
                           value="<?php echo e(setting('mail.smtp.password', '')); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="Your app password"
                           required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Encryption</label>
                    <select name="smtp_encryption" class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="tls" <?php echo e(setting('mail.smtp.encryption', 'tls') === 'tls' ? 'selected' : ''); ?>>TLS</option>
                        <option value="ssl" <?php echo e(setting('mail.smtp.encryption', 'tls') === 'ssl' ? 'selected' : ''); ?>>SSL</option>
                        <option value="" <?php echo e(setting('mail.smtp.encryption', 'tls') === '' ? 'selected' : ''); ?>>None</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        From Email <span class="text-red-500">*</span>
                    </label>
                    <input type="email" 
                           name="mail_from_address" 
                           value="<?php echo e(setting('mail.from.address', '')); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="noreply@yoursite.com"
                           required>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        From Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           name="mail_from_name" 
                           value="<?php echo e(setting('mail.from.name', setting('business.name', 'SwiftPay'))); ?>" 
                           class="input-primary w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                           placeholder="Your Company Name"
                           required>
                </div>
            </div>
            
            <div class="bg-gray-50 p-4 rounded-lg">
                <p class="text-sm text-gray-600 mb-2">
                    <svg class="w-4 h-4 inline-block mr-1 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <strong>Configuration Tips:</strong>
                </p>
                <ul class="text-sm text-gray-600 space-y-1 ml-5">
                    <li>• For Gmail: Use smtp.gmail.com:587 with TLS encryption</li>
                    <li>• For Gmail: Enable "App Passwords" and use that instead of your regular password</li>
                    <li>• Common ports: 587 (TLS), 465 (SSL), 25 (unencrypted)</li>
                    <li>• Test the connection before saving to ensure settings work</li>
                </ul>
            </div>
            
            <div class="flex space-x-4 pt-4 border-t border-gray-200">
                <button type="button" id="testSmtpConfig" class="btn-secondary flex items-center px-4 py-2 border border-gray-300 rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Test Connection
                </button>
                <button type="button" id="sendTestEmail" class="btn-secondary flex items-center px-4 py-2 border border-gray-300 rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    Send Test Email
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Broadcast Modal -->
<div id="broadcastModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity" aria-hidden="true">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
            <form id="broadcastForm" method="POST" action="<?php echo e(route('admin.settings.notifications.broadcast')); ?>">
                <?php echo csrf_field(); ?>
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:mt-0 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Send Broadcast Message</h3>
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                                    <input type="text" name="title" required class="input-primary" placeholder="Broadcast title">
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Message</label>
                                    <textarea name="message" required rows="4" class="input-primary" placeholder="Your broadcast message..."></textarea>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Type</label>
                                    <select name="type" required class="input-primary">
                                        <option value="info">Information</option>
                                        <option value="warning">Warning</option>
                                        <option value="success">Success</option>
                                        <option value="error">Error</option>
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Delivery Channels</label>
                                    <div class="space-y-2">
                                        <div class="flex items-center">
                                            <input type="checkbox" id="channel_in_app" name="channels[]" value="in_app" checked class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                            <label for="channel_in_app" class="ml-2 block text-sm text-gray-900">In-App Notification</label>
                                        </div>
                                        <div class="flex items-center">
                                            <input type="checkbox" id="channel_email" name="channels[]" value="email" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                            <label for="channel_email" class="ml-2 block text-sm text-gray-900">Email</label>
                                        </div>
                                        <div class="flex items-center">
                                            <input type="checkbox" id="channel_sms" name="channels[]" value="sms" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                            <label for="channel_sms" class="ml-2 block text-sm text-gray-900">SMS</label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Recipients</label>
                                    <select name="recipients" required class="input-primary">
                                        <option value="all_users">All Users</option>
                                        <option value="verified_users">Verified Users Only</option>
                                        <option value="unverified_users">Unverified Users Only</option>
                                        <option value="active_users">Active Users Only</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="submit" class="btn-primary ml-3">
                        Send Broadcast
                    </button>
                    <button type="button" class="btn-secondary" onclick="closeBroadcastModal()">
                        Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function updateNotificationSetting(type, notification, enabled) {
    fetch('/admin/settings/notifications/setting', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            type: type,
            setting: notification,
            enabled: enabled
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', data.message);
        } else {
            showNotification('error', data.message || 'Failed to update setting');
        }
    })
    .catch(error => {
        showNotification('error', 'Error updating setting: ' + error.message);
    });
}

function testNotifications() {
    const button = event.target;
    const originalText = button.innerHTML;
    
    button.disabled = true;
    button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Testing...';
    
    fetch('/admin/settings/notifications/test', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            let message = 'Notification systems tested:\n';
            Object.entries(data.results).forEach(([system, result]) => {
                message += `${system.toUpperCase()}: ${result.status} - ${result.message}\n`;
            });
            showNotification('success', message);
        } else {
            showNotification('error', data.message || 'Test failed');
        }
    })
    .catch(error => {
        showNotification('error', 'Test failed: ' + error.message);
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
    });
}

function showNotification(type, message) {
    // Create notification element
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-md ${type === 'success' ? 'bg-emerald-500 text-white' : 'bg-red-500 text-white'}`;
    notification.innerHTML = `
        <div class="flex items-start">
            <span class="flex-1 text-sm whitespace-pre-line">${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white hover:text-gray-200 flex-shrink-0">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Auto-remove after 8 seconds
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 8000);
}

function openBroadcastModal() {
    document.getElementById('broadcastModal').classList.remove('hidden');
}

function closeBroadcastModal() {
    document.getElementById('broadcastModal').classList.add('hidden');
    document.getElementById('broadcastForm').reset();
}

function viewBroadcastDetails(broadcastId) {
    // Create and show a modal with broadcast details
    showNotification('info', 'Loading broadcast details...');
    
    fetch(`/admin/settings/notifications/broadcast/${broadcastId}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showBroadcastDetailsModal(data.broadcast);
        } else {
            showNotification('error', 'Failed to load broadcast details');
        }
    })
    .catch(error => {
        showNotification('error', 'Error loading broadcast details: ' + error.message);
    });
}

function duplicateBroadcast(broadcastId) {
    // Fetch broadcast data and populate the form
    showNotification('info', 'Loading broadcast for duplication...');
    
    fetch(`/admin/settings/notifications/broadcast/${broadcastId}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            populateBroadcastForm(data.broadcast);
            openBroadcastModal();
            showNotification('success', 'Broadcast loaded for editing');
        } else {
            showNotification('error', 'Failed to load broadcast for duplication');
        }
    })
    .catch(error => {
        showNotification('error', 'Error loading broadcast: ' + error.message);
    });
}

function showBroadcastDetailsModal(broadcast) {
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-gray-600 bg-opacity-50 z-50';
    modal.innerHTML = `
        <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20">
            <div class="bg-white rounded-lg max-w-2xl w-full max-h-96 overflow-y-auto">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium">Broadcast Details</h3>
                        <button onclick="this.closest('.fixed').remove()" class="text-gray-400 hover:text-gray-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                    <div class="space-y-4">
                        <div><strong>Title:</strong> ${broadcast.title}</div>
                        <div><strong>Message:</strong> ${broadcast.message}</div>
                        <div><strong>Type:</strong> ${broadcast.type}</div>
                        <div><strong>Recipients:</strong> ${broadcast.recipients}</div>
                        <div><strong>Channels:</strong> ${broadcast.channels || 'N/A'}</div>
                        <div><strong>Sent At:</strong> ${broadcast.sent_at || 'Not sent'}</div>
                        ${broadcast.delivery_results ? `<div><strong>Delivery Results:</strong> <pre class="text-xs bg-gray-100 p-2 rounded">${JSON.stringify(broadcast.delivery_results, null, 2)}</pre></div>` : ''}
                    </div>
                </div>
            </div>
        </div>
    `;
    document.body.appendChild(modal);
}

function populateBroadcastForm(broadcast) {
    const form = document.getElementById('broadcastForm');
    form.querySelector('[name="title"]').value = broadcast.title + ' (Copy)';
    form.querySelector('[name="message"]').value = broadcast.message;
    form.querySelector('[name="type"]').value = broadcast.type;
    form.querySelector('[name="recipients"]').value = broadcast.recipients;
    
    // Clear and set channels
    const channelCheckboxes = form.querySelectorAll('[name="channels[]"]');
    channelCheckboxes.forEach(cb => cb.checked = false);
    
    if (broadcast.channels) {
        const channels = broadcast.channels.split(',');
        channels.forEach(channel => {
            const checkbox = form.querySelector(`[name="channels[]"][value="${channel.trim()}"]`);
            if (checkbox) checkbox.checked = true;
        });
    }
}

// Handle form submission with improved validation
document.getElementById('broadcastForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    // Validate form
    const title = this.querySelector('[name="title"]').value.trim();
    const message = this.querySelector('[name="message"]').value.trim();
    const channels = Array.from(this.querySelectorAll('[name="channels[]"]:checked')).map(cb => cb.value);
    
    if (!title) {
        showNotification('error', 'Please enter a broadcast title');
        return;
    }
    
    if (!message) {
        showNotification('error', 'Please enter a broadcast message');
        return;
    }
    
    if (channels.length === 0) {
        showNotification('error', 'Please select at least one delivery channel');
        return;
    }
    
    const formData = new FormData(this);
    const submitButton = this.querySelector('button[type="submit"]');
    const originalText = submitButton.innerHTML;
    
    submitButton.disabled = true;
    submitButton.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Sending...';
    
    fetch('/admin/settings/notifications/broadcast', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success !== false) {
            showNotification('success', 'Broadcast message sent successfully!');
            closeBroadcastModal();
            setTimeout(() => location.reload(), 1500);
        } else {
            showNotification('error', data.message || 'Failed to send broadcast');
        }
    })
    .catch(error => {
        console.error('Broadcast error:', error);
        showNotification('error', 'Failed to send broadcast: Network error or server issue');
    })
    .finally(() => {
        submitButton.disabled = false;
        submitButton.innerHTML = originalText;
    });
});

// SMTP Configuration Event Listeners
function validateSmtpForm() {
    const form = document.getElementById('smtpConfigForm');
    const host = form.querySelector('[name="smtp_host"]').value.trim();
    const port = form.querySelector('[name="smtp_port"]').value.trim();
    const username = form.querySelector('[name="smtp_username"]').value.trim();
    const password = form.querySelector('[name="smtp_password"]').value.trim();
    const fromAddress = form.querySelector('[name="mail_from_address"]').value.trim();
    const fromName = form.querySelector('[name="mail_from_name"]').value.trim();
    
    const isValid = host && port && username && password && fromAddress && fromName;
    
    // Enable/disable buttons based on validation
    const saveBtn = document.getElementById('saveSmtpConfig');
    const testBtn = document.getElementById('testSmtpConfig');
    const sendTestBtn = document.getElementById('sendTestEmail');
    
    saveBtn.disabled = !isValid;
    testBtn.disabled = !isValid;
    sendTestBtn.disabled = !isValid;
    
    // Add visual feedback
    if (isValid) {
        saveBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        testBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        sendTestBtn.classList.remove('opacity-50', 'cursor-not-allowed');
    } else {
        saveBtn.classList.add('opacity-50', 'cursor-not-allowed');
        testBtn.classList.add('opacity-50', 'cursor-not-allowed');
        sendTestBtn.classList.add('opacity-50', 'cursor-not-allowed');
    }
    
    return isValid;
}

// Add input event listeners for real-time validation
document.addEventListener('DOMContentLoaded', function() {
    const smtpForm = document.getElementById('smtpConfigForm');
    if (smtpForm) {
        const inputs = smtpForm.querySelectorAll('input[required], input[name^="smtp_"], input[name^="mail_"]');
        inputs.forEach(input => {
            input.addEventListener('input', validateSmtpForm);
            input.addEventListener('blur', validateSmtpForm);
        });
        
        // Initial validation
        validateSmtpForm();
    }
});

document.getElementById('saveSmtpConfig').addEventListener('click', function() {
    if (!validateSmtpForm()) {
        showNotification('error', 'Please fill all required SMTP configuration fields.');
        return;
    }
    
    const form = document.getElementById('smtpConfigForm');
    const formData = new FormData(form);
    const button = this;
    const originalText = button.innerHTML;
    
    button.disabled = true;
    button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Saving...';
    
    fetch('/admin/settings/notifications/smtp', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', 'SMTP configuration saved successfully!');
        } else {
            showNotification('error', data.message || 'Failed to save SMTP configuration');
        }
    })
    .catch(error => {
        showNotification('error', 'Error saving SMTP configuration: ' + error.message);
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
        validateSmtpForm(); // Re-enable buttons if form is valid
    });
});

document.getElementById('testSmtpConfig').addEventListener('click', function() {
    if (!validateSmtpForm()) {
        showNotification('error', 'Please fill all required SMTP configuration fields before testing.');
        return;
    }
    
    const button = this;
    const originalText = button.innerHTML;
    
    button.disabled = true;
    button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Testing...';
    
    fetch('/admin/settings/notifications/smtp/test', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', 'SMTP connection test successful!');
        } else {
            showNotification('error', data.message || 'SMTP connection test failed');
        }
    })
    .catch(error => {
        showNotification('error', 'SMTP test failed: ' + error.message);
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
        validateSmtpForm(); // Re-enable buttons if form is valid
    });
});

document.getElementById('sendTestEmail').addEventListener('click', function() {
    if (!validateSmtpForm()) {
        showNotification('error', 'Please fill all required SMTP configuration fields before sending test email.');
        return;
    }
    
    const button = this;
    const originalText = button.innerHTML;
    
    // Prompt for test email address
    const testEmail = prompt('Enter email address to send test email to:');
    if (!testEmail) {
        showNotification('error', 'Test email canceled: no email address entered.');
        return;
    }
    
    // Simple email validation
    if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(testEmail)) {
        showNotification('error', 'Please enter a valid email address');
        return;
    }
    
    button.disabled = true;
    button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Sending...';
    
    fetch('/admin/settings/notifications/smtp/send-test', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            email: testEmail
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', `Test email sent successfully to ${testEmail}!`);
        } else {
            showNotification('error', data.message || 'Failed to send test email');
        }
    })
    .catch(error => {
        showNotification('error', 'Failed to send test email: ' + error.message);
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
        validateSmtpForm(); // Re-enable buttons if form is valid
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/notifications.blade.php ENDPATH**/ ?>