<?php $__env->startSection('title', $page->meta_title ?: $page->title); ?>

<?php $__env->startSection('meta'); ?>
    <?php if($page->meta_description): ?>
    <meta name="description" content="<?php echo e($page->meta_description); ?>">
    <?php endif; ?>
    <meta property="og:title" content="<?php echo e($page->meta_title ?: $page->title); ?>">
    <?php if($page->meta_description): ?>
    <meta property="og:description" content="<?php echo e($page->meta_description); ?>">
    <?php endif; ?>
    <meta property="og:type" content="article">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="mb-8">
            <nav class="text-sm text-gray-500 mb-4">
                <a href="<?php echo e(url('/')); ?>" class="hover:text-gray-700">Home</a>
                <span class="mx-2">/</span>
                <span class="text-gray-900"><?php echo e($page->title); ?></span>
            </nav>
            
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo e($page->title); ?></h1>
            
            <?php if($page->excerpt): ?>
            <p class="text-lg text-gray-600"><?php echo e($page->excerpt); ?></p>
            <?php endif; ?>
            
            <div class="text-sm text-gray-500 mt-4">
                <?php if($page->published_at): ?>
                    Published on <?php echo e($page->published_at->format('F j, Y')); ?>

                <?php endif; ?>
                <?php if($page->updated_at && $page->updated_at->gt($page->published_at)): ?>
                    • Updated <?php echo e($page->updated_at->format('F j, Y')); ?>

                <?php endif; ?>
            </div>
        </div>

        <!-- Page Content -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
            <div class="px-8 py-12">
                <div class="prose prose-lg max-w-none">
                    <?php echo $page->content; ?>

                </div>
            </div>
        </div>

        <!-- Back to Top -->
        <div class="mt-8 text-center">
            <button onclick="window.scrollTo({top: 0, behavior: 'smooth'})" 
                    class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
                </svg>
                Back to Top
            </button>
        </div>
    </div>
</div>

<style>
/* Custom styles for page content */
.prose h1, .prose h2, .prose h3, .prose h4, .prose h5, .prose h6 {
    color: #1f2937;
    font-weight: 600;
}

.prose h1 {
    font-size: 2.25rem;
    margin-top: 0;
    margin-bottom: 1rem;
}

.prose h2 {
    font-size: 1.875rem;
    margin-top: 2rem;
    margin-bottom: 1rem;
}

.prose h3 {
    font-size: 1.5rem;
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
}

.prose p {
    margin-bottom: 1rem;
    line-height: 1.75;
    color: #374151;
}

.prose ul, .prose ol {
    margin-bottom: 1rem;
    padding-left: 1.5rem;
}

.prose li {
    margin-bottom: 0.5rem;
    color: #374151;
}

.prose a {
    color: #3b82f6;
    text-decoration: underline;
}

.prose a:hover {
    color: #1d4ed8;
}

.prose blockquote {
    border-left: 4px solid #e5e7eb;
    padding-left: 1rem;
    margin: 1.5rem 0;
    color: #6b7280;
    font-style: italic;
}

.prose code {
    background-color: #f3f4f6;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    font-size: 0.875rem;
}

.prose pre {
    background-color: #1f2937;
    color: #f9fafb;
    padding: 1rem;
    border-radius: 0.5rem;
    overflow-x: auto;
    margin: 1rem 0;
}

.prose table {
    width: 100%;
    border-collapse: collapse;
    margin: 1rem 0;
}

.prose th, .prose td {
    border: 1px solid #e5e7eb;
    padding: 0.75rem;
    text-align: left;
}

.prose th {
    background-color: #f9fafb;
    font-weight: 600;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/page.blade.php ENDPATH**/ ?>