<!-- Credit Card Modal -->
<div id="creditCardModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-xl bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">Credit Virtual Card</h3>
                <button onclick="hideCreditCardModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
            <form id="creditCardForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <p class="text-sm text-gray-600 mb-2">Card: <span id="creditCardNumber" class="font-medium"></span></p>
                    <p class="text-sm text-gray-600 mb-4">Current Balance: <span id="creditCurrentBalance" class="font-medium"></span></p>
                </div>
                <div class="mb-4">
                    <label for="credit_amount" class="block text-sm font-medium text-gray-700 mb-1">Amount to Credit</label>
                    <input type="number" name="amount" id="credit_amount" step="0.01" min="1" max="1000000" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="mb-4">
                    <label for="credit_description" class="block text-sm font-medium text-gray-700 mb-1">Description (Optional)</label>
                    <textarea name="description" id="credit_description" rows="2" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Reason for credit..."></textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideCreditCardModal()" class="px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors duration-200">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 text-sm font-medium rounded-lg text-white hover:bg-emerald-700 transition-colors duration-200">Credit Card</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Debit Card Modal -->
<div id="debitCardModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-xl bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">Debit Virtual Card</h3>
                <button onclick="hideDebitCardModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
            <form id="debitCardForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <p class="text-sm text-gray-600 mb-2">Card: <span id="debitCardNumber" class="font-medium"></span></p>
                    <p class="text-sm text-gray-600 mb-4">Current Balance: <span id="debitCurrentBalance" class="font-medium"></span></p>
                </div>
                <div class="mb-4">
                    <label for="debit_amount" class="block text-sm font-medium text-gray-700 mb-1">Amount to Debit</label>
                    <input type="number" name="amount" id="debit_amount" step="0.01" min="1" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="mb-4">
                    <label for="debit_description" class="block text-sm font-medium text-gray-700 mb-1">Description (Optional)</label>
                    <textarea name="description" id="debit_description" rows="2" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Reason for debit..."></textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideDebitCardModal()" class="px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors duration-200">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-amber-600 text-sm font-medium rounded-lg text-white hover:bg-amber-700 transition-colors duration-200">Debit Card</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Accept currencyCode as argument
function showCreditModal(cardId, cardNumber, currentBalance, currencyCode) {
    document.getElementById('creditCardNumber').textContent = cardNumber;
    const currencySymbols = {
        'USD': '$', 'NGN': '₦', 'GHS': '₵', 'KES': 'KSh', 'UGX': 'USh'
    };
    const symbol = currencySymbols[currencyCode] || currencyCode || '';
    document.getElementById('creditCurrentBalance').textContent = symbol + currentBalance.toFixed(2);
    document.getElementById('creditCardForm').action = `/admin/virtual-cards/${cardId}/credit`;
    document.getElementById('creditCardModal').classList.remove('hidden');
}

function hideCreditCardModal() {
    document.getElementById('creditCardModal').classList.add('hidden');
}

function showDebitModal(cardId, cardNumber, currentBalance, currencyCode) {
    document.getElementById('debitCardNumber').textContent = cardNumber;
    const currencySymbols = {
        'USD': '$', 'NGN': '₦', 'GHS': '₵', 'KES': 'KSh', 'UGX': 'USh'
    };
    const symbol = currencySymbols[currencyCode] || currencyCode || '';
    document.getElementById('debitCurrentBalance').textContent = symbol + currentBalance.toFixed(2);
    document.getElementById('debit_amount').max = currentBalance;
    document.getElementById('debitCardForm').action = `/admin/virtual-cards/${cardId}/debit`;
    document.getElementById('debitCardModal').classList.remove('hidden');
}

function hideDebitCardModal() {
    document.getElementById('debitCardModal').classList.add('hidden');
}
</script><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/virtual-cards/partials/credit-debit-modals.blade.php ENDPATH**/ ?>