<?php $__env->startSection('title', 'Site Settings'); ?>
<?php $__env->startSection('page-title', 'Site Configuration'); ?>
<?php $__env->startSection('page-description', 'Manage general site settings and configurations'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="mb-8">
            <div class="md:flex md:items-center md:justify-between">
                <div class="min-w-0 flex-1">
                    <h1 class="text-3xl font-bold text-gray-900 sm:text-4xl">Site Configuration</h1>
                    <p class="mt-2 text-lg text-gray-600">Configure your platform settings, features, and integrations</p>
                </div>
                <div class="mt-4 flex md:mt-0 md:ml-4 space-x-3">
                    <button type="button" id="reset-btn" class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                        </svg>
                        Reset to Defaults
                    </button>
                    <button type="submit" form="site-settings-form" id="save-btn" class="inline-flex items-center px-6 py-2 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3-3m0 0l-3 3m3-3v12"></path>
                        </svg>
                        <span id="save-text">Save Changes</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Success/Error Messages -->
        <?php if(session('success')): ?>
            <div id="success-message" class="mb-6 rounded-lg bg-green-50 p-4 border border-green-200">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button type="button" class="inline-flex rounded-md bg-green-50 p-1.5 text-green-500 hover:bg-green-100" id="success-message-close-btn">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div id="error-message" class="mb-6 rounded-lg bg-red-50 p-4 border border-red-200">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-red-800"><?php echo e(session('error')); ?></p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button type="button" class="inline-flex rounded-md bg-red-50 p-1.5 text-red-500 hover:bg-red-100" id="error-message-close">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Main Form -->
        <form id="site-settings-form" action="<?php echo e(route('admin.settings.site.update')); ?>" method="POST" class="space-y-8">
            <?php echo csrf_field(); ?>

            <!-- Business Information Section -->
            <div class="bg-white shadow-sm rounded-xl border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                        Business Information
                    </h2>
                    <p class="mt-1 text-sm text-gray-600">Basic information about your business and platform</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        <div class="space-y-6">
                            <div>
                                <label for="business_name" class="block text-sm font-medium text-gray-700 mb-2">
                                    Business Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       id="business_name"
                                       name="business_name"
                                       value="<?php echo e($settings['business']['name']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="Enter business name"
                                       required>
                            </div>

                            <div>
                                <label for="business_tagline" class="block text-sm font-medium text-gray-700 mb-2">
                                    Tagline
                                </label>
                                <input type="text" 
                                       id="business_tagline"
                                       name="business_tagline"
                                       value="<?php echo e($settings['business']['tagline']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="Enter business tagline">
                            </div>

                            <div>
                                <label for="support_email" class="block text-sm font-medium text-gray-700 mb-2">
                                    Support Email <span class="text-red-500">*</span>
                                </label>
                                <input type="email" 
                                       id="support_email"
                                       name="support_email"
                                       value="<?php echo e($settings['business']['support_email']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="support@example.com"
                                       required>
                            </div>

                            <div>
                                <label for="support_phone" class="block text-sm font-medium text-gray-700 mb-2">
                                    Support Phone <span class="text-red-500">*</span>
                                </label>
                                <input type="tel" 
                                       id="support_phone"
                                       name="support_phone"
                                       value="<?php echo e($settings['business']['support_phone']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="+234 800 000 0000"
                                       required>
                            </div>
                        </div>

                        <div class="space-y-6">
                            <div>
                                <label for="business_description" class="block text-sm font-medium text-gray-700 mb-2">
                                    Description
                                </label>
                                <textarea id="business_description"
                                          name="business_description" 
                                          rows="4" 
                                          class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                          placeholder="Enter business description"><?php echo e($settings['business']['description']); ?></textarea>
                            </div>

                            <div>
                                <label for="business_address" class="block text-sm font-medium text-gray-700 mb-2">
                                    Business Address
                                </label>
                                <textarea id="business_address"
                                          name="business_address" 
                                          rows="3" 
                                          class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                          placeholder="Enter business address"><?php echo e($settings['business']['address']); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Branding & Assets Section -->
            <div class="bg-white shadow-sm rounded-xl border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4V2a1 1 0 011-1h8a1 1 0 011 1v2m2 3H5a2 2 0 00-2 2v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2zM9 10h6m-6 4h6"></path>
                        </svg>
                        Branding & Assets
                    </h2>
                    <p class="mt-1 text-sm text-gray-600">Upload and manage your brand assets like logo and favicon</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        <div class="space-y-6">
                            <div>
                                <label for="logo_url" class="block text-sm font-medium text-gray-700 mb-2">
                                    Logo URL
                                </label>
                                <input type="url" 
                                       id="logo_url"
                                       name="logo_url"
                                       value="<?php echo e($settings['business']['logo']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="https://example.com/logo.png">
                                <p class="mt-1 text-xs text-gray-500">Recommended size: 200x50px, PNG format</p>
                            </div>

                            <div>
                                <label for="favicon_url" class="block text-sm font-medium text-gray-700 mb-2">
                                    Favicon URL
                                </label>
                                <input type="url" 
                                       id="favicon_url"
                                       name="favicon_url"
                                       value="<?php echo e($settings['business']['favicon']); ?>" 
                                       class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200" 
                                       placeholder="https://example.com/favicon.png">
                                <p class="mt-1 text-xs text-gray-500">Recommended size: 32x32px, PNG format</p>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-4">Live Preview</h4>
                            <div class="space-y-4">
                                <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                                    <p class="text-xs font-medium text-gray-600 mb-2">Logo Preview</p>
                                    <div class="h-16 bg-white border border-gray-200 rounded flex items-center justify-center">
                                        <img id="logo-preview" 
                                             src="<?php echo e($settings['business']['logo'] ?: '/images/logo.png'); ?>" 
                                             alt="Logo" 
                                             class="max-h-12 max-w-full object-contain"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                        <span class="text-gray-400 text-xs hidden">No logo</span>
                                    </div>
                                </div>

                                <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                                    <p class="text-xs font-medium text-gray-600 mb-2">Favicon Preview</p>
                                    <div class="h-10 w-10 bg-white border border-gray-200 rounded flex items-center justify-center">
                                        <img id="favicon-preview" 
                                             src="<?php echo e($settings['business']['favicon'] ?: '/images/favicon.png'); ?>" 
                                             alt="Favicon" 
                                             class="max-h-6 max-w-6 object-contain"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                        <span class="text-gray-400 text-xs hidden">No favicon</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Feature Configuration Section -->
            <div class="bg-white shadow-sm rounded-xl border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Feature Configuration
                    </h2>
                    <p class="mt-1 text-sm text-gray-600">Enable or disable platform features - changes take effect immediately</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php
                            $featureConfig = [
                                'enable_wallet_funding' => [
                                    'title' => 'Wallet Funding',
                                    'description' => 'Allow users to fund their wallets via cards and bank transfers'
                                ],
                                'enable_p2p_transfers' => [
                                    'title' => 'P2P Transfers',
                                    'description' => 'Enable peer-to-peer money transfers between users'
                                ],
                                'enable_bank_transfers' => [
                                    'title' => 'Bank Transfers',
                                    'description' => 'Allow transfers to external bank accounts'
                                ],
                                'enable_bill_payments' => [
                                    'title' => 'Bill Payments',
                                    'description' => 'Enable utility and service bill payments'
                                ],
                                'enable_virtual_cards' => [
                                    'title' => 'Virtual Cards',
                                    'description' => 'Allow users to create and manage virtual cards'
                                ],
                                'enable_airtime_data' => [
                                    'title' => 'Airtime & Data',
                                    'description' => 'Enable airtime and data bundle purchases'
                                ],
                                'enable_user_registration' => [
                                    'title' => 'User Registration',
                                    'description' => 'Allow new users to register accounts'
                                ],
                                'maintenance_mode' => [
                                    'title' => 'Maintenance Mode',
                                    'description' => 'Put the site in maintenance mode for updates'
                                ],
                            ];
                        ?>

                        <?php $__currentLoopData = $featureConfig; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="relative p-4 border border-gray-200 rounded-lg hover:border-gray-300 transition-colors duration-200">
                            <div class="flex items-start justify-between">
                                <div class="flex-1 min-w-0">
                                    <h4 class="text-sm font-medium text-gray-900"><?php echo e($config['title']); ?></h4>
                                    <p class="text-xs text-gray-500 mt-1"><?php echo e($config['description']); ?></p>
                                </div>
                                <div class="ml-3 flex-shrink-0">
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" 
                                               name="features[<?php echo e($key); ?>]" 
                                               value="1" 
                                               <?php echo e($settings['features'][$key] ? 'checked' : ''); ?>

                                               class="sr-only peer feature-toggle-checkbox"
                                               data-feature-key="<?php echo e($key); ?>">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <!-- Third-Party Integrations Section -->
            <div class="bg-white shadow-sm rounded-xl border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                        </svg>
                        Third-Party Integrations
                    </h2>
                    <p class="mt-1 text-sm text-gray-600">Configure API providers for different services - only configured providers are shown</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        <?php
                            $integrationConfig = [
                                'sms_provider' => [
                                    'title' => 'SMS Provider',
                                    'description' => 'Provider for SMS notifications and OTP delivery',
                                    'providers' => $availableProviders['sms_providers'] ?? collect()
                                ],
                                'email_provider' => [
                                    'title' => 'Email Provider',
                                    'description' => 'Provider for email notifications and alerts',
                                    'providers' => $availableProviders['email_providers'] ?? collect()
                                ],
                                'payment_gateway' => [
                                    'title' => 'Payment Gateway',
                                    'description' => 'Primary payment processing gateway',
                                    'providers' => $availableProviders['payment_gateways'] ?? collect()
                                ],
                                'identity_provider' => [
                                    'title' => 'Identity Provider',
                                    'description' => 'KYC and identity verification provider',
                                    'providers' => $availableProviders['identity_providers'] ?? collect()
                                ],
                                'card_provider' => [
                                    'title' => 'Card Provider',
                                    'description' => 'Virtual card issuance provider',
                                    'providers' => $availableProviders['card_providers'] ?? collect()
                                ],
                            ];
                        ?>

                        <?php $__currentLoopData = $integrationConfig; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="space-y-2">
                            <label for="integrations_<?php echo e($key); ?>" class="block text-sm font-medium text-gray-700">
                                <?php echo e($config['title']); ?> <span class="text-red-500">*</span>
                            </label>
                            <select name="integrations[<?php echo e($key); ?>]" 
                                    id="integrations_<?php echo e($key); ?>"
                                    class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200"
                                    required>
                                <option value="">Select <?php echo e($config['title']); ?></option>
                                <?php if($config['providers']->count() > 0): ?>
                                    <?php $__currentLoopData = $config['providers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($provider->slug); ?>" 
                                                <?php echo e($settings['integrations'][$key] === $provider->slug ? 'selected' : ''); ?>>
                                            <?php echo e($provider->name); ?>

                                            <?php if($provider->last_test_status === 'success'): ?>
                                                ✓
                                            <?php elseif($provider->last_test_status === 'failed'): ?>
                                                ✗
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <option value="" disabled>No <?php echo e(strtolower($config['title'])); ?>s configured in API Config</option>
                                <?php endif; ?>
                            </select>
                            <p class="text-xs text-gray-500"><?php echo e($config['description']); ?></p>
                            <?php if($config['providers']->count() === 0): ?>
                                <p class="text-xs text-amber-600">
                                    <svg class="w-3 h-3 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                    </svg>
                                    Configure providers in <a href="<?php echo e(route('admin.api-config.index')); ?>" class="underline hover:no-underline">API Config</a> first
                                </p>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <!-- Security Configuration Section -->
            <div class="bg-white shadow-sm rounded-xl border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        Security Configuration
                    </h2>
                    <p class="mt-1 text-sm text-gray-600">Configure security settings and authentication requirements</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        <div class="space-y-6">
                            <h3 class="text-sm font-medium text-gray-900 border-b border-gray-200 pb-2">Session & Authentication</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="session_lifetime" class="block text-sm font-medium text-gray-700 mb-2">
                                        Session Lifetime (minutes)
                                    </label>
                                    <input type="number" 
                                           id="session_lifetime"
                                           name="security[session_lifetime]"
                                           value="<?php echo e($settings['security']['session_lifetime']); ?>" 
                                           min="30" 
                                           max="1440"
                                           class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200"
                                           required>
                                </div>

                                <div>
                                    <label for="password_expiry_days" class="block text-sm font-medium text-gray-700 mb-2">
                                        Password Expiry (days)
                                    </label>
                                    <input type="number" 
                                           id="password_expiry_days"
                                           name="security[password_expiry_days]"
                                           value="<?php echo e($settings['security']['password_expiry_days']); ?>" 
                                           min="0" 
                                           max="365"
                                           class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200"
                                           required>
                                </div>

                                <div>
                                    <label for="max_login_attempts" class="block text-sm font-medium text-gray-700 mb-2">
                                        Max Login Attempts
                                    </label>
                                    <input type="number" 
                                           id="max_login_attempts"
                                           name="security[max_login_attempts]"
                                           value="<?php echo e($settings['security']['max_login_attempts']); ?>" 
                                           min="3" 
                                           max="10"
                                           class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200"
                                           required>
                                </div>

                                <div>
                                    <label for="lockout_duration" class="block text-sm font-medium text-gray-700 mb-2">
                                        Lockout Duration (minutes)
                                    </label>
                                    <input type="number" 
                                           id="lockout_duration"
                                           name="security[lockout_duration]"
                                           value="<?php echo e($settings['security']['lockout_duration']); ?>" 
                                           min="5" 
                                           max="1440"
                                           class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm transition-colors duration-200"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="space-y-6">
                            <h3 class="text-sm font-medium text-gray-900 border-b border-gray-200 pb-2">Verification Requirements</h3>
                            
                            <div class="space-y-4">
                                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                                    <div class="flex-1">
                                        <h4 class="text-sm font-medium text-gray-900">Email Verification</h4>
                                        <p class="text-xs text-gray-500 mt-1">Require users to verify their email before account activation</p>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer ml-4">
                                        <input type="checkbox" 
                                               name="security[require_email_verification]" 
                                               value="1" 
                                               <?php echo e($settings['security']['require_email_verification'] ? 'checked' : ''); ?>

                                               class="sr-only peer">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>

                                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                                    <div class="flex-1">
                                        <h4 class="text-sm font-medium text-gray-900">Phone Verification</h4>
                                        <p class="text-xs text-gray-500 mt-1">Require users to verify their phone number via SMS OTP</p>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer ml-4">
                                        <input type="checkbox" 
                                               name="security[require_phone_verification]" 
                                               value="1" 
                                               <?php echo e($settings['security']['require_phone_verification'] ? 'checked' : ''); ?>

                                               class="sr-only peer">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Toast Notification Container -->
<div id="toast-container" class="fixed bottom-4 right-4 z-50 space-y-2"></div>

<script>
// Modern JavaScript functionality for form handling
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('site-settings-form');
    const saveBtn = document.getElementById('save-btn');
    const saveText = document.getElementById('save-text');
    const resetBtn = document.getElementById('reset-btn');

    // Real-time logo preview update
    document.getElementById('logo_url').addEventListener('input', function(e) {
        const logoPreview = document.getElementById('logo-preview');
        const noLogoText = logoPreview.nextElementSibling;
        
        if (e.target.value) {
            logoPreview.src = e.target.value;
            logoPreview.style.display = 'block';
            noLogoText.style.display = 'none';
        } else {
            logoPreview.style.display = 'none';
            noLogoText.style.display = 'block';
        }
    });

    // Real-time favicon preview update
    document.getElementById('favicon_url').addEventListener('input', function(e) {
        const faviconPreview = document.getElementById('favicon-preview');
        const noFaviconText = faviconPreview.nextElementSibling;
        
        if (e.target.value) {
            faviconPreview.src = e.target.value;
            faviconPreview.style.display = 'block';
            noFaviconText.style.display = 'none';
        } else {
            faviconPreview.style.display = 'none';
            noFaviconText.style.display = 'block';
        }
    });

    // Form submission with AJAX and modern UI feedback
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Show loading state
        saveBtn.disabled = true;
        saveText.textContent = 'Saving...';
        saveBtn.classList.add('opacity-75');

        const formData = new FormData(form);

        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast(data.message, 'success');
                // Auto-reload page after 2 seconds to show changes
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                showToast(data.message || 'An error occurred while saving settings.', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Network error occurred. Please try again.', 'error');
        })
        .finally(() => {
            // Reset button state
            saveBtn.disabled = false;
            saveText.textContent = 'Save Changes';
            saveBtn.classList.remove('opacity-75');
        });
    });

    // Reset functionality
    resetBtn.addEventListener('click', function() {
        if (confirm('Are you sure you want to reset all settings to default values? This action cannot be undone.')) {
            // Reset form to default values - in a real implementation, 
            // this would make an API call to reset to defaults
            showToast('Reset functionality coming soon - please refresh the page to see original values.', 'info');
        }
    });

    // Feature toggle function
    window.toggleFeature = function(feature, enabled) {
        console.log(`Feature ${feature} ${enabled ? 'enabled' : 'disabled'}`);
        // In a real implementation, this could make an instant API call
        // to update the feature status for immediate effect
    };

    // Modern toast notification system
    window.showToast = function(message, type = 'info') {
        const toast = document.createElement('div');
        toast.className = `max-w-sm w-full bg-white shadow-lg rounded-lg pointer-events-auto ring-1 ring-black ring-opacity-5 transform transition-all duration-300 ease-in-out`;
        
        const bgColor = {
            'success': 'bg-green-50 border-green-200',
            'error': 'bg-red-50 border-red-200',
            'warning': 'bg-yellow-50 border-yellow-200',
            'info': 'bg-blue-50 border-blue-200'
        }[type] || 'bg-gray-50 border-gray-200';

        const iconColor = {
            'success': 'text-green-400',
            'error': 'text-red-400',
            'warning': 'text-yellow-400',
            'info': 'text-blue-400'
        }[type] || 'text-gray-400';

        const icon = {
            'success': '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>',
            'error': '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>',
            'warning': '<path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>',
            'info': '<path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>'
        }[type] || '';

        toast.innerHTML = `
            <div class="p-4 border ${bgColor}">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 ${iconColor}" fill="currentColor" viewBox="0 0 20 20">
                            ${icon}
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-gray-900">${message}</p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button type="button" class="inline-flex rounded-md ${bgColor} p-1.5 ${iconColor} hover:bg-opacity-75" onclick="this.closest('.pointer-events-auto').remove()">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        `;

        const container = document.getElementById('toast-container');
        container.appendChild(toast);

        // Auto-remove after 5 seconds
        setTimeout(() => {
            if (toast.parentNode) {
                toast.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    if (toast.parentNode) {
                        toast.remove();
                    }
                }, 300);
            }
        }, 5000);
    };
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/site.blade.php ENDPATH**/ ?>