<?php $__env->startSection('title', 'Airtime & Data Orders'); ?>
<?php $__env->startSection('page-title', 'Airtime & Data Orders'); ?>
<?php $__env->startSection('page-description', 'Monitor and manage all airtime and data purchases'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <?php if(isset($error)): ?>
    <div class="bg-red-50 border border-red-200 rounded-lg p-4">
        <div class="flex">
            <svg class="w-5 h-5 text-red-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
            <div>
                <h3 class="text-sm font-medium text-red-800">Database Error</h3>
                <p class="text-sm text-red-700 mt-1"><?php echo e($error); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <!-- Statistics Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Orders -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Orders</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['total_orders'])); ?></p>
                    <p class="text-sm text-blue-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                            <?php echo e(number_format($stats['today_orders'])); ?> today
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Success Rate -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Success Rate</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format(($stats['successful_orders'] / max($stats['total_orders'], 1)) * 100, 1)); ?>%</p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <?php echo e(number_format($stats['successful_orders'])); ?> successful
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Total Volume -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Volume</p>
                    <p class="text-3xl font-bold text-gray-900">₦<?php echo e(number_format($stats['total_volume'] / 1000000, 1)); ?>M</p>
                    <p class="text-sm text-purple-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                            All time revenue
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Failed Orders -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Failed Orders</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['failed_orders'])); ?></p>
                    <p class="text-sm text-red-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.662-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                            Need attention
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.662-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Service Breakdown and Quick Actions -->
    <div class="grid lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Service Breakdown</h3>
            <div class="space-y-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-blue-500 rounded-full mr-3"></div>
                        <span class="text-sm font-medium text-gray-900">Airtime</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <span class="text-sm text-gray-600"><?php echo e(number_format($stats['airtime_orders'])); ?></span>
                        <div class="w-20 bg-gray-200 rounded-full h-2">
                            <div class="h-2 bg-blue-500 rounded-full" style="width: <?php echo e(($stats['airtime_orders'] / max($stats['total_orders'], 1)) * 100); ?>%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900 w-12 text-right"><?php echo e(number_format(($stats['airtime_orders'] / max($stats['total_orders'], 1)) * 100, 1)); ?>%</span>
                    </div>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full mr-3"></div>
                        <span class="text-sm font-medium text-gray-900">Data</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <span class="text-sm text-gray-600"><?php echo e(number_format($stats['data_orders'])); ?></span>
                        <div class="w-20 bg-gray-200 rounded-full h-2">
                            <div class="h-2 bg-green-500 rounded-full" style="width: <?php echo e(($stats['data_orders'] / max($stats['total_orders'], 1)) * 100); ?>%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900 w-12 text-right"><?php echo e(number_format(($stats['data_orders'] / max($stats['total_orders'], 1)) * 100, 1)); ?>%</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
            <div class="grid grid-cols-2 gap-3">
                <a href="<?php echo e(route('admin.airtime.failed')); ?>" class="flex items-center p-3 bg-red-50 rounded-lg border border-red-200 hover:bg-red-100 transition-colors">
                    <svg class="w-5 h-5 text-red-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.662-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                    </svg>
                    <span class="text-sm font-medium text-red-900">Failed Orders</span>
                </a>
                <a href="<?php echo e(route('admin.airtime.providers')); ?>" class="flex items-center p-3 bg-blue-50 rounded-lg border border-blue-200 hover:bg-blue-100 transition-colors">
                    <svg class="w-5 h-5 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    <span class="text-sm font-medium text-blue-900">Providers</span>
                </a>
                <a href="<?php echo e(route('admin.airtime.margins')); ?>" class="flex items-center p-3 bg-green-50 rounded-lg border border-green-200 hover:bg-green-100 transition-colors">
                    <svg class="w-5 h-5 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                    <span class="text-sm font-medium text-green-900">Margins</span>
                </a>
                <button onclick="exportOrders()" class="flex items-center p-3 bg-gray-50 rounded-lg border border-gray-200 hover:bg-gray-100 transition-colors">
                    <svg class="w-5 h-5 text-gray-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <span class="text-sm font-medium text-gray-900">Export</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="GET" action="<?php echo e(route('admin.airtime.orders')); ?>" class="grid grid-cols-1 md:grid-cols-6 gap-4">
            <!-- Search -->
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" 
                       placeholder="User, reference..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- Category -->
            <div>
                <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Service</label>
                <select name="category" id="category" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Services</option>
                    <option value="airtime" <?php echo e(request('category') === 'airtime' ? 'selected' : ''); ?>>Airtime</option>
                    <option value="data" <?php echo e(request('category') === 'data' ? 'selected' : ''); ?>>Data</option>
                </select>
            </div>

            <!-- Status -->
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" id="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                    <option value="failed" <?php echo e(request('status') === 'failed' ? 'selected' : ''); ?>>Failed</option>
                </select>
            </div>

            <!-- Network -->
            <div>
                <label for="network" class="block text-sm font-medium text-gray-700 mb-1">Network</label>
                <select name="network" id="network" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Networks</option>
                    <option value="mtn" <?php echo e(request('network') === 'mtn' ? 'selected' : ''); ?>>MTN</option>
                    <option value="glo" <?php echo e(request('network') === 'glo' ? 'selected' : ''); ?>>Glo</option>
                    <option value="airtel" <?php echo e(request('network') === 'airtel' ? 'selected' : ''); ?>>Airtel</option>
                    <option value="9mobile" <?php echo e(request('network') === '9mobile' ? 'selected' : ''); ?>>9mobile</option>
                </select>
            </div>

            <!-- Date -->
            <div>
                <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                <input type="date" name="date_from" id="date_from" value="<?php echo e(request('date_from')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- Filter Button -->
            <div class="flex items-end">
                <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors">
                    Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Orders Table -->
    <div id="orders-table" class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">Recent Orders (<?php echo e($orders->total()); ?>)</h3>
        </div>

        <?php if($orders->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Service</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Details</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($order->reference); ?></div>
                            <div class="text-xs text-gray-500">ID: <?php echo e($order->id); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-gradient-to-br from-gray-400 to-gray-500 rounded-full flex items-center justify-center mr-3">
                                    <span class="text-xs font-medium text-white">
                                        <?php echo e(strtoupper(substr($order->user->first_name ?? 'U', 0, 1) . substr($order->user->last_name ?? 'U', 0, 1))); ?>

                                    </span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($order->user->full_name ?? 'Unknown User'); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($order->user->email ?? 'N/A'); ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                                         <?php echo e($order->service_type === 'airtime' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800'); ?>">
                                <?php echo e(ucfirst($order->service_type)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <div><strong>Network:</strong> <?php echo e(strtoupper($order->network ?? 'N/A')); ?></div>
                                <div><strong>Phone:</strong> <?php echo e($order->phone_number ?? 'N/A'); ?></div>
                                <?php if($order->service_type === 'data'): ?>
                                    <div><strong>Provider:</strong> <?php echo e($order->provider_name ?? 'N/A'); ?></div>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">₦<?php echo e(number_format($order->amount, 2)); ?></div>
                            <?php if($order->fee > 0): ?>
                                <div class="text-xs text-gray-500">Fee: ₦<?php echo e(number_format($order->fee, 2)); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                                         <?php echo e($order->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                            ($order->status === 'pending' ? 'bg-amber-100 text-amber-800' : 'bg-red-100 text-red-800')); ?>">
                                <?php echo e(ucfirst($order->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900"><?php echo e($order->created_at->format('M d, Y')); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e($order->created_at->format('H:i:s')); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                            <button onclick="viewOrder(<?php echo e($order->id); ?>)" class="text-blue-600 hover:text-blue-900">View</button>
                            <?php if($order->status === 'failed'): ?>
                                <button onclick="resendOrder(<?php echo e($order->id); ?>)" class="text-green-600 hover:text-green-900">Resend</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 bg-gray-50 border-t">
            <?php echo e($orders->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No orders found</h3>
            <p class="mt-1 text-sm text-gray-500">No orders match your current filters.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function viewOrder(orderId) {
    // Navigate to order details page
    window.location.href = `/admin/transactions/${orderId}`;
}

function resendOrder(orderId) {
    if (confirm('Are you sure you want to resend this failed order?')) {
        const button = event.target.closest('button');
        const originalContent = button.innerHTML;
        button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-1" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Resending...';
        button.disabled = true;

        fetch(`/admin/airtime/${orderId}/resend`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                uiUpdateService.showAlert('success', 'Order queued for retry successfully!');
                setTimeout(() => uiUpdateService.refreshSection('orders-table'), 1500);
            } else {
                uiUpdateService.showAlert('error', data.message || 'Failed to resend order');
            }
        })
        .catch(error => {
            uiUpdateService.showAlert('error', 'Error: ' + error.message);
        })
        .finally(() => {
            button.innerHTML = originalContent;
            button.disabled = false;
        });
    }
}

function exportOrders() {
    // Validate export parameters to prevent URL injection
    const form = document.querySelector('form');
    const formData = new FormData(form);
    
    // Get allowed filter fields from config
    const allowedFields = <?php echo json_encode(config('fintech.export.allowed_filter_fields', []), 512) ?>;
    const maxDateRange = <?php echo json_encode(config('fintech.export.max_date_range', 365), 512) ?>;
    
    // Validate form data
    const validatedParams = new URLSearchParams();
    
    for (const [key, value] of formData.entries()) {
        // Only allow specific fields to prevent injection
        if (allowedFields.includes(key) && value.trim() !== '') {
            // Sanitize the value
            const sanitizedValue = encodeURIComponent(value.trim());
            if (sanitizedValue !== '') {
                validatedParams.append(key, sanitizedValue);
            }
        }
    }
    
    // Validate date range if provided
    const dateFrom = validatedParams.get('date_from');
    const dateTo = validatedParams.get('date_to');
    
    if (dateFrom && dateTo) {
        const fromDate = new Date(dateFrom);
        const toDate = new Date(dateTo);
        const daysDiff = Math.ceil((toDate - fromDate) / (1000 * 60 * 60 * 24));
        
        if (daysDiff > maxDateRange) {
            uiUpdateService.showAlert('error', `Date range cannot exceed ${maxDateRange} days.`);
            return;
        }
        
        if (fromDate > toDate) {
            uiUpdateService.showAlert('error', 'Start date cannot be after end date.');
            return;
        }
    }
    
    // Add export parameter with format validation
    const exportFormats = <?php echo json_encode(config('fintech.export.formats', ['csv']), 512) ?>;
    validatedParams.append('export', 'csv'); // Default to CSV for now
    
    // Create download link with validated parameters
    const downloadLink = document.createElement('a');
    downloadLink.href = `/admin/airtime/orders?${validatedParams.toString()}`;
    downloadLink.download = `airtime_orders_${new Date().toISOString().split('T')[0]}.csv`;
    downloadLink.click();
    
    uiUpdateService.showAlert('success', 'Orders export initiated! Download will start shortly.');
}

</script>

<!-- Include UI Update Service -->
<script src="<?php echo e(asset('js/ui-update-service.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/airtime/orders.blade.php ENDPATH**/ ?>