<?php $__env->startSection('title', 'Wallet Management'); ?>
<?php $__env->startSection('page-title', 'Wallets'); ?>
<?php $__env->startSection('page-description', 'Manage user wallets and balances'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Wallets</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e(number_format($stats['total_wallets'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Wallets</p>
                    <p class="text-2xl font-bold text-emerald-600"><?php echo e(number_format($stats['active_wallets'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Frozen Wallets</p>
                    <p class="text-2xl font-bold text-amber-600"><?php echo e(number_format($stats['frozen_wallets'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Balance</p>
                    <p class="text-xl font-bold text-purple-600">₦<?php echo e(number_format($stats['total_balance'], 2)); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Average Balance</p>
                    <p class="text-xl font-bold text-indigo-600">₦<?php echo e(number_format($stats['average_balance'], 2)); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Search</label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                       placeholder="User name, email..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Statuses</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="frozen" <?php echo e(request('status') === 'frozen' ? 'selected' : ''); ?>>Frozen</option>
                </select>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Min Balance</label>
                <input type="number" name="min_balance" value="<?php echo e(request('min_balance')); ?>" 
                       placeholder="0.00" step="0.01"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Max Balance</label>
                <input type="number" name="max_balance" value="<?php echo e(request('max_balance')); ?>" 
                       placeholder="1000000.00" step="0.01"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div class="flex items-end space-x-2">
                <button type="submit" class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors">
                    Filter
                </button>
                <a href="<?php echo e(route('admin.wallets.index')); ?>" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                    Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Wallets Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">User Wallets (<?php echo e($wallets->total()); ?>)</h3>
                <div class="flex items-center space-x-2">
                    <a href="<?php echo e(route('admin.wallets.transactions')); ?>" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors">
                        View Transactions
                    </a>
                    <a href="<?php echo e(route('admin.wallets.pending-withdrawals')); ?>" class="px-4 py-2 bg-amber-600 text-white rounded-lg hover:bg-amber-700 transition-colors">
                        Pending Withdrawals
                    </a>
                </div>
            </div>
        </div>

        <?php if($wallets->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Activity</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gradient-to-br from-gray-400 to-gray-500 rounded-full flex items-center justify-center mr-3">
                                    <span class="text-sm font-medium text-white">
                                        <?php echo e(strtoupper(substr($wallet->user->first_name, 0, 1) . substr($wallet->user->last_name, 0, 1))); ?>

                                    </span>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-gray-900"><?php echo e($wallet->user->full_name); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo e($wallet->user->email); ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div>
                                <p class="text-sm font-medium text-gray-900">₦<?php echo e(number_format($wallet->balance, 2)); ?></p>
                                <p class="text-xs text-gray-500">Updated <?php echo e($wallet->updated_at->diffForHumans()); ?></p>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                <?php echo e($wallet->is_frozen ? 'bg-red-100 text-red-800' : 'bg-emerald-100 text-emerald-800'); ?>">
                                <?php echo e($wallet->is_frozen ? 'Frozen' : 'Active'); ?>

                            </span>
                            <?php if($wallet->is_frozen && $wallet->freeze_reason): ?>
                                <p class="text-xs text-gray-500 mt-1"><?php echo e(Str::limit($wallet->freeze_reason, 30)); ?></p>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-gray-900"><?php echo e($wallet->updated_at->format('M d, Y')); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($wallet->updated_at->format('H:i')); ?></p>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center justify-center space-x-3">
                                <button onclick="openAdjustBalanceModal(<?php echo e($wallet->id); ?>, '<?php echo e($wallet->user->full_name); ?>', <?php echo e($wallet->balance); ?>)" 
                                        class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Adjust
                                </button>
                                
                                <?php if($wallet->is_frozen): ?>
                                    <button onclick="openUnfreezeModal(<?php echo e($wallet->id); ?>, '<?php echo e($wallet->user->full_name); ?>')" 
                                            class="text-emerald-600 hover:text-emerald-800 text-sm font-medium">
                                        Unfreeze
                                    </button>
                                <?php else: ?>
                                    <button onclick="openFreezeModal(<?php echo e($wallet->id); ?>, '<?php echo e($wallet->user->full_name); ?>')" 
                                            class="text-amber-600 hover:text-amber-800 text-sm font-medium">
                                        Freeze
                                    </button>
                                <?php endif; ?>
                                
                                <a href="<?php echo e(route('admin.users.show', $wallet->user)); ?>" 
                                   class="text-purple-600 hover:text-purple-800 text-sm font-medium">
                                    View User
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($wallets->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
            </svg>
            <h3 class="text-lg font-medium text-gray-900 mb-2">No wallets found</h3>
            <p class="text-gray-500">No wallets match your current filters.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modals would go here for adjust balance, freeze/unfreeze operations -->
<script>
function openAdjustBalanceModal(walletId, userName, currentBalance) {
    // Implementation for adjust balance modal
    alert('Adjust Balance Modal for ' + userName + ' (Current: ₦' + currentBalance + ')');
}

function openFreezeModal(walletId, userName) {
    // Implementation for freeze modal
    alert('Freeze Wallet Modal for ' + userName);
}

function openUnfreezeModal(walletId, userName) {
    // Implementation for unfreeze modal
    alert('Unfreeze Wallet Modal for ' + userName);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/wallets/index.blade.php ENDPATH**/ ?>