<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = User::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'first_name' => fake()->firstName(),
            'last_name' => fake()->lastName(),
            'email' => fake()->unique()->safeEmail(),
            'phone' => '+234' . fake()->numerify('8#########'),
            'email_verified_at' => now(),
            'phone_verified_at' => null,
            'password' => Hash::make('password'), // password
            'remember_token' => Str::random(10),
            'date_of_birth' => fake()->date('Y-m-d', '2000-01-01'),
            'gender' => fake()->randomElement(['male', 'female']),
            'address' => fake()->address(),
            'city' => fake()->city(),
            'state' => fake()->randomElement([
                'Lagos', 'Kano', 'Rivers', 'Kaduna', 'Oyo', 'Imo', 'Anambra',
                'Delta', 'Edo', 'Plateau', 'Osun', 'Ondo', 'Ogun', 'Cross River'
            ]),
            'country' => 'Nigeria',
            'is_active' => true,
            'last_login_at' => null,
            'last_login_ip' => null,
        ];
    }

    /**
     * Indicate that the model's phone number should be verified.
     *
     * @return static
     */
    public function phoneVerified(): static
    {
        return $this->state(fn (array $attributes) => [
            'phone_verified_at' => now(),
        ]);
    }

    /**
     * Indicate that the model's email address should be unverified.
     *
     * @return static
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}