<?php $__env->startSection('title', $apiConfig->name . ' Configuration'); ?>
<?php $__env->startSection('page-title', $apiConfig->name . ' Configuration'); ?>
<?php $__env->startSection('page-description', 'Configure ' . $apiConfig->name . ' API settings and credentials'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header with Actions -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <a href="<?php echo e(route('admin.api-config.index')); ?>" class="text-gray-600 hover:text-gray-800">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900"><?php echo e($apiConfig->name); ?></h1>
                    <p class="text-gray-600"><?php echo e($apiConfig->description); ?></p>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <?php if($apiConfig->is_active): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-emerald-100 text-emerald-800">
                        Active
                    </span>
                <?php else: ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-100 text-gray-800">
                        Inactive
                    </span>
                <?php endif; ?>
                
                <?php if($apiConfig->is_live_mode): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                        Live Mode
                    </span>
                <?php else: ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-amber-100 text-amber-800">
                        Test Mode
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Configuration Form -->
        <div class="lg:col-span-2">
            <form action="<?php echo e(route('admin.api-config.update', $apiConfig)); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <!-- Basic Information -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Service Name</label>
                            <input type="text" name="name" id="name" value="<?php echo e(old('name', $apiConfig->name)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                            <select name="category" id="category" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="payment" <?php echo e($apiConfig->category === 'payment' ? 'selected' : ''); ?>>Payment</option>
                                <option value="identity" <?php echo e($apiConfig->category === 'identity' ? 'selected' : ''); ?>>Identity Verification</option>
                                <option value="messaging" <?php echo e($apiConfig->category === 'messaging' ? 'selected' : ''); ?>>Messaging</option>
                                <option value="utilities" <?php echo e($apiConfig->category === 'utilities' ? 'selected' : ''); ?>>Utilities</option>
                                <option value="banking" <?php echo e($apiConfig->category === 'banking' ? 'selected' : ''); ?>>Banking</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <textarea name="description" id="description" rows="3" 
                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"><?php echo e(old('description', $apiConfig->description)); ?></textarea>
                    </div>
                </div>
                
                <!-- API URLs -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">API Endpoints</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <label for="base_url" class="block text-sm font-medium text-gray-700 mb-1">Base URL</label>
                            <input type="url" name="base_url" id="base_url" value="<?php echo e(old('base_url', $apiConfig->base_url)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                            <?php $__errorArgs = ['base_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="test_url" class="block text-sm font-medium text-gray-700 mb-1">Test/Sandbox URL</label>
                                <input type="url" name="test_url" id="test_url" value="<?php echo e(old('test_url', $apiConfig->test_url)); ?>" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                            
                            <div>
                                <label for="live_url" class="block text-sm font-medium text-gray-700 mb-1">Live/Production URL</label>
                                <input type="url" name="live_url" id="live_url" value="<?php echo e(old('live_url', $apiConfig->live_url)); ?>" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Authentication -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Authentication Credentials</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="api_key" class="block text-sm font-medium text-gray-700 mb-1">API Key</label>
                            <input type="password" name="api_key" id="api_key" value="<?php echo e(old('api_key', $apiConfig->api_key)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <p class="mt-1 text-xs text-gray-500">Leave empty to keep current value</p>
                        </div>
                        
                        <div>
                            <label for="secret_key" class="block text-sm font-medium text-gray-700 mb-1">Secret Key</label>
                            <input type="password" name="secret_key" id="secret_key" value="<?php echo e(old('secret_key', $apiConfig->secret_key)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="public_key" class="block text-sm font-medium text-gray-700 mb-1">Public Key</label>
                            <input type="text" name="public_key" id="public_key" value="<?php echo e(old('public_key', $apiConfig->public_key)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="private_key" class="block text-sm font-medium text-gray-700 mb-1">Private Key</label>
                            <input type="password" name="private_key" id="private_key" value="<?php echo e(old('private_key', $apiConfig->private_key)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="merchant_id" class="block text-sm font-medium text-gray-700 mb-1">Merchant ID</label>
                            <input type="text" name="merchant_id" id="merchant_id" value="<?php echo e(old('merchant_id', $apiConfig->merchant_id)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="client_id" class="block text-sm font-medium text-gray-700 mb-1">Client ID</label>
                            <input type="text" name="client_id" id="client_id" value="<?php echo e(old('client_id', $apiConfig->client_id)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="client_secret" class="block text-sm font-medium text-gray-700 mb-1">Client Secret</label>
                            <input type="password" name="client_secret" id="client_secret" value="<?php echo e(old('client_secret', $apiConfig->client_secret)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                    </div>
                </div>
                
                <!-- Callback URLs -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Callback URLs</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="webhook_url" class="block text-sm font-medium text-gray-700 mb-1">Webhook URL</label>
                            <input type="url" name="webhook_url" id="webhook_url" value="<?php echo e(old('webhook_url', $apiConfig->webhook_url)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="callback_url" class="block text-sm font-medium text-gray-700 mb-1">Callback URL</label>
                            <input type="url" name="callback_url" id="callback_url" value="<?php echo e(old('callback_url', $apiConfig->callback_url)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="return_url" class="block text-sm font-medium text-gray-700 mb-1">Return URL</label>
                            <input type="url" name="return_url" id="return_url" value="<?php echo e(old('return_url', $apiConfig->return_url)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                    </div>
                </div>
                
                <!-- Configuration Settings -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Configuration Settings</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label for="timeout" class="block text-sm font-medium text-gray-700 mb-1">Timeout (seconds)</label>
                            <input type="number" name="config[timeout]" id="timeout" min="5" max="120" 
                                   value="<?php echo e(old('config.timeout', $apiConfig->config['timeout'] ?? 30)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="retry_attempts" class="block text-sm font-medium text-gray-700 mb-1">Retry Attempts</label>
                            <input type="number" name="config[retry_attempts]" id="retry_attempts" min="0" max="5" 
                                   value="<?php echo e(old('config.retry_attempts', $apiConfig->config['retry_attempts'] ?? 3)); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        
                        <div class="flex items-center">
                            <div class="space-y-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $apiConfig->is_active) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    <span class="ml-2 text-sm text-gray-700">Active</span>
                                </label>
                                
                                <label class="flex items-center">
                                    <input type="checkbox" name="is_live_mode" value="1" <?php echo e(old('is_live_mode', $apiConfig->is_live_mode) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    <span class="ml-2 text-sm text-gray-700">Live Mode</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Form Actions -->
                <div class="flex items-center justify-between">
                    <a href="<?php echo e(route('admin.api-config.index')); ?>" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        Cancel
                    </a>
                    
                    <div class="flex items-center space-x-3">
                        <button type="button" onclick="testConnection()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                            Test Connection
                        </button>
                        <button type="submit" class="px-6 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors">
                            Save Configuration
                        </button>
                    </div>
                </div>
            </form>
        </div>
        
        <!-- Sidebar Information -->
        <div class="space-y-6">
            <!-- Generated URLs -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Generated URLs</h3>
                
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Webhook URL</label>
                        <div class="flex items-center">
                            <input type="text" value="<?php echo e($apiConfig->webhook_url); ?>" readonly 
                                   class="flex-1 px-3 py-2 bg-gray-50 border border-gray-300 rounded-l-lg text-sm">
                            <button type="button" onclick="copyToClipboard('<?php echo e($apiConfig->webhook_url); ?>')" 
                                    class="px-3 py-2 bg-gray-200 border border-l-0 border-gray-300 rounded-r-lg hover:bg-gray-300 transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Callback URL</label>
                        <div class="flex items-center">
                            <input type="text" value="<?php echo e($apiConfig->callback_url); ?>" readonly 
                                   class="flex-1 px-3 py-2 bg-gray-50 border border-gray-300 rounded-l-lg text-sm">
                            <button type="button" onclick="copyToClipboard('<?php echo e($apiConfig->callback_url); ?>')" 
                                    class="px-3 py-2 bg-gray-200 border border-l-0 border-gray-300 rounded-r-lg hover:bg-gray-300 transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Status Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Status Information</h3>
                
                <div class="space-y-3">
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">Status</span>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($apiConfig->health_status_class); ?>">
                            <?php echo e($apiConfig->health_status_text); ?>

                        </span>
                    </div>
                    
                    <?php if($apiConfig->last_tested_at): ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">Last Tested</span>
                        <span class="text-sm text-gray-900"><?php echo e($apiConfig->last_tested_at->diffForHumans()); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">Configuration</span>
                        <span class="text-sm text-gray-900">
                            <?php echo e($apiConfig->isConfigured() ? 'Configured' : 'Not Configured'); ?>

                        </span>
                    </div>
                    
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">Updated</span>
                        <span class="text-sm text-gray-900"><?php echo e($apiConfig->updated_at->diffForHumans()); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
                
                <div class="space-y-2">
                    <form action="<?php echo e(route('admin.api-config.toggle-status', $apiConfig)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full px-4 py-2 <?php echo e($apiConfig->is_active ? 'bg-red-600 hover:bg-red-700' : 'bg-emerald-600 hover:bg-emerald-700'); ?> text-white rounded-lg transition-colors">
                            <?php echo e($apiConfig->is_active ? 'Deactivate' : 'Activate'); ?> Service
                        </button>
                    </form>
                    
                    <form action="<?php echo e(route('admin.api-config.toggle-mode', $apiConfig)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full px-4 py-2 <?php echo e($apiConfig->is_live_mode ? 'bg-amber-600 hover:bg-amber-700' : 'bg-blue-600 hover:bg-blue-700'); ?> text-white rounded-lg transition-colors">
                            Switch to <?php echo e($apiConfig->is_live_mode ? 'Test' : 'Live'); ?> Mode
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testConnection() {
    const button = event.target;
    const originalText = button.textContent;
    
    button.disabled = true;
    button.textContent = 'Testing...';
    
    fetch(`<?php echo e(route('admin.api-config.test', $apiConfig)); ?>`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', `Connection test successful (${data.response_time}ms)`);
        } else {
            showNotification('error', `Connection test failed: ${data.error || 'Unknown error'}`);
        }
        
        button.disabled = false;
        button.textContent = originalText;
    })
    .catch(error => {
        showNotification('error', `Connection test failed: ${error.message}`);
        button.disabled = false;
        button.textContent = originalText;
    });
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        showNotification('success', 'URL copied to clipboard');
    }).catch(() => {
        showNotification('error', 'Failed to copy URL');
    });
}

function showNotification(type, message) {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg ${type === 'success' ? 'bg-emerald-500 text-white' : 'bg-red-500 text-white'}`;
    notification.innerHTML = `
        <div class="flex items-center">
            <span>${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white hover:text-gray-200">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 5000);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/work/Fintech/Fintech/resources/views/admin/api-config/show.blade.php ENDPATH**/ ?>