<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name', 'SwiftPay') }}</title>

    @yield('meta')

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Custom CSS -->
    <style>
        .btn-primary {
            @apply bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-secondary {
            @apply bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-success {
            @apply bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-danger {
            @apply bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .form-input {
            @apply shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline;
        }
        .card {
            @apply bg-white shadow-lg rounded-lg p-6 mb-4;
        }
    </style>
</head>
<body class="bg-gray-100 font-sans antialiased">
    <div id="app" class="min-h-screen flex flex-col">
        <!-- Header -->
        @auth
        <header class="bg-blue-600 text-white shadow-md">
            <div class="container mx-auto px-4 py-3">
                <div class="flex justify-between items-center">
                    <div class="flex items-center">
                        <h1 class="text-xl font-bold">{{ config('app.name') }}</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <span class="text-sm">₦{{ number_format(auth()->user()->wallet?->balance ?? 0, 2) }}</span>
                        <button class="md:hidden" onclick="toggleMobileMenu()">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- Navigation -->
        <nav class="bg-blue-700 text-white shadow-md">
            <div class="container mx-auto px-4">
                <div class="hidden md:flex space-x-6 py-2">
                    <a href="{{ route('dashboard') }}" class="hover:text-blue-200 py-2">Dashboard</a>
                    <a href="{{ route('wallet.index') }}" class="hover:text-blue-200 py-2">Wallet</a>
                    <a href="{{ route('transactions.index') }}" class="hover:text-blue-200 py-2">Transactions</a>
                    <a href="{{ route('bills.index') }}" class="hover:text-blue-200 py-2">Bills</a>
                    @if(!auth()->user()->hasCompletedKyc())
                    <a href="{{ route('kyc.index') }}" class="hover:text-blue-200 py-2 text-yellow-300">Complete KYC</a>
                    @endif
                </div>
                <div id="mobile-menu" class="md:hidden hidden">
                    <a href="{{ route('dashboard') }}" class="block hover:bg-blue-600 px-4 py-2">Dashboard</a>
                    <a href="{{ route('wallet.index') }}" class="block hover:bg-blue-600 px-4 py-2">Wallet</a>
                    <a href="{{ route('transactions.index') }}" class="block hover:bg-blue-600 px-4 py-2">Transactions</a>
                    <a href="{{ route('bills.index') }}" class="block hover:bg-blue-600 px-4 py-2">Bills</a>
                    @if(!auth()->user()->hasCompletedKyc())
                    <a href="{{ route('kyc.index') }}" class="block hover:bg-blue-600 px-4 py-2 text-yellow-300">Complete KYC</a>
                    @endif
                    <form method="POST" action="{{ route('logout') }}" class="block">
                        @csrf
                        <button type="submit" class="w-full text-left hover:bg-blue-600 px-4 py-2">Logout</button>
                    </form>
                </div>
            </div>
        </nav>
        @endauth

        <!-- Main Content -->
        <main class="flex-1 container mx-auto px-4 py-6">
            @if(session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    {{ session('error') }}
                </div>
            @endif

            @if($errors->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <ul class="list-disc list-inside">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="bg-gray-800 text-white py-4 mt-auto">
            <div class="container mx-auto px-4 text-center">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
                <p class="text-sm text-gray-400 mt-1">Powered by Laravel • Made for Nigeria</p>
            </div>
        </footer>
    </div>

    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }
    </script>
</body>
</html>