# BillingCS
WHMCS-style Hosting Billing Platform built with Laravel 11

## Overview
BillingCS is a comprehensive hosting billing and client management system built with Laravel 11. It provides a complete solution for hosting providers, including service management, automated billing, support ticketing, and payment processing.

## Features

### Core Features
- **User Management**: Role-based access control (Admin & Client)
- **Service Management**: Manage hosting services, domains, and products
- **Automated Billing**: Recurring invoice generation with multiple billing cycles
- **Payment Gateways**: Modular payment system (PayPal included)
- **Support Tickets**: Integrated ticket system for customer support
- **Multi-Currency**: Support for multiple currencies
- **Multi-Language**: JSON-based translation system
- **Module System**: Extensible module architecture with hooks
- **Template Engine**: Customizable frontend templates/themes

### Technical Features
- Laravel 11 with modern practices
- Breeze authentication with custom Blade layouts
- Tailwind CSS for responsive UI
- RESTful API support
- PDF invoice generation (dompdf)
- Excel export support (maatwebsite/excel)
- Database-driven configuration
- Automated tasks via Artisan commands

## Installation

### Requirements
- PHP 8.2 or higher
- Composer
- Node.js & NPM
- MySQL 8.0+ / MariaDB 10.6+ (recommended for production)

### Setup Instructions

1. **Clone the repository**
   ```bash
   git clone https://github.com/codemol3/BillingCS.git
   cd BillingCS
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Install NPM dependencies**
   ```bash
   npm install
   ```

4. **Environment Configuration**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

5. **Create MySQL Database**
   ```bash
   mysql -u root -p
   CREATE DATABASE billingcs CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   EXIT;
   ```
   
   Configure your `.env` file with MySQL credentials:
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=billingcs
   DB_USERNAME=root
   DB_PASSWORD=your_password
   ```

6. **Run Migrations & Seeders**
   ```bash
   php artisan migrate --seed
   ```

7. **Build Assets**
   ```bash
   npm run dev
   # or for production
   npm run build
   ```

8. **Start Development Server**
   ```bash
   php artisan serve
   ```

9. **Access the Application**
   - Main Site: http://localhost:8000
   - Admin Login: admin@billingcs.com / password
   - Client Login: client@billingcs.com / password

## Project Structure

```
app/
├── Console/Commands/        # Artisan commands for automation
├── Http/
│   ├── Controllers/
│   │   ├── Admin/          # Admin panel controllers
│   │   ├── Api/            # API controllers
│   │   ├── Auth/           # Authentication controllers
│   │   ├── Client/         # Client portal controllers
│   │   └── Module/         # Module controllers
│   └── Middleware/         # Custom middleware
├── Models/                 # Eloquent models
├── Modules/                # Custom modules with hooks
│   ├── Example/            # Example module
│   └── PaymentGateways/    # Payment gateway modules
│       └── PayPal/         # PayPal gateway
├── Services/               # Business logic services
├── Traits/                 # Reusable traits
└── Helpers/                # Helper functions

database/
├── migrations/             # Database migrations
└── seeders/                # Database seeders

resources/
├── css/                    # CSS files
├── js/                     # JavaScript files
├── lang/                   # Multi-language files
└── views/
    ├── admin/              # Admin panel views
    ├── auth/               # Authentication views
    ├── client/             # Client portal views
    ├── emails/             # Email templates
    ├── layouts/            # Layout templates
    └── templates/          # Frontend templates/themes
        └── default/        # Default theme

public/
├── uploads/                # User uploaded files
└── assets/                 # Static assets

storage/
├── app/
│   ├── modules/            # Module data
│   └── uploads/            # Uploaded files
└── logs/                   # Application logs
```

## Configuration

### Multi-Currency Setup
Edit `config/billingcs.php` to add/modify supported currencies:
```php
'currencies' => [
    'USD' => ['symbol' => '$', 'name' => 'US Dollar'],
    'EUR' => ['symbol' => '€', 'name' => 'Euro'],
    // Add more...
],
```

### Payment Gateways
Configure payment gateways in `.env`:
```env
PAYPAL_MODE=sandbox
PAYPAL_CLIENT_ID=your_client_id
PAYPAL_SECRET=your_secret
```

### Module System
Create custom modules in `app/Modules/YourModule/`:
```php
class YourModule {
    public function hooks() {
        return [
            'after_invoice_paid' => [$this, 'handlePaid'],
        ];
    }
}
```

## Automation

Run automated tasks using Artisan commands:

```bash
# Generate recurring invoices
php artisan billing:generate-invoices

# Schedule in crontab for production
* * * * * cd /path-to-project && php artisan schedule:run >> /dev/null 2>&1
```

## API Documentation

API endpoints are available at `/api/*` with authentication:

```bash
# Get services
GET /api/services

# Get invoices
GET /api/invoices

# Get tickets
GET /api/tickets
```

## Testing

Run the test suite:
```bash
php artisan test
```

## Security

- All user passwords are hashed using bcrypt
- CSRF protection enabled on all forms
- SQL injection protection via Eloquent ORM
- XSS protection via Blade templating
- Role-based access control

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

This project is open-source software licensed under the MIT license.

## Support

For issues and questions:
- GitHub Issues: https://github.com/codemol3/BillingCS/issues
- Documentation: See `/docs` folder (coming soon)

## Credits

Built with:
- Laravel 11
- Tailwind CSS
- Alpine.js (optional)
- Laravel Breeze

---

**Note**: This is a foundational implementation. Additional features and enhancements are planned for future releases.
