<?php

if (!function_exists('format_currency')) {
    function format_currency($amount, $currency = null)
    {
        $currency = $currency ?? config('app.default_currency');
        $symbol = config('billingcs.currencies.'.$currency.'.symbol', '$');
        
        return $symbol . number_format($amount, 2);
    }
}

if (!function_exists('setting')) {
    function setting($key, $default = null)
    {
        return \App\Models\Setting::get($key, $default);
    }
}

if (!function_exists('active_template')) {
    function active_template()
    {
        return setting('active_template', config('app.default_theme'));
    }
}
