<?php

namespace App\Http\Controllers\Admin\Billing;

use App\Http\Controllers\Controller;
use App\Models\Dispute;
use App\Models\Transaction;
use Illuminate\Http\Request;

class DisputeController extends Controller
{
    public function index(Request $request)
    {
        $query = Dispute::with(['user', 'transaction', 'invoice']);

        if ($request->has('status')) {
            $query->where('status', $request->get('status'));
        }

        $disputes = $query->latest()->paginate(20);
        
        $stats = [
            'total_disputes' => Dispute::count(),
            'open_disputes' => Dispute::where('status', 'open')->count(),
            'closed_disputes' => Dispute::where('status', 'closed')->count(),
            'disputed_amount' => Dispute::where('status', 'open')->sum('amount'),
        ];
        
        return view('admin.billing.disputes.index', compact('disputes', 'stats'));
    }

    public function show($id)
    {
        $dispute = Dispute::with(['user', 'transaction', 'invoice'])->findOrFail($id);
        
        return view('admin.billing.disputes.show', compact('dispute'));
    }

    public function update(Request $request, $id)
    {
        $dispute = Dispute::findOrFail($id);
        
        $validated = $request->validate([
            'status' => 'required|in:open,closed',
            'response' => 'nullable|string',
        ]);

        $dispute->update($validated);

        return back()->with('success', 'Dispute updated successfully');
    }
}
