<?php

namespace App\Http\Controllers\Admin\Billing;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use App\Models\Invoice;
use Illuminate\Http\Request;

class TransactionController extends Controller
{
    public function index(Request $request)
    {
        $query = Transaction::with(['user', 'invoice']);

        if ($request->has('status')) {
            $query->where('status', $request->get('status'));
        }

        $transactions = $query->latest()->paginate(20);
        
        return view('admin.billing.transactions', compact('transactions'));
    }

    public function gatewayLog()
    {
        $transactions = Transaction::with(['user', 'invoice'])
                                   ->latest()
                                   ->paginate(20);
        
        return view('admin.billing.gateway-log', compact('transactions'));
    }
}
