<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Service;
use App\Models\Invoice;
use App\Models\Ticket;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => User::where('role', 'client')->count(),
            'total_services' => Service::count(),
            'total_invoices' => Invoice::count(),
            'open_tickets' => Ticket::where('status', 'open')->count(),
            'revenue_this_month' => Invoice::where('status', 'paid')
                ->whereMonth('date', now()->month)
                ->sum('total'),
            'revenue_today' => Invoice::where('status', 'paid')
                ->whereDate('date', now())
                ->sum('total'),
            'active_services' => Service::where('status', 'active')->count(),
            'pending_orders' => Service::where('status', 'pending')->count(),
            'cancelled_services' => Service::where('status', 'cancelled')
                ->whereMonth('updated_at', now()->month)
                ->count(),
        ];

        $recent_users = User::where('role', 'client')->latest()->limit(5)->get();
        $recent_invoices = Invoice::with('user')->latest()->limit(5)->get();
        $recent_tickets = Ticket::with('user')->latest()->limit(5)->get();
        $recent_services = Service::with('user')->latest()->limit(5)->get();

        return view('admin.dashboard', compact('stats', 'recent_users', 'recent_invoices', 'recent_tickets', 'recent_services'));
    }
}
