<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ticket;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    public function index() { return view('admin.tickets.index', ['tickets' => Ticket::with('user')->paginate(25)]); }
    public function create() { return view('admin.tickets.create'); }
    public function store(Request $request) { /* implement */ return redirect()->route('admin.tickets.index'); }
    public function show(Ticket $ticket) { return view('admin.tickets.show', compact('ticket')); }
    public function edit(Ticket $ticket) { return view('admin.tickets.edit', compact('ticket')); }
    public function update(Request $request, Ticket $ticket) { /* implement */ return redirect()->route('admin.tickets.index'); }
    public function destroy(Ticket $ticket) { $ticket->delete(); return redirect()->route('admin.tickets.index'); }
}
