<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        
        $services = $user->services()->latest()->limit(5)->get();
        $invoices = $user->invoices()->latest()->limit(5)->get();
        $tickets = $user->tickets()->latest()->limit(5)->get();
        
        // Calculate account balance from successful transactions
        $accountBalance = $user->transactions()
            ->where('status', 'completed')
            ->sum('amount');
        
        // Get domains count (assuming a domains relationship exists or default to 0)
        $domains = collect(); // Empty collection for now
        
        return view('client.dashboard', compact('services', 'invoices', 'tickets', 'accountBalance', 'domains'));
    }
}
