<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index(Request $request)
    {
        $invoices = $request->user()->invoices()->paginate(config('app.items_per_page'));
        
        return view('client.invoices.index', compact('invoices'));
    }

    public function show(Invoice $invoice)
    {
        $this->authorize('view', $invoice);
        
        return view('client.invoices.show', compact('invoice'));
    }

    public function pdf(Invoice $invoice)
    {
        $this->authorize('view', $invoice);
        
        // PDF generation logic would go here
        // Using barryvdh/laravel-dompdf package
        
        return response()->json(['message' => 'PDF generation not yet implemented']);
    }

    public function pay(Request $request, Invoice $invoice)
    {
        $this->authorize('pay', $invoice);
        
        // Payment processing logic would go here
        
        return back()->with('success', 'Payment processed successfully');
    }
}
